/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericColumnDescriptor;
import org.apache.derby.shared.common.util.ArrayUtil;

public final class GenericResultDescription
implements ResultDescription,
Formatable {
    private ResultColumnDescriptor[] columns;
    private String statementType;
    private transient ResultSetMetaData metaData;
    private Map<String, Integer> columnNameMap;

    public GenericResultDescription() {
    }

    public GenericResultDescription(ResultColumnDescriptor[] resultColumnDescriptorArray, String string) {
        this.columns = (ResultColumnDescriptor[])ArrayUtil.copy((Object[])resultColumnDescriptorArray);
        this.statementType = string;
    }

    public GenericResultDescription(ResultDescription resultDescription, int[] nArray) {
        this.columns = new ResultColumnDescriptor[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.columns[i] = resultDescription.getColumnDescriptor(nArray[i]);
        }
        this.statementType = resultDescription.getStatementType();
    }

    @Override
    public String getStatementType() {
        return this.statementType;
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public ResultColumnDescriptor[] getColumnInfo() {
        return (ResultColumnDescriptor[])ArrayUtil.copy((Object[])this.columns);
    }

    @Override
    public ResultColumnDescriptor getColumnInfo(int n) {
        return this.columns[n];
    }

    @Override
    public ResultColumnDescriptor getColumnDescriptor(int n) {
        return this.columns[n - 1];
    }

    @Override
    public ResultDescription truncateColumns(int n) {
        ResultColumnDescriptor[] resultColumnDescriptorArray = new ResultColumnDescriptor[n - 1];
        System.arraycopy(this.columns, 0, resultColumnDescriptorArray, 0, resultColumnDescriptorArray.length);
        return new GenericResultDescription(resultColumnDescriptorArray, this.statementType);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.columns == null ? 0 : this.columns.length;
        objectOutput.writeObject(this.statementType);
        objectOutput.writeInt(n);
        while (n-- > 0) {
            if (!(this.columns[n] instanceof GenericColumnDescriptor)) {
                this.columns[n] = new GenericColumnDescriptor(this.columns[n]);
            }
            objectOutput.writeObject(this.columns[n]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.columns = null;
        this.statementType = (String)objectInput.readObject();
        int n = objectInput.readInt();
        if (n > 0) {
            this.columns = new GenericColumnDescriptor[n];
            while (n-- > 0) {
                this.columns[n] = (ResultColumnDescriptor)objectInput.readObject();
            }
        }
    }

    @Override
    public int getTypeFormatId() {
        return 228;
    }

    public String toString() {
        return "";
    }

    @Override
    public synchronized void setMetaData(ResultSetMetaData resultSetMetaData) {
        if (this.metaData == null) {
            this.metaData = resultSetMetaData;
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumnInsenstive(String string) {
        Map<String, Integer> map;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.columnNameMap == null) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (int i = this.getColumnCount(); i >= 1; --i) {
                    String string2 = StringUtil.SQLToUpperCase(this.getColumnDescriptor(i).getName());
                    Integer n = i;
                    hashMap.put(string2, n);
                }
                this.columnNameMap = Collections.unmodifiableMap(hashMap);
            }
            map = this.columnNameMap;
        }
        serializable = map.get(string);
        if (serializable == null) {
            serializable = map.get(StringUtil.SQLToUpperCase(string));
        }
        if (serializable == null) {
            return -1;
        }
        return (Integer)serializable;
    }
}

