/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ComparisonChain;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(description="Log of something that happened in XL Release.", root=Metadata.ConfigurationItemRoot.APPLICATIONS, versioned=false)
public class ActivityLogEntry
extends BaseConfigurationItem {
    @Property
    private String username;
    @Property
    private String activityType;
    @Property
    private String message;
    @Property
    private Date eventTime;
    @Property
    private String targetType;
    @Property
    private String targetId;
    @Property(required=false)
    private String dataId;
    public static final Comparator<ActivityLogEntry> BY_EVENT_TIME = (left, right) -> ComparisonChain.start().compare((Comparable)left.getEventTime(), (Comparable)right.getEventTime()).result();
    private static final Logger logger = LoggerFactory.getLogger(ActivityLogEntry.class);

    public ActivityLogEntry() {
    }

    public ActivityLogEntry(String activityType, String message) {
        this(new Date(), activityType, null, message, null, null);
    }

    public ActivityLogEntry(Date eventTime, String activityType, String username, String message, String targetType, String targetId) {
        this.eventTime = eventTime;
        this.activityType = activityType;
        this.username = username;
        this.message = message;
        this.targetType = targetType;
        this.targetId = targetId;
    }

    public ActivityLogEntry(Date eventTime, String activityType, String username, String message, String targetType, String targetId, String dataId) {
        this.eventTime = eventTime;
        this.activityType = activityType;
        this.username = username;
        this.message = message;
        this.targetType = targetType;
        this.targetId = targetId;
        this.dataId = dataId;
    }

    @PublicApiMember
    public boolean hasUsername() {
        return this.username != null;
    }

    @PublicApiMember
    public String getUsername() {
        return this.username;
    }

    @PublicApiMember
    public void setUsername(String username) {
        this.username = username;
    }

    @PublicApiMember
    public String getActivityType() {
        return this.activityType;
    }

    @PublicApiMember
    public void setMessage(String message) {
        this.message = message;
    }

    @PublicApiMember
    public String getMessage() {
        return this.message;
    }

    @PublicApiMember
    public Date getEventTime() {
        return this.eventTime;
    }

    @PublicApiMember
    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    @PublicApiMember
    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    @PublicApiMember
    public String getTargetType() {
        return this.targetType;
    }

    @PublicApiMember
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @PublicApiMember
    public String getTargetId() {
        return this.targetId;
    }

    @PublicApiMember
    public String getDataId() {
        return this.dataId;
    }

    @PublicApiMember
    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String toString() {
        return this.message;
    }

    public void logEntryToInfo() {
        HashMap oldMDCContextMap = MDC.getCopyOfContextMap();
        if (oldMDCContextMap == null) {
            oldMDCContextMap = new HashMap();
        }
        try {
            MDC.put((String)"username", (String)this.username);
            MDC.put((String)"activity", (String)this.activityType);
            if (this.targetType != null) {
                MDC.put((String)"targetType", (String)this.targetType);
            }
            if (this.targetId != null) {
                MDC.put((String)"targetId", (String)this.targetId);
            }
            logger.info(this.message);
        }
        finally {
            MDC.setContextMap(oldMDCContextMap);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActivityLogEntry that = (ActivityLogEntry)((Object)o);
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.activityType != null ? !this.activityType.equals(that.activityType) : that.activityType != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.eventTime != null ? !this.eventTime.equals(that.eventTime) : that.eventTime != null) {
            return false;
        }
        if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) {
            return false;
        }
        if (this.targetId != null ? !this.targetId.equals(that.targetId) : that.targetId != null) {
            return false;
        }
        return this.dataId != null ? this.dataId.equals(that.dataId) : that.dataId == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.activityType != null ? this.activityType.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.eventTime != null ? this.eventTime.hashCode() : 0);
        result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
        result = 31 * result + (this.targetId != null ? this.targetId.hashCode() : 0);
        result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
        return result;
    }
}

