/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class UnaryOperatorNode
extends OperatorNode {
    String operator;
    String methodName;
    String resultInterfaceType;
    String receiverInterfaceType;
    ValueNode operand;
    static final int K_XMLPARSE = 0;
    static final int K_XMLSERIALIZE = 1;
    static final int K_BASE = 2;
    final int kind;
    static final String[] UnaryOperators = new String[]{"xmlparse", "xmlserialize"};
    static final String[] UnaryMethodNames = new String[]{"XMLParse", "XMLSerialize"};
    static final String[] UnaryResultTypes = new String[]{"org.apache.derby.iapi.types.XMLDataValue", "org.apache.derby.iapi.types.StringDataValue"};
    static final String[] UnaryArgTypes = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"};
    private DataTypeDescriptor targetType;
    private boolean preserveWhitespace;

    UnaryOperatorNode(ValueNode valueNode, String string, String string2, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.operand = valueNode;
        this.operator = string;
        this.methodName = string2;
        this.kind = 2;
    }

    UnaryOperatorNode(ValueNode valueNode, ContextManager contextManager) {
        super(contextManager);
        this.operand = valueNode;
        this.kind = 2;
    }

    UnaryOperatorNode(ValueNode valueNode, int n, DataTypeDescriptor dataTypeDescriptor, boolean bl, ContextManager contextManager) {
        super(contextManager);
        this.operand = valueNode;
        this.kind = n;
        this.operator = UnaryOperators[this.kind];
        this.methodName = UnaryMethodNames[this.kind];
        this.resultInterfaceType = UnaryResultTypes[this.kind];
        this.receiverInterfaceType = UnaryArgTypes[this.kind];
        if (n == 1) {
            this.targetType = dataTypeDescriptor;
        } else if (n == 0) {
            this.preserveWhitespace = bl;
        }
    }

    void setOperator(String string) {
        this.operator = string;
    }

    String getOperatorString() {
        return this.operator;
    }

    void setMethodName(String string) {
        this.methodName = string;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    ValueNode getOperand() {
        return this.operand;
    }

    ParameterNode getParameterOperand() throws StandardException {
        if (!this.requiresTypeFromContext()) {
            return null;
        }
        UnaryOperatorNode unaryOperatorNode = this;
        while (!(unaryOperatorNode.getOperand() instanceof ParameterNode)) {
            unaryOperatorNode = (UnaryOperatorNode)unaryOperatorNode.getOperand();
        }
        return (ParameterNode)unaryOperatorNode.getOperand();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.bindOperand(fromList, subqueryList, list);
        if (this.kind == 0) {
            this.bindXMLParse();
        } else if (this.kind == 1) {
            this.bindXMLSerialize();
        }
        return this;
    }

    protected void bindOperand(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.operand = this.operand.bindExpression(fromList, subqueryList, list);
        if (this.operand.requiresTypeFromContext()) {
            this.bindParameter();
            if (this.operand.getTypeServices() == null) {
                return;
            }
        }
        if (!(this.operand instanceof UntypedNullConstantNode) && this.operand.getTypeId().userType() && !(this instanceof IsNullNode)) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
    }

    private void bindXMLParse() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (typeId != null) {
            switch (typeId.getJDBCTypeId()) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                default: {
                    throw StandardException.newException((String)"42X25", (Object[])new Object[]{this.methodName, typeId.getSQLTypeName()});
                }
            }
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
    }

    private void bindXMLSerialize() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (typeId != null && !typeId.isXMLTypeId()) {
            throw StandardException.newException((String)"42X25", (Object[])new Object[]{this.methodName, typeId.getSQLTypeName()});
        }
        TypeId typeId2 = this.targetType.getTypeId();
        switch (typeId2.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException((String)"42Z73", (Object[])new Object[]{typeId2.getSQLTypeName()});
            }
        }
        this.setType(this.targetType);
        this.setCollationUsingCompilationSchema();
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.preprocess(n, fromList, subqueryList, predicateList);
        }
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.operand == null ? false : this.operand.categorize(jBitSet, bl);
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.operand == null ? true : this.operand.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return this.operand == null ? true : this.operand.constantExpression(predicateList);
    }

    void bindParameter() throws StandardException {
        if (this.kind == 0) {
            throw StandardException.newException((String)"42Z79", (Object[])new Object[0]);
        }
        if (this.kind == 1) {
            throw StandardException.newException((String)"42Z70", (Object[])new Object[0]);
        }
        if (this.operand.getTypeServices() == null) {
            throw StandardException.newException((String)"42X36", (Object[])new Object[]{this.operator});
        }
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string = this.kind == 2 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        boolean bl = !this.getTypeId().isBooleanTypeId();
        String string2 = this.getReceiverInterfaceName();
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast(string2);
        if (bl) {
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
            methodBuilder.getField(localField);
            int n = 1;
            methodBuilder.callMethod((short)185, null, this.methodName, string, n += this.addXmlOpMethodParams(expressionClassBuilder, methodBuilder, localField));
            methodBuilder.putField(localField);
        } else {
            methodBuilder.callMethod((short)185, null, this.methodName, string, 0);
        }
    }

    String getReceiverInterfaceName() throws StandardException {
        if (this.kind != 2) {
            return this.receiverInterfaceType;
        }
        return this.operand.getTypeCompiler().interfaceName();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.operand != null ? this.operand.getOrderableVariantType() : 3;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.operand != null) {
            this.operand = (ValueNode)this.operand.accept(visitor);
        }
    }

    int addXmlOpMethodParams(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, LocalField localField) throws StandardException {
        if (this.kind != 0 && this.kind != 1) {
            return 0;
        }
        if (this.kind == 1) {
            methodBuilder.push(this.targetType.getJDBCTypeId());
            methodBuilder.push(this.targetType.getMaximumWidth());
            methodBuilder.push(this.getSchemaDescriptor(null, false).getCollationType());
            return 3;
        }
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        expressionClassBuilder.generateNull(methodBuilder2, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        methodBuilder2.setField(localField);
        methodBuilder.swap();
        methodBuilder.push(this.preserveWhitespace);
        UnaryOperatorNode.pushSqlXmlUtil(expressionClassBuilder, methodBuilder, null, null);
        return 2;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeKind(valueNode)) {
            UnaryOperatorNode unaryOperatorNode = (UnaryOperatorNode)valueNode;
            return this.operator.equals(unaryOperatorNode.operator) && (this.operand == unaryOperatorNode.operand || this.operand != null && this.operand.isEquivalent(unaryOperatorNode.operand));
        }
        return false;
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((UnaryOperatorNode)valueNode).kind == this.kind;
    }
}

