/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema;

public enum SourceType {
    METADATA,
    SCRIPT,
    METADATA_THEN_SCRIPT,
    SCRIPT_THEN_METADATA;


    public static SourceType interpret(Object value, SourceType defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof SourceType) {
            return (SourceType)((Object)value);
        }
        String name = value.toString().trim().replace('-', '_');
        if (name.isEmpty()) {
            return METADATA;
        }
        for (SourceType sourceType : SourceType.values()) {
            if (!sourceType.toString().equalsIgnoreCase(name)) continue;
            return sourceType;
        }
        throw new IllegalArgumentException("Unrecognized schema generation source type: '" + value + "'");
    }
}

