import { angularJsDateFormatToMomentFormat, angularJsTimeFormatToMomentFormat } from './constants';
import moment from 'moment';

export function parseDateTimeFormat(date, dateFormat, timeFormat) {
    let format = `${dateFormat} ${timeFormat}`;
    if (angularJsDateFormatToMomentFormat[dateFormat]) {
        format = `${angularJsDateFormatToMomentFormat[dateFormat]}`;
        if (angularJsTimeFormatToMomentFormat[timeFormat]) {
            format = `${format} ${angularJsTimeFormatToMomentFormat[timeFormat]}`;
        } else {
            format = `${format} ${timeFormat}`;
        }
    } else {
        // can't find an appropriate format, use default
        format = `YYYY-MM-DD h:mm A`;
    }
    return format;
}

export function formatDateTime(date, dateFormat, timeFormat) {
    return moment(date).format(parseDateTimeFormat(date, dateFormat, timeFormat));
}
