import React, { Component } from 'react';
import PropTypes from 'prop-types';
import noop from 'lodash/noop';

import { Column, OrderBy } from './constants';
import classNames from 'classnames';
import { InfiniteListHeaderComponent } from './infinite-list-header.component';
import { InfiniteListBodyComponent } from './infinite-list-body.component';

import './infinite-list.component.less';

export class InfiniteListComponent extends Component {
    static propTypes = {
        columns: PropTypes.arrayOf(Column).isRequired,
        listTitle: PropTypes.string.isRequired,
        loadMore: PropTypes.func.isRequired,
        loading: PropTypes.bool.isRequired,
        noData: PropTypes.node.isRequired,
        onChangeOrder: PropTypes.func.isRequired,
        onScrollList: PropTypes.func,
        orderBy: OrderBy,
        renderRow: PropTypes.func.isRequired,
        rows: PropTypes.arrayOf(PropTypes.any).isRequired,
        selectedRows: PropTypes.arrayOf(PropTypes.string).isRequired,
        toggleSelectAll: PropTypes.func.isRequired,
        toggleSelectedRows: PropTypes.func.isRequired,
    };

    static defaultProps = {
        onScrollList: () => noop(),
    };

    renderSpinner() {
        return (
            <div className="spinner">
                <img alt="Loading..." src="static/@project.version@/styles/img/big-ajax-loader.gif" />
            </div>
        );
    }

    render() {
        const {
            loading,
            columns,
            onChangeOrder,
            onScrollList,
            rows,
            noData,
            renderRow,
            listTitle,
            loadMore,
            orderBy,
            toggleSelectedRows,
            toggleSelectAll,
            selectedRows,
        } = this.props;
        const hasRows = !!rows.length;
        return (
            <div className={classNames('infinite-list-container list-view', { 'infinite-list-loading': loading })}>
                <h4 className="list-view-title">{listTitle}</h4>
                {hasRows && (
                    <React.Fragment>
                        <InfiniteListHeaderComponent
                            columns={columns}
                            onChangeOrder={onChangeOrder}
                            orderBy={orderBy}
                            rows={rows}
                            selectedRows={selectedRows}
                            toggleSelectAll={toggleSelectAll}
                        />
                        <InfiniteListBodyComponent
                            loadMore={loadMore}
                            onScrollList={onScrollList}
                            renderRow={renderRow}
                            rows={rows}
                            selectedRows={selectedRows}
                            toggleSelectedRows={toggleSelectedRows}
                        />
                        {loading && this.renderSpinner()}
                    </React.Fragment>
                )}
                {!hasRows && loading && this.renderSpinner()}
                {!hasRows && !loading && <div className="list-view-no-data alert notice">{noData}</div>}
            </div>
        );
    }
}
