/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.management.ServiceStatus;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.WorkerThread;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.service.XlrServiceLifecycle;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.actor.Address;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u0011#\u0001-B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003H\u0011!Y\u0005A!b\u0001\n\u0003a\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t9\u0002\u0011)\u0019!C\u0001;\"AA\r\u0001B\u0001B\u0003%a\f\u0003\u0005f\u0001\t\u0015\r\u0011\"\u0001g\u0011!i\u0007A!A!\u0002\u00139\u0007\u0002\u00038\u0001\u0005\u000b\u0007I\u0011A8\t\u0011M\u0004!\u0011!Q\u0001\nAD\u0001\u0002\u001e\u0001\u0003\u0006\u0004%\t!\u001e\u0005\ts\u0002\u0011\t\u0011)A\u0005m\")!\u0010\u0001C\u0001w\"Q\u0011q\u0006\u0001\t\u0006\u0004%I!!\r\t\u0013\u0005e\u0002A1A\u0005\n\u0005m\u0002\u0002CA+\u0001\u0001\u0006I!!\u0010\t\u0013\u0005]\u0003A1A\u0005\n\u0005e\u0003\u0002CA9\u0001\u0001\u0006I!a\u0017\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBAA\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u0007\u0003A\u0011BA=\u0011\u001d\t)\t\u0001C\u0005\u0003sBq!a\"\u0001\t\u0003\tI\bC\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBA^\u0001\u0011%\u0011Q\u0018\u0002\f/>\u00148.T1oC\u001e,'O\u0003\u0002$I\u0005I1o\u00195fIVdWM\u001d\u0006\u0003K\u0019\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dB\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0013aA2p[\u000e\u00011\u0003\u0002\u0001-eY\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a5\u001b\u0005\u0011\u0013BA\u001b#\u0005AQuN\u0019*fG>4XM]=M_\u001eL7\r\u0005\u00028u5\t\u0001H\u0003\u0002:I\u000591/\u001a:wS\u000e,\u0017BA\u001e9\u0005MAFN]*feZL7-\u001a'jM\u0016\u001c\u0017p\u00197f\u0003%AHN]\"p]\u001aLw-F\u0001?!\ty$)D\u0001A\u0015\t\tE%\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0007\u0002\u0013\u0011\u0002\u00177s\u0007>tg-[4\u0002\u0015ad'oQ8oM&<\u0007%\u0001\u0005k_\n\fV/Z;f+\u00059\u0005CA\u001aI\u0013\tI%E\u0001\u0005K_\n\fV/Z;f\u0003%QwNY)vKV,\u0007%A\bd_6\u0004xn]5uK^{'o[3s+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)#\u0003\u001d9xN]6feNL!AU(\u0003\u001f\r{W\u000e]8tSR,wk\u001c:lKJ\f\u0001cY8na>\u001c\u0018\u000e^3X_J\\WM\u001d\u0011\u0002\u0015)|'mU3sm&\u001cW-F\u0001W!\t9\u0016,D\u0001Y\u0015\tI$%\u0003\u0002[1\nQ!j\u001c2TKJ4\u0018nY3\u0002\u0017)|'mU3sm&\u001cW\rI\u0001\u0014U>\u0014'+\u001e8oKJ\u0014V\r]8tSR|'/_\u000b\u0002=B\u0011qLY\u0007\u0002A*\u0011\u0011\rJ\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA2a\u0005MQuN\u0019*v]:,'OU3q_NLGo\u001c:z\u0003QQwN\u0019*v]:,'OU3q_NLGo\u001c:zA\u0005\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKV\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002kI\u00051\u0011m\u0019;peNL!\u0001\\5\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002)I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3!\u0003E\t7\r^8s'f\u001cH/Z7I_2$WM]\u000b\u0002aB\u0011\u0001.]\u0005\u0003e&\u0014\u0011#Q2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s\u0003I\t7\r^8s'f\u001cH/Z7I_2$WM\u001d\u0011\u0002\u0015QD'/Z1e!>|G.F\u0001w!\t\u0019t/\u0003\u0002yE\tQ\"+Z:uCJ$\u0018M\u00197f\u000bb,7-\u001e;peN+'O^5dK\u0006YA\u000f\u001b:fC\u0012\u0004vn\u001c7!\u0003\u0019a\u0014N\\5u}QqA0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u0001CA\u001a\u0001\u0011\u0015a\u0014\u00031\u0001?\u0011\u0015)\u0015\u00031\u0001H\u0011\u0015Y\u0015\u00031\u0001N\u0011\u0015!\u0016\u00031\u0001W\u0011\u0015a\u0016\u00031\u0001_\u0011\u0015)\u0017\u00031\u0001h\u0011\u0015q\u0017\u00031\u0001q\u0011\u0015!\u0018\u00031\u0001wQ!\tI!!\u0004\u0002*\u0005-\u0002\u0003BA\b\u0003Ki!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\f\u00033\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002\u001c\u0005u\u0011!\u00022fC:\u001c(\u0002BA\u0010\u0003C\tqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003G\t1a\u001c:h\u0013\u0011\t9#!\u0005\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017EAA\u0017\u00039!\u0018m]6.Kb,7-\u001e;j_:\fq\"\\1y)\"\u0014X-\u00193t\u0007>,h\u000e^\u000b\u0003\u0003g\u00012!LA\u001b\u0013\r\t9D\f\u0002\u0004\u0013:$\u0018AE:ikR$wn\u001e8J]B\u0013xn\u001a:fgN,\"!!\u0010\u0011\t\u0005}\u0012\u0011K\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u00051\u0011\r^8nS\u000eTA!a\u0012\u0002J\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005-\u0013QJ\u0001\u0005kRLGN\u0003\u0002\u0002P\u0005!!.\u0019<b\u0013\u0011\t\u0019&!\u0011\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003M\u0019\b.\u001e;e_^t\u0017J\u001c)s_\u001e\u0014Xm]:!\u000359xN]6feRC'/Z1egV\u0011\u00111\f\t\u0007\u0003;\n9'a\u001b\u000e\u0005\u0005}#\u0002BA1\u0003G\nq!\\;uC\ndWMC\u0002\u0002f9\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI'a\u0018\u0003\r\t+hMZ3s!\r\u0019\u0014QN\u0005\u0004\u0003_\u0012#\u0001D,pe.,'\u000f\u00165sK\u0006$\u0017AD<pe.,'\u000f\u00165sK\u0006$7\u000fI\u0001\tO\u0016$xJ\u001d3feR\u0011\u00111G\u0001\bI>\u001cF/\u0019:u)\t\tY\bE\u0002.\u0003{J1!a /\u0005\u0011)f.\u001b;\u0002\u0017I,7m\u001c<fe*{'m]\u0001\rgR\f'\u000f\u001e+ie\u0016\fGm]\u0001\fgR|\u0007oV8sW\u0016\u00148/\u0001\u0004e_N#x\u000e]\u0001\u0007gV\u0014W.\u001b;\u0015\t\u0005m\u0014Q\u0012\u0005\b\u0003\u001fk\u0002\u0019AAI\u0003\rQwN\u0019\t\u0004g\u0005M\u0015bAAKE\t\u0019!j\u001c2\u0002\u000fI,\u0007\u000f\\1dKR!\u00111PAN\u0011\u001d\tyI\ba\u0001\u0003#\u000b\u0001#\u00192peRTuN\u0019\"z)\u0006\u001c8.\u00133\u0015\t\u0005m\u0014\u0011\u0015\u0005\b\u0003G{\u0002\u0019AAS\u0003\u0019!\u0018m]6JIB!\u0011qUA[\u001d\u0011\tI+!-\u0011\u0007\u0005-f&\u0004\u0002\u0002.*\u0019\u0011q\u0016\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019LL\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0016\u0011\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Mf&\u0001\rsKF,Xm\u001d;Sk:tWM\u001d+p\u0003\n|'\u000f\u001e+bg.$B!a\u001f\u0002@\"9\u00111\u0015\u0011A\u0002\u0005\u0015\u0006f\u0001\u0001\u0002DB!\u0011QYAf\u001b\t\t9M\u0003\u0003\u0002J\u0006u\u0011AC:uKJ,w\u000e^=qK&!\u0011QZAd\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class WorkManager
implements JobRecoveryLogic,
XlrServiceLifecycle {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final CompositeWorker compositeWorker;
    private final JobService jobService;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final ActorSystemHolder actorSystemHolder;
    private final RestartableExecutorService threadPool;
    private final AtomicBoolean shutdownInProgress;
    private final Buffer<WorkerThread> workerThreads;
    private Enumeration.Value state;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String serviceName() {
        return XlrServiceLifecycle.serviceName$(this);
    }

    @Override
    public void start() {
        XlrServiceLifecycle.start$(this);
    }

    @Override
    public void awaitStart() {
        XlrServiceLifecycle.awaitStart$(this);
    }

    @Override
    public void stop() {
        XlrServiceLifecycle.stop$(this);
    }

    @Override
    public void awaitStop() {
        XlrServiceLifecycle.awaitStop$(this);
    }

    @Override
    public boolean isRunning() {
        return XlrServiceLifecycle.isRunning$(this);
    }

    @Override
    public ServiceStatus serviceStatus() {
        return XlrServiceLifecycle.serviceStatus$(this);
    }

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String nodeId() {
        return NodeId.nodeId$(this);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Enumeration.Value state() {
        return this.state;
    }

    @Override
    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    @Override
    public JobService jobService() {
        return this.jobService;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    public RestartableExecutorService threadPool() {
        return this.threadPool;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = true;
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        if (!this.bitmap$0) {
            return this.maxThreadsCount$lzycompute();
        }
        return this.maxThreadsCount;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private Buffer<WorkerThread> workerThreads() {
        return this.workerThreads;
    }

    public int getOrder() {
        return 30;
    }

    @Override
    public void doStart() {
        this.doStop();
        this.logger().info((Function0 & Serializable)() -> "Starting work manager with " + this.maxThreadsCount() + " threads");
        this.jobQueue().cancelIf(x$1 -> true);
        this.jobQueue().start();
        if (this.xlrConfig().maintenanceModeEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[MAINTENANCE MODE] Job recovery - DISABLED");
        } else {
            this.recoverJobs();
        }
        this.startThreads();
        this.logger().info((Function0 & Serializable)() -> "Started work manager");
    }

    public void recoverJobs() {
        try {
            this.logger().debug((Function0 & Serializable)() -> "Job recovery started");
            ClusterMode clusterMode = this.xlrConfig().cluster().mode();
            if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                this.recoverAllJobs();
            } else {
                this.recoverJobs(this.nodeId());
                this.recoverJobs(null);
            }
            this.logger().debug((Function0 & Serializable)() -> "Job recovery completed, proceeding with startup");
        }
        catch (Throwable t) {
            this.logger().error((Function0 & Serializable)() -> "Job recovery failed", (Function0 & Serializable)() -> t);
        }
    }

    private void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool().enable();
        this.workerThreads().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            int n = x$2;
            WorkerThread workerThread = new WorkerThread(this.jobQueue(), this.compositeWorker());
            this.workerThreads().$plus$eq((Object)workerThread);
            this.threadPool().execute(workerThread);
        });
    }

    private void stopWorkers() {
        this.workerThreads().foreach((Function1 & Serializable)worker -> {
            worker.stop();
            return BoxedUnit.UNIT;
        });
        this.workerThreads().clear();
        this.jobQueue().stop();
    }

    @Override
    public void doStop() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.stopWorkers();
            this.threadPool().shutdown();
            this.jobQueue().cancelIf(x$3 -> true);
            this.shutdownInProgress().set(false);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "skipping shutdown " + this.serviceName() + ", because shutdown already happened or in progress");
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void replace(Job job) {
        this.jobQueue().replace(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Aborting scheduled job " + taskId);
        this.requestRunnerToAbortTask(taskId);
        this.jobService().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                return taskJob.taskId().equals(taskId);
            }
            return false;
        });
    }

    private void requestRunnerToAbortTask(String taskId) {
        this.jobService().findByTaskId(taskId).foreach((Function1 & Serializable)jobRow -> {
            WorkManager.$anonfun$requestRunnerToAbortTask$1(this, taskId, jobRow);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$requestRunnerToAbortTask$1(WorkManager $this, String taskId$2, JobRow jobRow) {
        JobType jobType = jobRow.jobType();
        JobType jobType2 = JobType.CONTAINER_TASK;
        if (!(jobType != null ? !((Object)((Object)jobType)).equals((Object)jobType2) : jobType2 != null)) {
            if (new .colon.colon((Object)JobStatus.RESERVED, (List)new .colon.colon((Object)JobStatus.RUNNING, (List)Nil$.MODULE$)).contains((Object)jobRow.status()) && jobRow.runnerId() != null) {
                Option<? extends JobRunner> option = $this.jobRunnerRepository().findRunner(jobRow.runnerId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JobRunner runner = (JobRunner)some.value();
                    runner.abortJob(jobRow.id(), jobRow.executionId());
                } else if (None$.MODULE$.equals(option)) {
                    $this.logger().error((Function0 & Serializable)() -> "Can't find runner [" + jobRow.runnerId() + "]. Can't request runner to abort the job [" + jobRow.id() + "]");
                } else {
                    throw new MatchError(option);
                }
                JobStatus jobStatus = jobRow.status();
                JobStatus jobStatus2 = JobStatus.RESERVED;
                if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus2) : jobStatus2 != null)) {
                    $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                    return;
                }
                return;
            }
            JobStatus jobStatus = jobRow.status();
            JobStatus jobStatus3 = JobStatus.QUEUED;
            if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus3) : jobStatus3 != null)) {
                $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                return;
            }
            return;
        }
        LocalJobRunner$.MODULE$.abortJob(jobRow.id(), jobRow.executionId());
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, CompositeWorker compositeWorker, JobService jobService, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, ActorSystemHolder actorSystemHolder, @Qualifier(value="task-execution") RestartableExecutorService threadPool) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.compositeWorker = compositeWorker;
        this.jobService = jobService;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.actorSystemHolder = actorSystemHolder;
        this.threadPool = threadPool;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
        XlrServiceLifecycle.$init$(this);
        this.shutdownInProgress = new AtomicBoolean(false);
        this.workerThreads = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

