/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;
import org.apache.commons.vfs2.provider.res.ResourceFileName;

public class ResourceFileNameParser
extends GenericFileNameParser {
    private static final ResourceFileNameParser INSTANCE = new ResourceFileNameParser();

    public static GenericFileNameParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected String extractRootPrefix(String uri, StringBuilder name) throws FileSystemException {
        int index;
        for (index = 0; index < name.length() && name.charAt(index) == '/'; ++index) {
        }
        if (index > 0) {
            name.delete(0, index);
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new FileSystemException("vfs.provider.res/not-valid-resource-location.error", (Object)uri);
        }
        return "/";
    }

    @Override
    protected FileName createFileName(String scheme, String rootFile, String path, FileType type) {
        return new ResourceFileName(scheme, path, type);
    }
}

