/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.values.GeneratedValueBasicResultBuilder;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.generator.values.internal.TableUpdateReturningBuilder;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.TableInsertReturningBuilder;
import org.hibernate.jdbc.Expectation;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;

public class InsertReturningDelegate
extends AbstractReturningDelegate {
    private final MutatingTableReference tableReference;
    private final List<ColumnReference> generatedColumns;

    @Deprecated(forRemoval=true, since="6.5")
    public InsertReturningDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
        this((EntityPersister)persister, EventType.INSERT);
    }

    public InsertReturningDelegate(EntityPersister persister, EventType timing) {
        super(persister, timing, true, persister.getFactory().getJdbcServices().getDialect().supportsInsertReturningRowId());
        this.tableReference = new MutatingTableReference(persister.getIdentifierTableMapping());
        List<GeneratedValueBasicResultBuilder> resultBuilders = this.jdbcValuesMappingProducer.getResultBuilders();
        this.generatedColumns = new ArrayList<ColumnReference>(resultBuilders.size());
        for (GeneratedValueBasicResultBuilder resultBuilder : resultBuilders) {
            this.generatedColumns.add(new ColumnReference(this.tableReference, (SelectableMapping)GeneratedValuesHelper.getActualGeneratedModelPart(resultBuilder.getModelPart())));
        }
    }

    @Override
    public TableMutationBuilder<?> createTableMutationBuilder(Expectation expectation, SessionFactoryImplementor sessionFactory) {
        if (this.getTiming() == EventType.INSERT) {
            return new TableInsertReturningBuilder(this.persister, this.tableReference, this.generatedColumns, sessionFactory);
        }
        return new TableUpdateReturningBuilder(this.persister, this.tableReference, this.generatedColumns, sessionFactory);
    }

    @Override
    protected GeneratedValues executeAndExtractReturning(String sql, PreparedStatement preparedStatement, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        ResultSet resultSet = jdbcCoordinator.getResultSetReturn().execute(preparedStatement, sql);
        try {
            return GeneratedValuesHelper.getGeneratedValues(resultSet, this.persister, this.getTiming(), session);
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to extract generated key(s) from generated-keys ResultSet", sql);
        }
    }

    @Override
    public String prepareIdentifierGeneratingInsert(String insertSQL) {
        return this.dialect().getIdentityColumnSupport().appendIdentitySelectToInsert(((BasicEntityIdentifierMapping)this.persister.getRootEntityDescriptor().getIdentifierMapping()).getSelectionExpression(), insertSQL);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, SharedSessionContractImplementor session) {
        return session.getJdbcCoordinator().getMutationStatementPreparer().prepareStatement(sql, 2);
    }
}

