/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.OrderableAggregator;
import org.apache.derby.shared.common.error.StandardException;

public class SumAggregator
extends OrderableAggregator {
    @Override
    protected void accumulate(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.value == null) {
            this.value = dataValueDescriptor.cloneValue(false);
        } else {
            NumberDataValue numberDataValue = (NumberDataValue)dataValueDescriptor;
            NumberDataValue numberDataValue2 = (NumberDataValue)this.value;
            this.value = numberDataValue2.plus(numberDataValue, numberDataValue2, numberDataValue2);
        }
    }

    @Override
    public ExecAggregator newAggregator() {
        return new SumAggregator();
    }

    @Override
    public int getTypeFormatId() {
        return 154;
    }

    @Override
    public String toString() {
        try {
            return "SumAggregator: " + this.value.getString();
        }
        catch (StandardException standardException) {
            return super.toString() + ":" + standardException.getMessage();
        }
    }
}

