/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.repository;

import com.google.common.io.CharStreams;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.FacetPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.Date;
import org.springframework.jdbc.core.support.SqlLobValue;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CommonRowAndParamsMapper$ {
    public static final CommonRowAndParamsMapper$ MODULE$ = new CommonRowAndParamsMapper$();
    private static final int SHORT_VARCHAR = 255;
    private static final int LONG_VARCHAR = 1024;
    private static final int URL_VARCHAR = 2084;

    public int SHORT_VARCHAR() {
        return SHORT_VARCHAR;
    }

    public int LONG_VARCHAR() {
        return LONG_VARCHAR;
    }

    public int URL_VARCHAR() {
        return URL_VARCHAR;
    }

    public String commonFieldNames(Schema.TaskRecordTable tableTemplate, String tableAlias) {
        Object prefix = tableAlias.isEmpty() ? "" : tableAlias + ".";
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" " + (String)prefix + tableTemplate.RECORD_ID() + ",\n       | " + (String)prefix + tableTemplate.RECORD_TYPE() + ",\n       | " + (String)prefix + tableTemplate.SERVER_URL() + ",\n       | " + (String)prefix + tableTemplate.SERVER_USER() + ",\n       | " + (String)prefix + tableTemplate.RETRY_ATTEMPT_NUMBER() + ",\n       | " + (String)prefix + tableTemplate.CREATED_VIA_API() + ",\n       | " + (String)prefix + tableTemplate.CREATION_DATE()));
    }

    public String commonFieldNames(Schema.TaskRecordTable tableTemplate) {
        return this.commonFieldNames(tableTemplate, "");
    }

    public String commonParameterNames() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(":recordId,\n       | :recordType,\n       | :serverUrl,\n       | :serverUser,\n       | :retryAttemptNumber,\n       | :createdViaApi,\n       | :creationDate"));
    }

    public void mapCommonFields(ResultSet rs, TaskReportingRecord facet, String targetId, Schema.TaskRecordTable table) {
        facet.setTargetId(targetId);
        facet.setServerUrl(rs.getString(table.SERVER_URL()));
        facet.setServerUser(rs.getString(table.SERVER_USER()));
        facet.setRetryAttemptNumber(rs.getInt(table.RETRY_ATTEMPT_NUMBER()));
        facet.setCreatedViaApi(Utils.RichIntAsBoolean$.MODULE$.asBoolean$extension(Utils$.MODULE$.RichIntAsBoolean(rs.getInt(table.CREATED_VIA_API()))));
        facet.setCreationDate(Date.from(rs.getTimestamp(table.CREATION_DATE()).toInstant()));
    }

    public Map<String, Object> mapCommonParams(TaskReportingRecord facet, Long taskUid) {
        return Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskUid"), (Object)taskUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordId"), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(Ids.getName((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(facet.getId())))), this.SHORT_VARCHAR())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordType"), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(facet.getType().toString()), this.SHORT_VARCHAR())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serverUrl"), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(facet.getServerUrl()), this.URL_VARCHAR())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serverUser"), (Object)Utils.RichStringAsTruncatable$.MODULE$.truncate$extension(Utils$.MODULE$.RichStringAsTruncatable(facet.getServerUser()), this.SHORT_VARCHAR())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"retryAttemptNumber"), (Object)BoxesRunTime.boxToInteger((int)FacetPersistence$.MODULE$.extractRetryAttemptNumber((Facet)facet))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"createdViaApi"), (Object)FacetPersistence$.MODULE$.extractCreatedViaApi((Facet)facet)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"creationDate"), (Object)facet.getCreationDate())}));
    }

    public String readBlobContent(ResultSet rs, String columnName) {
        String string;
        try (InputStream inputStream = rs.getBinaryStream(columnName);){
            string = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        return string;
    }

    public SqlLobValue createSqlLob(String value) {
        byte[] bytes = (byte[])Option$.MODULE$.apply((Object)value).map((Function1 & Serializable)x$1 -> x$1.getBytes(StandardCharsets.UTF_8)).getOrElse((Function0 & Serializable)() -> (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()));
        return new SqlLobValue((InputStream)new ByteArrayInputStream(bytes), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bytes)));
    }

    private CommonRowAndParamsMapper$() {
    }
}

