/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHRepositoryForkBuilder {
    private final GHRepository repo;
    private final Requester req;
    private String organization;
    private String name;
    private Boolean defaultBranchOnly;
    static int FORK_RETRY_INTERVAL = 3000;

    GHRepositoryForkBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = repo.root().createRequest();
    }

    public GHRepositoryForkBuilder defaultBranchOnly(boolean defaultBranchOnly) {
        this.defaultBranchOnly = defaultBranchOnly;
        return this;
    }

    public GHRepositoryForkBuilder organization(GHOrganization organization) {
        this.organization = organization.getLogin();
        return this;
    }

    public GHRepositoryForkBuilder name(String name) {
        this.name = name;
        return this;
    }

    public GHRepository create() throws IOException {
        if (this.defaultBranchOnly != null) {
            this.req.with("default_branch_only", this.defaultBranchOnly);
        }
        if (this.organization != null) {
            this.req.with("organization", this.organization);
        }
        if (this.name != null) {
            this.req.with("name", this.name);
        }
        ((Requester)((Requester)this.req.method("POST")).withUrlPath(this.repo.getApiTailUrl("forks"), new String[0])).send();
        for (int i = 0; i < 10; ++i) {
            GHRepository r = this.lookupForkedRepository();
            if (r != null) {
                return r;
            }
            this.sleep(FORK_RETRY_INTERVAL);
        }
        throw new IOException(this.createTimeoutMessage());
    }

    private GHRepository lookupForkedRepository() throws IOException {
        String repoName;
        String string = repoName = this.name != null ? this.name : this.repo.getName();
        if (this.organization != null) {
            return this.repo.root().getOrganization(this.organization).getRepository(repoName);
        }
        return this.repo.root().getMyself().getRepository(repoName);
    }

    void sleep(int millis) throws IOException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
    }

    String createTimeoutMessage() {
        StringBuilder message = new StringBuilder(this.repo.getFullName());
        message.append(" was forked");
        if (this.organization != null) {
            message.append(" into ").append(this.organization);
        }
        if (this.name != null) {
            message.append(" with name ").append(this.name);
        }
        message.append(" but can't find the new repository");
        return message.toString();
    }
}

