/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.xlrelease.security.XLReleasePermissions;

public interface TeamPermissionOperations {
    public String getTeamName();

    public boolean hasPermission(String var1);

    default public boolean isFolderOwnerTeam() {
        return this.hasPermission(XLReleasePermissions.EDIT_FOLDER_SECURITY.getPermissionName());
    }

    default public boolean isReleaseAdminTeam() {
        return "Release Admin".equals(this.getTeamName());
    }

    default public boolean isTemplateOwnerTeam() {
        return "Template Owner".equals(this.getTeamName());
    }

    default public boolean isFolderAdminTeam() {
        return !this.isFolderOwnerTeam() && this.hasPermission(XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName());
    }

    default public boolean isSystemTeam() {
        return this.isReleaseAdminTeam() || this.isTemplateOwnerTeam() || "Folder Owner".equals(this.getTeamName());
    }
}

