import React from 'react';
import { DotIconWrapper } from '../../../features/common/components/dot-icon-wrapper/dot-icon-wrapper';
import './menu-item.component.less';

interface MenuItemProps {
    endIconId?: string;
    iconId?: string;
    label: string;
}

export const MenuItem = ({ endIconId, label, iconId }: MenuItemProps) => {
    return (
        <div className="menu-item-wrapper">
            {iconId && <DotIconWrapper iconId={iconId} />}
            {label}
            {endIconId && <DotIconWrapper iconId={endIconId} />}
        </div>
    );
};
