/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskCalculator;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\u000e\u001d\u0001\u001dB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000bA\u0004A\u0011A9\t\u000fi\u0004\u0001\u0019!C\u0005w\"I\u0011Q\u0001\u0001A\u0002\u0013%\u0011q\u0001\u0005\b\u0003'\u0001\u0001\u0015)\u0003}\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0015\u0001\t\u0013\tY\u0007C\u0004\u0002~\u0001!\t!a \t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!2\u0001\t\u0013\t9\rC\u0004\u0002P\u0002!I!!5\t\u000f\u0005]\u0007\u0001\"\u0011\u0002Z\"9\u00111\u001c\u0001\u0005B\u0005u\u0007bBAp\u0001\u0011\u0005\u0013Q\u001c\u0005\b\u0003C\u0004A\u0011IAr\u0005-\u0011\u0016n]6TKJ4\u0018nY3\u000b\u0005uq\u0012aB:feZL7-\u001a\u0006\u0003?\u0001\nAA]5tW*\u0011\u0011EI\u0001\nq2\u0014X\r\\3bg\u0016T!a\t\u0013\u0002\u0013a,'-[1mC\n\u001c(\"A\u0013\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001A\u0003'\u000e\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA\u0001\\1oO*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018+\u0005\u0019y%M[3diB\u0011\u0011gM\u0007\u0002e)\u0011Q\u0004I\u0005\u0003iI\u0012aBR3biV\u0014XmU3sm&\u001cW\r\u0005\u00027o5\tA$\u0003\u000299\tq!+[:l\u0007\u0006d7-\u001e7bi>\u0014\u0018A\u0004:jg.\u0014V\r]8tSR|'/\u001f\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{y\t!B]3q_NLGo\u001c:z\u0013\tyDH\u0001\bSSN\\'+\u001a9pg&$xN]=\u0002%IL7o\u001b)s_\u001aLG.Z*feZL7-\u001a\t\u0003m\tK!a\u0011\u000f\u0003%IK7o\u001b)s_\u001aLG.Z*feZL7-Z\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0002\na!Y2u_J\u001c\u0018B\u0001&H\u0005M\u0011V\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\u001b>k\u0011A\u0014\u0006\u0003{\u0001J!\u0001\u0015(\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t!\t\u0019f+D\u0001U\u0015\t)\u0006%\u0001\u0004fm\u0016tGo]\u0005\u0003/R\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003]\u0011\u0018n]6DC2\u001cW\u000f\\1uS>tW\t_3dkR|'\u000f\u0005\u0002[;6\t1L\u0003\u0002]A\u0005I1o\u00195fIVdWM]\u0005\u0003=n\u0013!DU3ti\u0006\u0014H/\u00192mK\u0016CXmY;u_J\u001cVM\u001d<jG\u0016DCA\u00021o_B\u0011\u0011\r\\\u0007\u0002E*\u00111\rZ\u0001\u000bC:tw\u000e^1uS>t'BA3g\u0003\u001d1\u0017m\u0019;pefT!a\u001a5\u0002\u000b\t,\u0017M\\:\u000b\u0005%T\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003-\f1a\u001c:h\u0013\ti'MA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\n\u0001,\u0001\u0004=S:LGO\u0010\u000b\beN$XO^<y!\t1\u0004\u0001C\u0003:\u000f\u0001\u0007!\bC\u0003A\u000f\u0001\u0007\u0011\tC\u0003E\u000f\u0001\u0007Q\tC\u0003L\u000f\u0001\u0007A\nC\u0003R\u000f\u0001\u0007!\u000bC\u0003Y\u000f\u0001\u0007\u0011\f\u000b\u0003yA:|\u0017aB3oC\ndW\rZ\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT\u0011a`\u0001\u0006g\u000e\fG.Y\u0005\u0004\u0003\u0007q(a\u0002\"p_2,\u0017M\\\u0001\fK:\f'\r\\3e?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001cA?\u0002\f%\u0019\u0011Q\u0002@\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003#I\u0011\u0011!a\u0001y\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\u0015t\u0017M\u00197fI\u0002B3ACA\f!\ri\u0018\u0011D\u0005\u0004\u00037q(\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#IL7o[!tg\u0016\u001c8o\u001c:UsB,7/\u0006\u0002\u0002\"A1\u00111EA\u001a\u0003sqA!!\n\u000209!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,\u0019\na\u0001\u0010:p_Rt\u0014\"A@\n\u0007\u0005Eb0A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\u0005\u0019&\u001cHOC\u0002\u00022y\u0004B!a\u000f\u0002N5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0004sK\u001adWm\u0019;\u000b\t\u0005\r\u0013QI\u0001\u0004CBL'\u0002BA$\u0003\u0013\na\u0001\u001d7vO&t'bAA&E\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002P\u0005u\"\u0001\u0002+za\u0016\f!C]5tW\u0006\u001b8/Z:t_J$\u0016\u0010]3tA\u0005i2-\u00197dk2\fG/\u001a*jg.\fe\u000eZ+qI\u0006$XMU3mK\u0006\u001cX\r\u0006\u0003\u0002\n\u0005]\u0003bBA-\u001b\u0001\u0007\u00111L\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004B!!\u0018\u0002f9!\u0011qLA1!\r\t9C`\u0005\u0004\u0003Gr\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002h\u0005%$AB*ue&twMC\u0002\u0002dy$B!!\u0003\u0002n!9\u0011q\u000e\bA\u0002\u0005E\u0014a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011q\u000f\u0011\u0002\r\u0011|W.Y5o\u0013\u0011\tY(!\u001e\u0003\u000fI+G.Z1tK\u0006i1-\u00197dk2\fG/\u001a*jg.$b!!!\u0002\f\u0006=\u0005\u0003BAB\u0003\u000fk!!!\"\u000b\u0007\u0005]d$\u0003\u0003\u0002\n\u0006\u0015%\u0001\u0002*jg.Dq!!$\u0010\u0001\u0004\t\t)\u0001\u0007pe&<\u0017N\\1m%&\u001c8\u000eC\u0004\u0002p=\u0001\r!!\u001d\u0002\u000f\u001d,GOU5tWR!\u0011\u0011QAK\u0011\u001d\tI\u0006\u0005a\u0001\u00037\nabZ3u%&\u001c8\u000e\u0015:pM&dW\r\u0006\u0003\u0002\u001c\u0006\u0005\u0006\u0003BAB\u0003;KA!a(\u0002\u0006\nY!+[:l!J|g-\u001b7f\u0011\u001d\ty'\u0005a\u0001\u0003c\n!\"\u001e9eCR,'+[:l)!\t\t)a*\u0002*\u00065\u0006bBA-%\u0001\u0007\u00111\f\u0005\b\u0003W\u0013\u0002\u0019AAA\u0003!y'/[4j]\u0006d\u0007bBAX%\u0001\u0007\u0011\u0011Q\u0001\bkB$\u0017\r^3e\u0003U\u0011\u0018n]6BgN,7o]7f]R\u001c\u0005.\u00198hK\u0012$R\u0001`A[\u0003sCq!a.\u0014\u0001\u0004\t\t)A\u0001b\u0011\u001d\tYl\u0005a\u0001\u0003\u0003\u000b\u0011AY\u0001\rg\u000e|'/Z\"iC:<W\r\u001a\u000b\u0006y\u0006\u0005\u00171\u0019\u0005\b\u0003o#\u0002\u0019AAA\u0011\u001d\tY\f\u0006a\u0001\u0003\u0003\u000babZ3oKJ\fG/\u001a*jg.LE\r\u0006\u0003\u0002J\u00065\u0007cA\u0015\u0002L&\u0019\u0011q\r\u0016\t\u000f\u0005eS\u00031\u0001\u0002\\\u0005\u0011r-\u001a8fe\u0006$X-Q:tKN\u001cxN]%e)\u0011\tY&a5\t\u000f\u0005Ug\u00031\u0001\u0002\\\u0005a\u0011m]:fgN|'OT1nK\u0006Y1/\u001a:wS\u000e,g*Y7f)\t\tY&A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\n\u0005!1\u000f^8q\u0003%I7OU;o]&tw\rF\u0001}Q\r\u0001\u0011q\u001d\t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q\u001e5\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002r\u0006-(aB*feZL7-\u001a")
public class RiskService
implements FeatureService,
RiskCalculator {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseActorService releaseActorService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    @Qualifier(value="riskCalculationExecutor")
    private final RestartableExecutorService riskCalculationExecutor;
    private volatile boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Risk calculateRisk(RiskProfile profile, List<RiskAssessor> riskAssessors, String riskId, Release release) {
        return RiskCalculator.calculateRisk$(this, profile, riskAssessors, riskId, release);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    public void calculateRiskAndUpdateRelease(String releaseId) {
        if (this.enabled()) {
            Runnable task = () -> {
                Release release = $this.releaseRepository.findById(releaseId);
                this.calculateRiskAndUpdateRelease(release);
            };
            this.riskCalculationExecutor.submit(task);
            return;
        }
    }

    private void calculateRiskAndUpdateRelease(Release release) {
        if (this.enabled()) {
            if (release.isPlannedOrActive() && !release.isWorkflow()) {
                Risk originalRisk = this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
                Risk updatedRisk = this.calculateRisk(originalRisk, release);
                this.updateRisk(release.getId(), originalRisk, updatedRisk);
                return;
            }
            return;
        }
    }

    public Risk calculateRisk(Risk originalRisk, Release release) {
        if (this.enabled() && release.isPlannedOrActive() && !release.isWorkflow()) {
            RiskProfile riskProfileByRelease = this.getRiskProfile(release);
            List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
            String riskId = this.generateRiskId(release.getId());
            return this.calculateRisk(riskProfileByRelease, (List<RiskAssessor>)riskAssessors, riskId, release);
        }
        return originalRisk;
    }

    public Risk getRisk(String releaseId) {
        String riskId = this.generateRiskId(releaseId);
        return this.riskRepository.findByIdOrDefault(riskId);
    }

    private RiskProfile getRiskProfile(Release release) {
        return (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
    }

    public Risk updateRisk(String releaseId, Risk original, Risk updated) {
        block0: {
            if (!this.scoreChanged(original, updated) && !this.riskAssessmentChanged(original, updated)) break block0;
            Object object = original.getRiskAssessments().isEmpty() ? this.riskRepository.create(updated) : BoxesRunTime.boxToBoolean((boolean)this.riskRepository.update(updated));
            this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + original.getScore() + " to " + updated.getScore() + " and total risk score from " + original.getTotalScore() + " to " + updated.getTotalScore())));
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.releaseActorService.updateReleaseRiskScores(releaseId, updated.getScore(), updated.getTotalScore());
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, Option$.MODULE$.apply((Object)original), updated));
        }
        return updated;
    }

    private boolean riskAssessmentChanged(Risk a, Risk b) {
        Function1 & Serializable keyMapping = (Function1 & Serializable)ra -> ra.getRiskAssessorId();
        Function2 & Serializable areEqual = (Function2 & Serializable)(ra1, ra2) -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessmentChanged$2(ra1, ra2));
        Diff diff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(a.getRiskAssessments()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(b.getRiskAssessments()).asScala(), (Function1)keyMapping, (Function2)areEqual);
        return diff.updatedEntries().nonEmpty() || diff.newEntries().nonEmpty() || diff.deletedEntries().nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public String serviceName() {
        return "RiskService";
    }

    public void start() {
        this.enabled_$eq(true);
    }

    public void stop() {
        this.enabled_$eq(false);
    }

    public boolean isRunning() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    private static final boolean safeEquals$1(Object x, Object y) {
        Option option = Option$.MODULE$.apply(x);
        Option option2 = Option$.MODULE$.apply(y);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessmentChanged$2(RiskAssessment ra1, RiskAssessment ra2) {
        return RiskService.safeEquals$1(ra1.getScore(), ra2.getScore()) && RiskService.safeEquals$1(ra1.getHeadline(), ra2.getHeadline()) && RiskService.safeEquals$1(ra1.getMessages(), ra2.getMessages());
    }

    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseActorService releaseActorService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, @Qualifier(value="riskCalculationExecutor") RestartableExecutorService riskCalculationExecutor) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseActorService = releaseActorService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.riskCalculationExecutor = riskCalculationExecutor;
        Logging.$init$((Logging)this);
        RiskCalculator.$init$(this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

