/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$FeaturesSettings$datacenter$stateChangeCoolDown$;
import com.xebialabs.xlrelease.domain.Datacenter;
import com.xebialabs.xlrelease.domain.DatacenterTargetState;
import com.xebialabs.xlrelease.domain.events.DatacenterCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DatacenterDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DatacenterUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.RateLimitReachedException;
import com.xebialabs.xlrelease.repository.DatacenterRepository;
import com.xebialabs.xlrelease.service.DatacenterService$;
import com.xebialabs.xlrelease.service.XlrServiceManager;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\u000f\u001f\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\"\u00025\u0001\t\u0003I\u0007\"C9\u0001\u0001\u0004\u0005\r\u0011\"\u0003s\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\t\u0015\u0005\u0015\u0001\u00011A\u0001B\u0003&1\u000fC\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002.!A\u0011q\t\u0001!\u0002\u0013\ty\u0003C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!a*\u0001\t\u0003\tY\u0005C\u0004\u0002*\u0002!\t!a\u0013\t\u000f\u0005-\u0006\u0001\"\u0001\u0002L!9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\b\u0003\u000b\u0004A\u0011BAd\u000f\u001d\t9N\bE\u0001\u000334a!\b\u0010\t\u0002\u0005m\u0007B\u00025\u001a\t\u0003\ti\u000eC\u0005\u0002`f\u0011\r\u0011\"\u0001\u0002\u0016\"A\u0011\u0011]\r!\u0002\u0013\t9JA\tECR\f7-\u001a8uKJ\u001cVM\u001d<jG\u0016T!a\b\u0011\u0002\u000fM,'O^5dK*\u0011\u0011EI\u0001\nq2\u0014X\r\\3bg\u0016T!a\t\u0013\u0002\u0013a,'-[1mC\n\u001c(\"A\u0013\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nQa\u001d7gi)T\u0011aM\u0001\tOJL'P\u001f7fI&\u0011Q\u0007\r\u0002\b\u0019><w-\u001b8h\u0003Q!\u0017\r^1dK:$XM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0001hO\u0007\u0002s)\u0011!\bI\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001f:\u0005Q!\u0015\r^1dK:$XM\u001d*fa>\u001c\u0018\u000e^8ss\u0006I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0002\naaY8oM&<\u0017BA\"A\u0005%AFN]\"p]\u001aLw-A\u0007uCN\\7k\u00195fIVdWM\u001d\t\u0003\r6k\u0011a\u0012\u0006\u0003\u0011&\u000b!b]2iK\u0012,H.\u001b8h\u0015\tQ5*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005a\u0015aA8sO&\u0011aj\u0012\u0002\u000e)\u0006\u001c8nU2iK\u0012,H.\u001a:)\t\r\u0001&l\u0017\t\u0003#bk\u0011A\u0015\u0006\u0003'R\u000b!\"\u00198o_R\fG/[8o\u0015\t)f+A\u0004gC\u000e$xN]=\u000b\u0005]K\u0015!\u00022fC:\u001c\u0018BA-S\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001E\u0003EAHN]*feZL7-Z'b]\u0006<WM\u001d\t\u0003=~k\u0011AH\u0005\u0003Az\u0011\u0011\u0003\u00177s'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0003!)g/\u001a8u\u0005V\u001c\bCA2g\u001b\u0005!'BA3!\u0003\u0019)g/\u001a8ug&\u0011q\r\u001a\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0004kW2lw\u000e\u001d\t\u0003=\u0002AQA\u000e\u0004A\u0002]BQ!\u0010\u0004A\u0002yBQ\u0001\u0012\u0004A\u0002\u0015CC!\u001c)[7\")AL\u0002a\u0001;\")\u0011M\u0002a\u0001E\u0006\u00012\u000f^1uK\u000eCWmY6GkR,(/Z\u000b\u0002gB\u001aA/!\u0001\u0011\u0007Udh0D\u0001w\u0015\t9\b0\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001f>\u0002\tU$\u0018\u000e\u001c\u0006\u0002w\u0006!!.\u0019<b\u0013\tihOA\bTG\",G-\u001e7fI\u001a+H/\u001e:f!\ry\u0018\u0011\u0001\u0007\u0001\t-\t\u0019!CA\u0001\u0002\u0003\u0015\t!a\u0002\u0003\u0007}#\u0013'A\tti\u0006$Xm\u00115fG.4U\u000f^;sK\u0002\nB!!\u0003\u0002\u0010A\u0019\u0011&a\u0003\n\u0007\u00055!FA\u0004O_RD\u0017N\\4\u0011\u0007%\n\t\"C\u0002\u0002\u0014)\u00121!\u00118z\u0003Q\u0019H/\u0019;f\u0007\",7m\u001b$viV\u0014Xm\u0018\u0013fcR!\u0011\u0011DA\u0010!\rI\u00131D\u0005\u0004\u0003;Q#\u0001B+oSRD\u0011\"!\t\t\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013\u0007\r\u0003\u0002&\u0005%\u0002\u0003B;}\u0003O\u00012a`A\u0015\t1\t\u0019!a\b\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0003I\u0019WO\u001d:f]R$\u0016M]4fiN#\u0018\r^3\u0016\u0005\u0005=\u0002CBA\u0019\u0003o\tY$\u0004\u0002\u00024)\u0019\u0011Q\u0007<\u0002\r\u0005$x.\\5d\u0013\u0011\tI$a\r\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003\u0002\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002F\u0005}\"!\u0006#bi\u0006\u001cWM\u001c;feR\u000b'oZ3u'R\fG/Z\u0001\u0014GV\u0014(/\u001a8u)\u0006\u0014x-\u001a;Ti\u0006$X\rI\u0001\u001em\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y2f]R,'o\u0015;bi\u0016\u001c\u0005.\u00198hKR\u0011\u0011\u0011D\u0001\u0011GJ,\u0017\r^3ECR\f7-\u001a8uKJ$B!!\u0015\u0002XA!\u0011QHA*\u0013\u0011\t)&a\u0010\u0003\u0015\u0011\u000bG/Y2f]R,'\u000fC\u0004\u0002Z5\u0001\r!a\u0017\u0002\u001d\u0011\fG/Y2f]R,'OT1nKB!\u0011QLA6\u001d\u0011\ty&a\u001a\u0011\u0007\u0005\u0005$&\u0004\u0002\u0002d)\u0019\u0011Q\r\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\tIGK\u0001\u0007!J,G-\u001a4\n\t\u00055\u0014q\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%$&\u0001\bhKR$\u0015\r^1dK:$XM]:\u0015\u0005\u0005U\u0004CBA<\u0003\u0003\u000b\tF\u0004\u0003\u0002z\u0005ud\u0002BA1\u0003wJ\u0011aK\u0005\u0004\u0003\u007fR\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\u000b)IA\u0002TKFT1!a +\u0003I\u0019X\r\u001e#bi\u0006\u001cWM\u001c;feN#\u0018\r^3\u0015\r\u0005e\u00111RAH\u0011\u001d\tii\u0004a\u0001\u00037\n!\u0002Z1uC\u000e,g\u000e^3s\u0011\u001d\t\tj\u0004a\u0001\u0003w\tQa\u001d;bi\u0016\f!cZ3u\u0007V\u0014(/\u001a8u+N,'O\\1nKV\u0011\u0011q\u0013\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014>\u0002\t1\fgnZ\u0005\u0005\u0003[\nY*\u0001\teK2,G/\u001a#bi\u0006\u001cWM\u001c;feR!\u0011\u0011DAS\u0011\u001d\ti)\u0005a\u0001\u00037\n!C]3hSN$XM\u001d#bi\u0006\u001cWM\u001c;fe\u0006aRn\u001c8ji>\u0014H)\u0019;bG\u0016tG/\u001a:UCJ<W\r^*uCR,\u0017\u0001E2b]\u000e,Gn\u0015;bi\u0016\u001c\u0005.Z2l\u0003I\u00198\r[3ek2,7\u000b^1uK\u000eCWmY6\u0015\r\u0005e\u0011\u0011WAZ\u0011\u001d\ti)\u0006a\u0001\u00037Bq!!.\u0016\u0001\u0004\tY$\u0001\bpY\u0012$\u0016M]4fiN#\u0018\r^3\u0002#!\fg\u000e\u001a7f'R\fG/Z\"iC:<W\r\u0006\u0005\u0002<\u0005m\u0016QXAa\u0011\u001d\tiI\u0006a\u0001\u00037Bq!a0\u0017\u0001\u0004\tY$\u0001\u0005oK^\u001cF/\u0019;f\u0011\u001d\t\u0019M\u0006a\u0001\u0003k\n\u0011#Y2uSZ,G)\u0019;bG\u0016tG/\u001a:t\u0003E9W\r^*fY\u001a$\u0015\r^1dK:$XM]\u000b\u0003\u00037B3\u0001AAf!\u0011\ti-a5\u000e\u0005\u0005='bAAi\u0013\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0017q\u001a\u0002\b'\u0016\u0014h/[2f\u0003E!\u0015\r^1dK:$XM]*feZL7-\u001a\t\u0003=f\u0019\"!\u0007\u0015\u0015\u0005\u0005e\u0017\u0001\t#B)\u0006\u001bUI\u0014+F%~s\u0015)T#`-\u0006c\u0015\nR!U\u0013>su,\u0012*S\u001fJ\u000b\u0011\u0005R!U\u0003\u000e+e\nV#S?:\u000bU*R0W\u00032KE)\u0011+J\u001f:{VI\u0015*P%\u0002\u0002")
public class DatacenterService
implements Logging {
    private final DatacenterRepository datacenterRepository;
    private final XlrConfig xlrConfig;
    @Qualifier(value="taskScheduler")
    private final TaskScheduler taskScheduler;
    private final XlrServiceManager xlrServiceManager;
    private final XLReleaseEventBus eventBus;
    private ScheduledFuture<?> stateCheckFuture;
    private final AtomicReference<DatacenterTargetState> currentTargetState;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String DATACENTER_NAME_VALIDATION_ERROR() {
        return DatacenterService$.MODULE$.DATACENTER_NAME_VALIDATION_ERROR();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DatacenterService datacenterService = this;
        synchronized (datacenterService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ScheduledFuture<?> stateCheckFuture() {
        return this.stateCheckFuture;
    }

    private void stateCheckFuture_$eq(ScheduledFuture<?> x$1) {
        this.stateCheckFuture = x$1;
    }

    private AtomicReference<DatacenterTargetState> currentTargetState() {
        return this.currentTargetState;
    }

    public void validateDatacenterStateChange() {
        XlrConfig$FeaturesSettings$datacenter$stateChangeCoolDown$ coolDown = this.xlrConfig.features().datacenter().stateChangeCoolDown();
        if (coolDown.enabled()) {
            Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
            Seq nonSystemUpdatedDatacenters = (Seq)((SeqOps)((SeqOps)allDatacenters.filter((Function1 & Serializable)dc -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$validateDatacenterStateChange$1(dc)))).sortBy((Function1 & Serializable)x$2 -> x$2.getUpdatedDate(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse();
            nonSystemUpdatedDatacenters.headOption().foreach((Function1 & Serializable)dc -> {
                DatacenterService.$anonfun$validateDatacenterStateChange$3(this, coolDown, dc);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.logger().trace((Function0 & Serializable)() -> "Datacenter state change cooldown is disabled");
    }

    public Datacenter createDatacenter(String datacenterName) {
        Predef$.MODULE$.require(StringUtils.hasText((String)datacenterName), (Function0 & Serializable)() -> DatacenterService$.MODULE$.DATACENTER_NAME_VALIDATION_ERROR());
        DatacenterTargetState state = DatacenterTargetState.WARM_STANDBY;
        Datacenter datacenter = this.datacenterRepository.create(datacenterName, state, this.getCurrentUsername());
        this.eventBus.publish((XLReleaseEvent)new DatacenterCreatedEvent(datacenterName, state));
        return datacenter;
    }

    public Seq<Datacenter> getDatacenters() {
        return this.datacenterRepository.findAll();
    }

    public void setDatacenterState(String datacenter, DatacenterTargetState state) {
        Predef$.MODULE$.require(StringUtils.hasText((String)datacenter), (Function0 & Serializable)() -> DatacenterService$.MODULE$.DATACENTER_NAME_VALIDATION_ERROR());
        Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
        Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$setDatacenterState$2(x$3)));
        Option existingDatacenter = allDatacenters.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$setDatacenterState$3(datacenter, x$4)));
        boolean bl = false;
        Some some = null;
        Option option = existingDatacenter;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Datacenter dc = (Datacenter)some.value();
            DatacenterTargetState datacenterTargetState = dc.getTargetState();
            DatacenterTargetState datacenterTargetState2 = state;
            if (!(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null)) {
                this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is already in the requested state '" + state + "'.");
                return;
            }
        }
        if (activeDatacenters.nonEmpty()) {
            DatacenterTargetState datacenterTargetState = state;
            DatacenterTargetState datacenterTargetState3 = DatacenterTargetState.ACTIVE;
            if (!(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState3) : datacenterTargetState3 != null)) {
                throw new IllegalStateException("An active datacenter already exists. Cannot set another to ACTIVE.");
            }
        }
        if (bl) {
            Datacenter dc = (Datacenter)some.value();
            this.datacenterRepository.update(datacenter, state, this.getCurrentUsername());
            this.eventBus.publish((XLReleaseEvent)new DatacenterUpdatedEvent(datacenter, dc.getTargetState(), state));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Datacenter '" + datacenter + "' does not exist");
        }
        throw new MatchError((Object)option);
    }

    private String getCurrentUsername() {
        return (String)Option$.MODULE$.apply((Object)User.AUTHENTICATED_USER.getName()).map((Function1 & Serializable)x$5 -> x$5.toLowerCase()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void deleteDatacenter(String datacenter) {
        Predef$.MODULE$.require(StringUtils.hasText((String)datacenter), (Function0 & Serializable)() -> DatacenterService$.MODULE$.DATACENTER_NAME_VALIDATION_ERROR());
        this.datacenterRepository.delete(datacenter);
        this.eventBus.publish((XLReleaseEvent)new DatacenterDeletedEvent(datacenter));
    }

    public void registerDatacenter() {
        String datacenter = this.getSelfDatacenter();
        Option<Datacenter> option = this.datacenterRepository.find(datacenter);
        if (option instanceof Some) {
            this.logger().trace((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' already registered");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            this.logger().info((Function0 & Serializable)() -> "Registering datacenter '" + datacenter + "'");
            DatacenterTargetState state = this.datacenterRepository.count() > 0L ? DatacenterTargetState.WARM_STANDBY : DatacenterTargetState.ACTIVE;
            try {
                this.datacenterRepository.create(datacenter, state, User.SYSTEM.getName());
                this.eventBus.publish((XLReleaseEvent)new DatacenterCreatedEvent(datacenter, state));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Failed to register datacenter '" + datacenter + "'", (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void monitorDatacenterTargetState() {
        String datacenter = this.getSelfDatacenter();
        Seq<Datacenter> allDatacenters = this.datacenterRepository.findAll();
        Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$monitorDatacenterTargetState$1(x$6)));
        DatacenterTargetState requestedTargetState = (DatacenterTargetState)allDatacenters.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$monitorDatacenterTargetState$2(datacenter, x$7))).map((Function1 & Serializable)x$8 -> x$8.getTargetState()).getOrElse((Function0 & Serializable)() -> DatacenterTargetState.WARM_STANDBY);
        DatacenterTargetState actualTargetState = this.handleStateChange(datacenter, requestedTargetState, (Seq<Datacenter>)activeDatacenters);
        if (this.xlrConfig.features().datacenter().stateCheck().enabled()) {
            this.scheduleStateCheck(datacenter, actualTargetState);
            return;
        }
    }

    public void cancelStateCheck() {
        if (this.stateCheckFuture() != null && !this.stateCheckFuture().isCancelled()) {
            this.stateCheckFuture().cancel(true);
            this.logger().trace((Function0 & Serializable)() -> "Cancelled the scheduled datacenter target state check");
            return;
        }
    }

    private void scheduleStateCheck(String datacenter, DatacenterTargetState oldTargetState) {
        this.logger().info((Function0 & Serializable)() -> "Scheduling datacenter target state check for '" + datacenter + "'");
        long checkInterval = this.xlrConfig.features().datacenter().stateCheck().interval().toMillis();
        this.currentTargetState().set(oldTargetState);
        this.stateCheckFuture_$eq(this.taskScheduler.scheduleAtFixedRate(() -> {
            Seq<Datacenter> allDatacenters = $this.datacenterRepository.findAll();
            Seq activeDatacenters = (Seq)allDatacenters.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$scheduleStateCheck$3(x$9)));
            Option thisDatacenter = allDatacenters.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$scheduleStateCheck$4(datacenter, x$10)));
            Option option = thisDatacenter;
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is not registered. Registering now.");
                this.registerDatacenter();
                return;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Datacenter dc = (Datacenter)some.value();
                DatacenterTargetState datacenterTargetState = dc.getTargetState();
                DatacenterTargetState datacenterTargetState2 = this.currentTargetState().get();
                if (datacenterTargetState == null ? datacenterTargetState2 != null : !datacenterTargetState.equals(datacenterTargetState2)) {
                    this.currentTargetState().set(this.handleStateChange(datacenter, dc.getTargetState(), (Seq<Datacenter>)activeDatacenters));
                    return;
                }
                this.logger().trace((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' target state is still '" + this.currentTargetState() + "'");
                return;
            }
            throw new MatchError((Object)option);
        }, Duration.ofMillis(checkInterval)));
    }

    private DatacenterTargetState handleStateChange(String datacenter, DatacenterTargetState newState, Seq<Datacenter> activeDatacenters) {
        this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' target state changed to '" + newState + "'");
        boolean bl = false;
        DatacenterTargetState datacenterTargetState = null;
        DatacenterTargetState datacenterTargetState2 = newState;
        if (DatacenterTargetState.ACTIVE.equals(datacenterTargetState2)) {
            bl = true;
            datacenterTargetState = datacenterTargetState2;
            if (activeDatacenters.size() > 1) {
                this.logger().error((Function0 & Serializable)() -> "Multiple datacenters are in ACTIVE state. Services will not start.");
                return DatacenterTargetState.WARM_STANDBY;
            }
        }
        if (bl) {
            this.logger().info((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is now ACTIVE. Starting services.");
            this.xlrServiceManager.startAsync();
            return DatacenterTargetState.ACTIVE;
        }
        if (DatacenterTargetState.WARM_STANDBY.equals(datacenterTargetState2)) {
            this.logger().warn((Function0 & Serializable)() -> "Datacenter '" + datacenter + "' is no longer ACTIVE. Stopping services.");
            this.xlrServiceManager.stopAsync();
            return DatacenterTargetState.WARM_STANDBY;
        }
        throw new MatchError((Object)datacenterTargetState2);
    }

    private String getSelfDatacenter() {
        return (String)Option$.MODULE$.apply((Object)this.xlrConfig.clusterNode().datacenter()).filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)DatacenterService.$anonfun$getSelfDatacenter$1(str))).map((Function1 & Serializable)x$11 -> x$11.toLowerCase().trim()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Datacenter is not set in the configuration. Set value for 'xl.cluster.node.datacenter' configuration property.");
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateDatacenterStateChange$1(Datacenter dc) {
        return StringUtils.hasText((String)dc.getUpdatedBy());
    }

    public static final /* synthetic */ void $anonfun$validateDatacenterStateChange$3(DatacenterService $this, XlrConfig$FeaturesSettings$datacenter$stateChangeCoolDown$ coolDown$1, Datacenter dc) {
        Duration coolDownPeriod;
        Duration elapsed;
        if (coolDown$1.onlyIfUserChanges()) {
            String string = dc.getUpdatedBy();
            String string2 = $this.getCurrentUsername();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                $this.logger().trace((Function0 & Serializable)() -> "Datacenter state change cooldown is skipped because the user is the same");
                return;
            }
        }
        if ((elapsed = Duration.between(dc.getUpdatedDate(), Instant.now())).compareTo(coolDownPeriod = Duration.ofSeconds(coolDown$1.interval().toSeconds())) < 0) {
            Duration remaining = coolDownPeriod.minus(elapsed);
            throw new RateLimitReachedException("Wait for " + remaining.toSeconds() + " seconds before attempting another state change");
        }
    }

    public static final /* synthetic */ boolean $anonfun$setDatacenterState$2(Datacenter x$3) {
        DatacenterTargetState datacenterTargetState = x$3.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$setDatacenterState$3(String datacenter$1, Datacenter x$4) {
        String string = x$4.getTitle();
        String string2 = datacenter$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$monitorDatacenterTargetState$1(Datacenter x$6) {
        DatacenterTargetState datacenterTargetState = x$6.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$monitorDatacenterTargetState$2(String datacenter$3, Datacenter x$7) {
        String string = x$7.getTitle();
        String string2 = datacenter$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scheduleStateCheck$3(Datacenter x$9) {
        DatacenterTargetState datacenterTargetState = x$9.getTargetState();
        DatacenterTargetState datacenterTargetState2 = DatacenterTargetState.ACTIVE;
        return !(datacenterTargetState != null ? !datacenterTargetState.equals(datacenterTargetState2) : datacenterTargetState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scheduleStateCheck$4(String datacenter$4, Datacenter x$10) {
        String string = x$10.getTitle();
        String string2 = datacenter$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSelfDatacenter$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public DatacenterService(DatacenterRepository datacenterRepository, XlrConfig xlrConfig, @Qualifier(value="taskScheduler") TaskScheduler taskScheduler, XlrServiceManager xlrServiceManager, XLReleaseEventBus eventBus) {
        this.datacenterRepository = datacenterRepository;
        this.xlrConfig = xlrConfig;
        this.taskScheduler = taskScheduler;
        this.xlrServiceManager = xlrServiceManager;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.currentTargetState = new AtomicReference();
    }
}

