/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.List;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.catalog.types.UDTAliasInfo;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class CreateAliasNode
extends DDLStatementNode {
    public static final int PARAMETER_ARRAY = 0;
    public static final int TABLE_NAME = 1;
    public static final int DYNAMIC_RESULT_SET_COUNT = 2;
    public static final int LANGUAGE = 3;
    public static final int EXTERNAL_NAME = 4;
    public static final int PARAMETER_STYLE = 5;
    public static final int SQL_CONTROL = 6;
    public static final int DETERMINISTIC = 7;
    public static final int NULL_ON_NULL_INPUT = 8;
    public static final int RETURN_TYPE = 9;
    public static final int ROUTINE_SECURITY_DEFINER = 10;
    public static final int VARARGS = 11;
    public static final int ROUTINE_ELEMENT_COUNT = 12;
    private static final String[] NON_RESERVED_FUNCTION_NAMES = new String[]{"ABS", "ABSVAL", "DATE", "DAY", "LCASE", "LENGTH", "MONTH", "SQRT", "TIME", "TIMESTAMP", "UCASE"};
    private static final String[] NON_RESERVED_AGGREGATES = new String[]{"COLLECT", "COUNT", "EVERY", "FUSION", "INTERSECTION", "STDDEV_POP", "STDDEV_SAMP", "VAR_POP", "VAR_SAMP"};
    public static final int AGG_FOR_TYPE = 0;
    public static final int AGG_RETURN_TYPE = 1;
    public static final int AGG_ELEMENT_COUNT = 2;
    private String javaClassName;
    private String methodName;
    private char aliasType;
    private AliasInfo aliasInfo;

    CreateAliasNode(TableName tableName, Object object, String string, Object object2, char c, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.aliasType = c;
        switch (this.aliasType) {
            case 'G': {
                this.javaClassName = (String)object;
                Object[] objectArray = (Object[])object2;
                TypeDescriptor typeDescriptor = this.bindUserCatalogType((TypeDescriptor)objectArray[0]);
                TypeDescriptor typeDescriptor2 = this.bindUserCatalogType((TypeDescriptor)objectArray[1]);
                if (typeDescriptor.getJDBCTypeId() == 2009 || typeDescriptor2.getJDBCTypeId() == 2009) {
                    throw StandardException.newException((String)"42ZB3", (Object[])new Object[0]);
                }
                this.aliasInfo = new AggregateAliasInfo(typeDescriptor, typeDescriptor2);
                this.implicitCreateSchema = true;
                break;
            }
            case 'A': {
                this.javaClassName = (String)object;
                this.aliasInfo = new UDTAliasInfo();
                this.implicitCreateSchema = true;
                break;
            }
            case 'F': 
            case 'P': {
                Integer n;
                int n2;
                this.javaClassName = (String)object;
                this.methodName = string;
                Object[] objectArray = (Object[])object2;
                Object[] objectArray2 = (Object[])objectArray[0];
                int n3 = ((List)objectArray2[0]).size();
                if (this.methodName.indexOf(40) != -1) {
                    this.getDataDictionary().checkVersion(130, "EXTERNAL NAME 'class.method(<signature>)'");
                }
                String[] stringArray = null;
                TypeDescriptor[] typeDescriptorArray = null;
                int[] nArray = null;
                if (n3 != 0) {
                    stringArray = new String[n3];
                    typeDescriptorArray = new TypeDescriptor[n3];
                    nArray = new int[n3];
                    for (int i = 0; i < n3; ++i) {
                        stringArray[i] = (String)((List)objectArray2[0]).get(i);
                        typeDescriptorArray[i] = (TypeDescriptor)((List)objectArray2[1]).get(i);
                        nArray[i] = n2 = ((Integer)((List)objectArray2[2]).get(i)).intValue();
                        if (typeDescriptorArray[i].isUserDefinedType() || !TypeId.getBuiltInTypeId(typeDescriptorArray[i].getJDBCTypeId()).isXMLTypeId()) continue;
                        throw StandardException.newException((String)"42962", (Object[])new Object[]{stringArray[i]});
                    }
                    if (n3 > 1) {
                        Object[] objectArray3 = new String[n3];
                        System.arraycopy(stringArray, 0, objectArray3, 0, n3);
                        Arrays.sort(objectArray3);
                        for (n2 = 1; n2 < objectArray3.length; ++n2) {
                            if (((String)objectArray3[n2]).equals("") || !((String)objectArray3[n2]).equals(objectArray3[n2 - 1])) continue;
                            throw StandardException.newException((String)"42734", (Object[])new Object[]{objectArray3[n2], this.getFullName()});
                        }
                    }
                }
                n2 = (n = (Integer)objectArray[2]) == null ? 0 : n;
                Short s = (Short)objectArray[6];
                short s2 = s != null ? s : (this.aliasType == 'P' ? (short)0 : 1);
                Boolean bl = (Boolean)objectArray[7];
                boolean bl2 = bl == null ? false : bl;
                Boolean bl3 = (Boolean)objectArray[11];
                boolean bl4 = bl3 == null ? false : bl3;
                Boolean bl5 = (Boolean)objectArray[10];
                boolean bl6 = bl5 == null ? false : bl5;
                Boolean bl7 = (Boolean)objectArray[8];
                boolean bl8 = bl7 == null ? true : bl7;
                TypeDescriptor typeDescriptor = (TypeDescriptor)objectArray[9];
                if (typeDescriptor != null) {
                    DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptor);
                    dataTypeDescriptor = this.bindUserType(dataTypeDescriptor);
                    typeDescriptor = dataTypeDescriptor.getCatalogType();
                }
                this.aliasInfo = new RoutineAliasInfo(this.methodName, n3, stringArray, typeDescriptorArray, nArray, n2, (Short)objectArray[5], s2, bl2, bl4, bl6, bl8, typeDescriptor);
                this.implicitCreateSchema = true;
                break;
            }
            case 'S': {
                this.implicitCreateSchema = true;
                TableName tableName2 = (TableName)object;
                String string2 = tableName2.getSchemaName() != null ? tableName2.getSchemaName() : this.getSchemaDescriptor().getSchemaName();
                this.aliasInfo = new SynonymAliasInfo(string2, tableName2.getTableName());
                break;
            }
        }
    }

    @Override
    String statementToString() {
        switch (this.aliasType) {
            case 'G': {
                return "CREATE DERBY AGGREGATE";
            }
            case 'A': {
                return "CREATE TYPE";
            }
            case 'P': {
                return "CREATE PROCEDURE";
            }
            case 'S': {
                return "CREATE SYNONYM";
            }
        }
        return "CREATE FUNCTION";
    }

    @Override
    public void bindStatement() throws StandardException {
        Object object;
        if (this.aliasType == 'F' || this.aliasType == 'P') {
            object = (TypeId[])this.aliasInfo;
            object.setCollationTypeForAllStringTypes(this.getSchemaDescriptor().getCollationType());
            this.bindParameterTypes((RoutineAliasInfo)this.aliasInfo);
            if (object.hasVarargs()) {
                switch (object.getParameterStyle()) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw StandardException.newException((String)"42ZC9", (Object[])new Object[0]);
                    }
                }
                if (object.getMaxDynamicResultSets() > 0) {
                    throw StandardException.newException((String)"42ZCB", (Object[])new Object[0]);
                }
            }
            if (object.getParameterStyle() == 2 && !object.hasVarargs()) {
                throw StandardException.newException((String)"42ZCA", (Object[])new Object[0]);
            }
        }
        if (this.aliasType == 'A') {
            object = TypeId.getAllBuiltinTypeIds();
            int n = ((TypeId[])object).length;
            boolean bl = this.javaClassName.startsWith("org.apache.derby.");
            if (!bl) {
                for (int i = 0; i < n; ++i) {
                    TypeId typeId = object[i];
                    String string = typeId.getCorrespondingJavaTypeName();
                    if (!string.equals(this.javaClassName)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                throw StandardException.newException((String)"42Z10", (Object[])new Object[]{this.javaClassName});
            }
            return;
        }
        if (this.aliasType == 'G') {
            this.bindAggregate();
        }
        if (this.aliasType != 'S') {
            return;
        }
        if (CreateAliasNode.isSessionSchema(this.getSchemaDescriptor().getSchemaName())) {
            throw StandardException.newException((String)"XCL51.S", (Object[])new Object[0]);
        }
        object = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
        String string = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
        if (this.getObjectName().equals((String)object, string)) {
            throw StandardException.newException((String)"42916", (Object[])new Object[]{this.getFullName(), (String)object + "." + string});
        }
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor((String)object, false);
        if (schemaDescriptor != null && this.isSessionSchema(schemaDescriptor)) {
            throw StandardException.newException((String)"XCL51.S", (Object[])new Object[0]);
        }
    }

    private void bindAggregate() throws StandardException {
        int n;
        String string = this.getRelativeName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor("SYSFUN", true);
        List<AliasDescriptor> list = this.getDataDictionary().getRoutineList(schemaDescriptor.getUUID().toString(), string, 'F');
        for (n = 0; n < list.size(); ++n) {
            AliasDescriptor aliasDescriptor = list.get(n);
            RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
            int n2 = routineAliasInfo.getParameterCount();
            if (n2 != 1) continue;
            throw this.illegalAggregate();
        }
        for (n = 0; n < NON_RESERVED_FUNCTION_NAMES.length; ++n) {
            if (!NON_RESERVED_FUNCTION_NAMES[n].equals(string)) continue;
            throw this.illegalAggregate();
        }
        for (n = 0; n < NON_RESERVED_AGGREGATES.length; ++n) {
            if (!NON_RESERVED_AGGREGATES[n].equals(string)) continue;
            throw this.illegalAggregate();
        }
        AggregateAliasInfo aggregateAliasInfo = (AggregateAliasInfo)this.aliasInfo;
        aggregateAliasInfo.setCollationTypeForAllStringTypes(this.getSchemaDescriptor().getCollationType());
    }

    private StandardException illegalAggregate() {
        return StandardException.newException((String)"42ZC3", (Object[])new Object[]{this.getRelativeName()});
    }

    private void bindParameterTypes(RoutineAliasInfo routineAliasInfo) throws StandardException {
        TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
        if (typeDescriptorArray == null) {
            return;
        }
        int n = typeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            typeDescriptorArray[i] = this.bindUserCatalogType(typeDescriptorArray[i]);
        }
        routineAliasInfo.setParameterTypes(typeDescriptorArray);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        String string = this.getSchemaDescriptor().getSchemaName();
        return this.getGenericConstantActionFactory().getCreateAliasConstantAction(this.getRelativeName(), string, this.javaClassName, this.aliasInfo, this.aliasType);
    }
}

