/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.web.reactive.function;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import reactor.core.publisher.Mono;

class OAuth2AccessTokenResponseBodyExtractor
implements BodyExtractor<Mono<OAuth2AccessTokenResponse>, ReactiveHttpInputMessage> {
    private static final String INVALID_TOKEN_RESPONSE_ERROR_CODE = "invalid_token_response";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};

    OAuth2AccessTokenResponseBodyExtractor() {
    }

    public Mono<OAuth2AccessTokenResponse> extract(ReactiveHttpInputMessage inputMessage, BodyExtractor.Context context) {
        BodyExtractor delegate = BodyExtractors.toMono(STRING_OBJECT_MAP);
        return ((Mono)delegate.extract(inputMessage, context)).onErrorMap(ex -> new OAuth2AuthorizationException(OAuth2AccessTokenResponseBodyExtractor.invalidTokenResponse("An error occurred parsing the Access Token response: " + ex.getMessage()), (Throwable)ex)).switchIfEmpty(Mono.error(() -> new OAuth2AuthorizationException(OAuth2AccessTokenResponseBodyExtractor.invalidTokenResponse("Empty OAuth 2.0 Access Token Response")))).map(OAuth2AccessTokenResponseBodyExtractor::parse).flatMap(OAuth2AccessTokenResponseBodyExtractor::oauth2AccessTokenResponse).map(OAuth2AccessTokenResponseBodyExtractor::oauth2AccessTokenResponse);
    }

    private static TokenResponse parse(Map<String, Object> json) {
        try {
            return TokenResponse.parse((JSONObject)new JSONObject(json));
        }
        catch (ParseException ex) {
            OAuth2Error oauth2Error = OAuth2AccessTokenResponseBodyExtractor.invalidTokenResponse("An error occurred parsing the Access Token response: " + ex.getMessage());
            throw new OAuth2AuthorizationException(oauth2Error, (Throwable)ex);
        }
    }

    private static OAuth2Error invalidTokenResponse(String message) {
        return new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, message, null);
    }

    private static Mono<AccessTokenResponse> oauth2AccessTokenResponse(TokenResponse tokenResponse) {
        if (tokenResponse.indicatesSuccess()) {
            return Mono.just((Object)tokenResponse).cast(AccessTokenResponse.class);
        }
        TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)tokenResponse;
        ErrorObject errorObject = tokenErrorResponse.getErrorObject();
        OAuth2Error oauth2Error = OAuth2AccessTokenResponseBodyExtractor.getOAuth2Error(errorObject);
        return Mono.error((Throwable)new OAuth2AuthorizationException(oauth2Error));
    }

    private static OAuth2Error getOAuth2Error(ErrorObject errorObject) {
        if (errorObject == null) {
            return new OAuth2Error("server_error");
        }
        String code = errorObject.getCode() != null ? errorObject.getCode() : "server_error";
        String description = errorObject.getDescription();
        String uri = errorObject.getURI() != null ? errorObject.getURI().toString() : null;
        return new OAuth2Error(code, description, uri);
    }

    private static OAuth2AccessTokenResponse oauth2AccessTokenResponse(AccessTokenResponse accessTokenResponse) {
        AccessToken accessToken = accessTokenResponse.getTokens().getAccessToken();
        OAuth2AccessToken.TokenType accessTokenType = null;
        if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(accessToken.getType().getValue())) {
            accessTokenType = OAuth2AccessToken.TokenType.BEARER;
        }
        long expiresIn = accessToken.getLifetime();
        LinkedHashSet<String> scopes = accessToken.getScope() != null ? new LinkedHashSet<String>(accessToken.getScope().toStringList()) : Collections.emptySet();
        String refreshToken = null;
        if (accessTokenResponse.getTokens().getRefreshToken() != null) {
            refreshToken = accessTokenResponse.getTokens().getRefreshToken().getValue();
        }
        LinkedHashMap<String, Object> additionalParameters = new LinkedHashMap<String, Object>(accessTokenResponse.getCustomParameters());
        return OAuth2AccessTokenResponse.withToken(accessToken.getValue()).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
    }
}

