/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.serialization;

import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ConfigurationItemReferenceResolver;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.xltype.serialization.json.MetadataIncludingCiJsonWriter;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.serialization.json.xltype.XlrPasswordMaskingCiConverter;
import com.xebialabs.xltype.serialization.CiWriter;

public class MetadataIncludingCiConverter
extends XlrPasswordMaskingCiConverter
implements ConfigurationItemReferenceResolver {
    private ConfigurationRepository configurationRepository;
    private ResolutionContext resolutionContext;

    public MetadataIncludingCiConverter(ConfigurationRepository configurationRepository, ResolutionContext resolutionContext) {
        this.configurationRepository = configurationRepository;
        this.resolutionContext = resolutionContext;
    }

    public MetadataIncludingCiConverter(ConfigurationRepository configurationRepository) {
        this(configurationRepository, null);
    }

    public void writeCi(ConfigurationItem ci, CiWriter writer, int ciRefsFromLevel) {
        if (ci instanceof ValidatedConfigurationItem) {
            ci = ((ValidatedConfigurationItem)ci).getWrapped();
        }
        writer.startCi(ci.getType().toString(), ci.getId());
        if (ci instanceof BaseConfigurationItem) {
            String token = ((BaseConfigurationItem)ci).get$token();
            if (token != null && !token.trim().isEmpty()) {
                writer.token(token);
            }
            writer.ciAttributes(((BaseConfigurationItem)ci).get$ciAttributes());
        }
        this.writeValidationMessages(ci, writer);
        this.writeProperties(ci, writer, ciRefsFromLevel);
        if (ci instanceof CiWithInternalMetadata && writer instanceof MetadataIncludingCiJsonWriter) {
            ((MetadataIncludingCiJsonWriter)writer).writeInternalMetadata(((CiWithInternalMetadata)ci).get$metadata());
        }
        writer.endCi();
    }

    public void resolveReferences(Repository repository) {
        this.resolveReferencesWithFallback(repository);
    }

    @Override
    public ConfigurationRepository getConfigurationRepository() {
        return this.configurationRepository;
    }

    @Override
    public ResolutionContext getResolutionContext() {
        return this.resolutionContext;
    }
}

