/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Multiples;
import com.rabbitmq.jms.parse.TokenStream;
import com.rabbitmq.jms.parse.sql.SqlParseTree;
import com.rabbitmq.jms.parse.sql.SqlToken;
import com.rabbitmq.jms.parse.sql.SqlTokenType;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;
import com.rabbitmq.jms.parse.sql.SqlTreeType;

enum SqlProduction {
    expression(SqlProduction.cAlt("or_expr", SqlTreeType.COLLAPSE1)),
    or_expr(SqlProduction.cAlt("and_expr OR or_expr", SqlTreeType.DISJUNCTION), SqlProduction.cAlt("and_expr", SqlTreeType.COLLAPSE1)),
    and_expr(SqlProduction.cAlt("not_expr AND and_expr", SqlTreeType.CONJUNCTION), SqlProduction.cAlt("not_expr", SqlTreeType.COLLAPSE1)),
    not_expr(SqlProduction.cAlt("NOT cmp_expr", SqlTreeType.PREFIXUNARYOP), SqlProduction.cAlt("cmp_expr", SqlTreeType.COLLAPSE1)),
    cmp_expr(SqlProduction.cAlt("arith_expr op_cmp arith_expr", SqlTreeType.BINARYOP), SqlProduction.cAlt("arith_expr BETWEEN arith_expr AND arith_expr", SqlTreeType.TERNARYOP), SqlProduction.cAlt("arith_expr NOT_BETWEEN arith_expr AND arith_expr", SqlTreeType.TERNARYOP), SqlProduction.cAlt("arith_expr", SqlTreeType.COLLAPSE1)),
    op_cmp(SqlProduction.cAlt("CMP_EQ", SqlTreeType.LEAF), SqlProduction.cAlt("CMP_NEQ", SqlTreeType.LEAF), SqlProduction.cAlt("CMP_LTEQ", SqlTreeType.LEAF), SqlProduction.cAlt("CMP_GTEQ", SqlTreeType.LEAF), SqlProduction.cAlt("CMP_LT", SqlTreeType.LEAF), SqlProduction.cAlt("CMP_GT", SqlTreeType.LEAF)),
    op_plus(SqlProduction.cAlt("OP_PLUS", SqlTreeType.LEAF), SqlProduction.cAlt("OP_MINUS", SqlTreeType.LEAF)),
    op_mult(SqlProduction.cAlt("OP_MULT", SqlTreeType.LEAF), SqlProduction.cAlt("OP_DIV", SqlTreeType.LEAF)),
    arith_expr(SqlProduction.cAlt("plus_expr", SqlTreeType.COLLAPSE1)),
    plus_expr(SqlProduction.cAlt("mult_expr op_plus plus_expr", SqlTreeType.BINARYOP), SqlProduction.cAlt("mult_expr", SqlTreeType.COLLAPSE1)),
    mult_expr(SqlProduction.cAlt("sign_expr op_mult mult_expr", SqlTreeType.BINARYOP), SqlProduction.cAlt("sign_expr", SqlTreeType.COLLAPSE1)),
    sign_expr(SqlProduction.cAlt("op_plus sign_expr", SqlTreeType.PREFIXUNARYOP), SqlProduction.cAlt("simple", SqlTreeType.COLLAPSE1)),
    simple(SqlProduction.cAlt("LP expression RP", SqlTreeType.COLLAPSE2), SqlProduction.cAlt("TRUE", SqlTreeType.LEAF), SqlProduction.cAlt("FALSE", SqlTreeType.LEAF), SqlProduction.cAlt("STRING", SqlTreeType.LEAF), SqlProduction.cAlt("number", SqlTreeType.COLLAPSE1), SqlProduction.cAlt("IDENT NULL", SqlTreeType.POSTFIXUNARYOP), SqlProduction.cAlt("IDENT NOT_NULL", SqlTreeType.POSTFIXUNARYOP), SqlProduction.cAlt("IDENT IN stringlist", SqlTreeType.BINARYOP), SqlProduction.cAlt("IDENT NOT_IN stringlist", SqlTreeType.BINARYOP), SqlProduction.cAlt("IDENT LIKE pattern", SqlTreeType.BINARYOP), SqlProduction.cAlt("IDENT NOT_LIKE pattern", SqlTreeType.BINARYOP), SqlProduction.cAlt("IDENT", SqlTreeType.LEAF)),
    stringlist(SqlProduction.cAlt("LP strings RP", SqlTreeType.COLLAPSE2)),
    strings(SqlProduction.cAlt("STRING COMMA strings", SqlTreeType.JOINLIST), SqlProduction.cAlt("STRING", SqlTreeType.LIST)),
    pattern(SqlProduction.cAlt("STRING ESCAPE STRING", SqlTreeType.PATTERN2), SqlProduction.cAlt("STRING", SqlTreeType.PATTERN1)),
    number(SqlProduction.cAlt("HEX", SqlTreeType.LEAF), SqlProduction.cAlt("FLOAT", SqlTreeType.LEAF), SqlProduction.cAlt("INT", SqlTreeType.LEAF)),
    LIKE(SqlTokenType.LIKE),
    NOT_LIKE(SqlTokenType.NOT_LIKE),
    IN(SqlTokenType.IN),
    NOT_IN(SqlTokenType.NOT_IN),
    NULL(SqlTokenType.NULL),
    NOT_NULL(SqlTokenType.NOT_NULL),
    BETWEEN(SqlTokenType.BETWEEN),
    NOT_BETWEEN(SqlTokenType.NOT_BETWEEN),
    AND(SqlTokenType.AND),
    OR(SqlTokenType.OR),
    NOT(SqlTokenType.NOT),
    ESCAPE(SqlTokenType.ESCAPE),
    TRUE(SqlTokenType.TRUE),
    FALSE(SqlTokenType.FALSE),
    CMP_EQ(SqlTokenType.CMP_EQ),
    CMP_NEQ(SqlTokenType.CMP_NEQ),
    CMP_LTEQ(SqlTokenType.CMP_LTEQ),
    CMP_GTEQ(SqlTokenType.CMP_GTEQ),
    CMP_LT(SqlTokenType.CMP_LT),
    CMP_GT(SqlTokenType.CMP_GT),
    OP_PLUS(SqlTokenType.OP_PLUS),
    OP_MINUS(SqlTokenType.OP_MINUS),
    OP_MULT(SqlTokenType.OP_MULT),
    OP_DIV(SqlTokenType.OP_DIV),
    COMMA(SqlTokenType.COMMA),
    LP(SqlTokenType.LP),
    RP(SqlTokenType.RP),
    IDENT(SqlTokenType.IDENT),
    STRING(SqlTokenType.STRING),
    FLOAT(SqlTokenType.FLOAT),
    INT(SqlTokenType.INT),
    HEX(SqlTokenType.HEX);

    public static final SqlProduction ROOT;
    private final SqlTokenType tokenType;
    private final CodedAlternative[] codedAlts;

    private SqlProduction(CodedAlternative ... alts) {
        this.tokenType = null;
        this.codedAlts = alts;
    }

    private SqlProduction(SqlTokenType tokenType) {
        this.tokenType = tokenType;
        this.codedAlts = null;
    }

    SqlParseTree parse(TokenStream<SqlToken, Integer> ts) {
        if (this.tokenType != null) {
            if (SqlProduction.isTokenRightType(ts.readToken(), this.tokenType)) {
                return new SqlParseTree(new SqlTreeNode(SqlTreeType.LEAF, ts.getNext()), new SqlParseTree[0]);
            }
        } else {
            int startPosition = ts.position();
            AlternativeParser altParser = new AlternativeParser(ts);
            for (CodedAlternative codedAlt : this.codedAlts) {
                if (!altParser.match(codedAlt.alternative())) continue;
                return codedAlt.treeType().tree(altParser.getMatchedChildren());
            }
            ts.reset(startPosition);
        }
        return null;
    }

    private static final boolean isTokenRightType(SqlToken tok, SqlTokenType tokType) {
        return tok != null && tok.type() == tokType;
    }

    private static final CodedAlternative cAlt(String terms, SqlTreeType treeNodeType) {
        return new CodedAlternative(treeNodeType, terms.split(" "));
    }

    static {
        ROOT = expression;
    }

    private static final class CodedAlternative
    extends Multiples.Pair<SqlTreeType, String[]> {
        public CodedAlternative(SqlTreeType l, String[] r) {
            super(l, r);
        }

        public SqlProduction[] alternative() {
            return CodedAlternative.aValueOf((String[])this.right());
        }

        public SqlTreeType treeType() {
            return (SqlTreeType)((Object)this.left());
        }

        private static final SqlProduction[] aValueOf(String[] ss) {
            SqlProduction[] scts = new SqlProduction[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                scts[i] = SqlProduction.valueOf(ss[i]);
            }
            return scts;
        }
    }

    private static final class AlternativeParser {
        private static final SqlProduction[] EMPTY_ALTERNATIVE = new SqlProduction[0];
        private static final SqlParseTree[] EMPTY_SUBTREES = new SqlParseTree[0];
        private final TokenStream<SqlToken, Integer> tokenStream;
        private final int startPosition;
        private SqlProduction[] alternative;
        private SqlParseTree[] subtrees;
        private int numberMatched;

        AlternativeParser(TokenStream<SqlToken, Integer> tokenStream) {
            this.tokenStream = tokenStream;
            this.startPosition = tokenStream.position();
            this.alternative = EMPTY_ALTERNATIVE;
            this.subtrees = EMPTY_SUBTREES;
            this.numberMatched = 0;
        }

        boolean match(SqlProduction[] alt) {
            this.setNewAlternative(alt);
            int term = this.numberMatched;
            while (term < this.subtrees.length) {
                this.subtrees[term] = this.alternative[term].parse(this.tokenStream);
                if (null == this.subtrees[term]) break;
                ++term;
                ++this.numberMatched;
            }
            return this.isFullyMatched();
        }

        private void setNewAlternative(SqlProduction[] alt) {
            SqlParseTree[] newSubtrees = new SqlParseTree[alt.length];
            if (this.canUsePreviousMatches(alt)) {
                System.arraycopy(this.subtrees, 0, newSubtrees, 0, this.numberMatched);
            } else {
                this.numberMatched = 0;
                this.tokenStream.reset(this.startPosition);
            }
            this.alternative = alt;
            this.subtrees = newSubtrees;
        }

        private boolean canUsePreviousMatches(SqlProduction[] alt) {
            if (this.numberMatched > alt.length) {
                return false;
            }
            for (int i = 0; i < this.numberMatched; ++i) {
                if (alt[i] == this.alternative[i]) continue;
                return false;
            }
            return true;
        }

        private boolean isFullyMatched() {
            return this.numberMatched == this.subtrees.length;
        }

        SqlParseTree[] getMatchedChildren() {
            return this.isFullyMatched() ? this.subtrees : null;
        }
    }
}

