import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Ids from '../../../js/util/ids';

import './folder-path.component.less';

export class FolderPathComponent extends Component {
    static propTypes = {
        childUri: PropTypes.string,
        folders: PropTypes.array.isRequired,
        showIcon: PropTypes.bool,
    };

    render() {
        const { childUri, folders, showIcon } = this.props;
        let folderUrl = '#/folders/Applications';
        const folderList = folders.map((folder, idx) => {
            folderUrl += '/' + `${Ids().noApplications(folder.id)}`;
            return (
                <li key={folder.id}>
                    <div>
                        {idx !== 0 && <i className="xl-icon chevron-right-icon arrow-breadcrumb-icon" />}{' '}
                        <a href={`${folderUrl}/${childUri}`}>
                            {showIcon && <i className="xl-icon icon-xs folder-icon" />}
                            {folder.title}
                        </a>
                    </div>
                </li>
            );
        });

        return <ul className="folder-path-view">{folderList}</ul>;
    }
}
