/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public final class SystemPermission
extends BasicPermission {
    private static final long serialVersionUID = 1965420504091489898L;
    public static final String SERVER = "server";
    public static final String ENGINE = "engine";
    public static final String JMX = "jmx";
    public static final String SHUTDOWN = "shutdown";
    public static final String CONTROL = "control";
    public static final String MONITOR = "monitor";
    public static final String USE_DERBY_INTERNALS = "usederbyinternals";
    private static final Set<String> LEGAL_NAMES = new HashSet<String>();
    private static final List<String> LEGAL_ACTIONS;
    public static final SystemPermission ENGINE_MONITOR;
    private String actions;
    private transient int actionMask;

    public SystemPermission(String string, String string2) {
        super(string);
        this.validateNameAndActions(string, string2);
    }

    private void validateNameAndActions(String string, String string2) {
        if (!LEGAL_NAMES.contains(string)) {
            throw new IllegalArgumentException("Unknown permission " + string);
        }
        this.actions = SystemPermission.getCanonicalForm(string2);
        this.actionMask = SystemPermission.getActionMask(this.actions);
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SystemPermissionCollection();
    }

    private static String getCanonicalForm(String string) {
        Set<String> set = SystemPermission.parseActions(string);
        ArrayList<String> arrayList = new ArrayList<String>(LEGAL_ACTIONS);
        arrayList.retainAll(set);
        return SystemPermission.buildActionsString(arrayList);
    }

    public static Set<String> parseActions(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : string.split(",", -1)) {
            hashSet.add(string2.trim().toLowerCase(Locale.ENGLISH));
        }
        return hashSet;
    }

    public static String buildActionsString(Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : iterable) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SystemPermission systemPermission = (SystemPermission)object;
        return this.actionMask == systemPermission.actionMask;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!super.implies(permission)) {
            return false;
        }
        int n = this.actionMask;
        int n2 = ((SystemPermission)permission).actionMask;
        return (n & n2) == n2;
    }

    private static int getActionMask(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = LEGAL_ACTIONS.indexOf(stringTokenizer.nextElement());
            if (n2 == -1) continue;
            n |= 1 << n2;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.validateNameAndActions(this.getName(), this.getActions());
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "( " + this.doubleQuote(this.getName()) + ", " + this.doubleQuote(this.actions) + " )";
    }

    private String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    static {
        LEGAL_NAMES.add(SERVER);
        LEGAL_NAMES.add(ENGINE);
        LEGAL_NAMES.add(JMX);
        LEGAL_ACTIONS = new ArrayList<String>();
        LEGAL_ACTIONS.add(CONTROL);
        LEGAL_ACTIONS.add(MONITOR);
        LEGAL_ACTIONS.add(SHUTDOWN);
        LEGAL_ACTIONS.add(USE_DERBY_INTERNALS);
        ENGINE_MONITOR = new SystemPermission(ENGINE, MONITOR);
    }

    private static class SystemPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 0L;
        private HashMap<String, Permission> permissions = new HashMap();

        private SystemPermissionCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Permission permission) {
            if (!(permission instanceof SystemPermission)) {
                throw new IllegalArgumentException();
            }
            if (this.isReadOnly()) {
                throw new SecurityException();
            }
            String string = permission.getName();
            SystemPermissionCollection systemPermissionCollection = this;
            synchronized (systemPermissionCollection) {
                Permission permission2 = this.permissions.get(string);
                if (permission2 == null) {
                    this.permissions.put(string, permission);
                } else {
                    String string2 = permission2.getActions() + "," + permission.getActions();
                    this.permissions.put(string, new SystemPermission(string, string2));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean implies(Permission permission) {
            Permission permission2;
            if (!(permission instanceof SystemPermission)) {
                return false;
            }
            String string = permission.getName();
            SystemPermissionCollection systemPermissionCollection = this;
            synchronized (systemPermissionCollection) {
                permission2 = this.permissions.get(string);
            }
            return permission2 != null && permission2.implies(permission);
        }

        @Override
        public synchronized Enumeration<Permission> elements() {
            return Collections.enumeration(this.permissions.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ArrayList<Permission> arrayList;
            Object object = this;
            synchronized (object) {
                arrayList = new ArrayList<Permission>(this.permissions.values());
            }
            object = objectOutputStream.putFields();
            ((ObjectOutputStream.PutField)object).put("permissions", arrayList);
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            List list = (List)getField.get("permissions", null);
            this.permissions = new HashMap();
            for (Object e : list) {
                SystemPermission systemPermission = (SystemPermission)e;
                this.permissions.put(systemPermission.getName(), systemPermission);
            }
        }
    }
}

