/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.util;

import com.rabbitmq.jms.util.AbortedException;
import com.rabbitmq.jms.util.TimeTracker;

abstract class WaiterGate {
    private Object lock = new Object();
    private GateState state;
    private long generation;

    public WaiterGate(boolean opened) {
        this.state = opened ? GateState.OPENED : GateState.CLOSED;
        this.generation = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == GateState.OPENED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == GateState.OPENED) {
                this.state = GateState.CLOSED;
                ++this.generation;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean open() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == GateState.CLOSED) {
                this.state = GateState.OPENED;
                this.lock.notifyAll();
                return true;
            }
        }
        return false;
    }

    public abstract void onEntry();

    public abstract void onAbort();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForOpen(TimeTracker tracker) throws InterruptedException, AbortedException {
        Object object = this.lock;
        synchronized (object) {
            long arrivalGeneration = this.generation;
            while (this.state == GateState.CLOSED && arrivalGeneration == this.generation && !tracker.timedOut()) {
                tracker.timedWait(this.lock);
            }
            GateState derivedState = this.state;
            if (derivedState == GateState.ABORTED) {
                this.onAbort();
                throw new AbortedException();
            }
            if (derivedState == GateState.OPENED || arrivalGeneration != this.generation) {
                this.onEntry();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean abort() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != GateState.CLOSED) {
                return false;
            }
            this.state = GateState.ABORTED;
            this.lock.notifyAll();
        }
        return true;
    }

    private static enum GateState {
        OPENED,
        CLOSED,
        ABORTED;

    }
}

