/*
 * Decompiled with CFR 0.152.
 */
package slick.jdbc;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TimestamptzConverter$ {
    public static final TimestamptzConverter$ MODULE$ = new TimestamptzConverter$();
    private static final Class<?> timestampTZClass = Class.forName("oracle.sql.TIMESTAMPTZ");
    private static final Constructor<?> timestampTZCtor = MODULE$.timestampTZClass().getConstructor(byte[].class);
    private static final Method timestampTZToBytes = MODULE$.timestampTZClass().getMethod("toBytes", new Class[0]);
    private static final Class<?> zoneIdClass = Class.forName("oracle.sql.ZONEIDMAP");
    private static final Method zoneIdGetId = MODULE$.zoneIdClass().getMethod("getID", String.class);
    private static final Method zoneIdGetRegion = MODULE$.zoneIdClass().getMethod("getRegion", Integer.TYPE);
    private static final int RegionIdBit = Integer.parseInt("10000000", 2);
    private static final int OFFSET_HOUR = 20;
    private static final int OFFSET_MINUTE = 60;
    private static final int highBits = Integer.parseInt("1111111", 2);
    private static final int lowBits = Integer.parseInt("11111100", 2);
    private static final int msb = Integer.parseInt("1111111000000", 2);
    private static final int lsb = Integer.parseInt("111111", 2);

    public Class<?> timestampTZClass() {
        return timestampTZClass;
    }

    public Constructor<?> timestampTZCtor() {
        return timestampTZCtor;
    }

    public Method timestampTZToBytes() {
        return timestampTZToBytes;
    }

    public Class<?> zoneIdClass() {
        return zoneIdClass;
    }

    public Method zoneIdGetId() {
        return zoneIdGetId;
    }

    public Method zoneIdGetRegion() {
        return zoneIdGetRegion;
    }

    public int RegionIdBit() {
        return RegionIdBit;
    }

    public Object offsetDateTimeToTimestamptz(OffsetDateTime attribute) {
        byte[] bytes = new byte[13];
        ZonedDateTime utc = attribute.atZoneSameInstant(ZoneOffset.UTC);
        this.writeDateTime(bytes, utc);
        ZoneOffset offset = attribute.getOffset();
        this.writeZoneOffset(bytes, offset);
        return this.timestampTZCtor().newInstance(new Object[]{bytes});
    }

    public OffsetDateTime timestamptzToOffsetDateTime(Object dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = (byte[])this.timestampTZToBytes().invoke(dbData, new Object[0]);
        OffsetDateTime utc = this.extractUtc(bytes);
        if (this.isFixedOffset(bytes)) {
            ZoneOffset offset = this.extractOffset(bytes);
            return utc.withOffsetSameInstant(offset);
        }
        ZoneId zoneId = this.extractZoneId(bytes);
        return utc.atZoneSameInstant(zoneId).toOffsetDateTime();
    }

    public Object offsetTimeToTimestamptz(OffsetTime attribute) {
        byte[] bytes = new byte[13];
        ZonedDateTime utc = attribute.atDate(LocalDate.ofEpochDay(0L)).atZoneSameInstant(ZoneOffset.UTC);
        this.writeDateTime(bytes, utc);
        ZoneOffset offset = attribute.getOffset();
        this.writeZoneOffset(bytes, offset);
        return this.timestampTZCtor().newInstance(new Object[]{bytes});
    }

    public OffsetTime timestamptzToOffsetTime(Object dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = (byte[])this.timestampTZToBytes().invoke(dbData, new Object[0]);
        OffsetDateTime utc = this.extractUtc(bytes);
        if (this.isFixedOffset(bytes)) {
            ZoneOffset offset = this.extractOffset(bytes);
            return utc.withOffsetSameInstant(offset).toOffsetTime();
        }
        ZoneId zoneId = this.extractZoneId(bytes);
        return utc.atZoneSameInstant(zoneId).toOffsetDateTime().toOffsetTime();
    }

    public Object zonedDateTimeToTimestamptz(ZonedDateTime attribute) {
        byte[] bytes = new byte[13];
        ZonedDateTime utc = attribute.withZoneSameInstant(ZoneOffset.UTC);
        this.writeDateTime(bytes, utc);
        String zoneId = attribute.getZone().getId();
        Integer regionCode = (Integer)this.zoneIdGetId().invoke(null, zoneId);
        if (!BoxesRunTime.equalsNumObject((Number)regionCode, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            this.writeZoneId(bytes, Predef$.MODULE$.Integer2int(regionCode));
        } else {
            this.writeZoneOffset(bytes, attribute.getOffset());
        }
        return this.timestampTZCtor().newInstance(new Object[]{bytes});
    }

    public ZonedDateTime timestamptzToZonedDateTime(Object dbData) {
        if (dbData == null) {
            return null;
        }
        byte[] bytes = (byte[])this.timestampTZToBytes().invoke(dbData, new Object[0]);
        OffsetDateTime utc = this.extractUtc(bytes);
        if (this.isFixedOffset(bytes)) {
            ZoneOffset offset = this.extractOffset(bytes);
            return utc.atZoneSameInstant(offset);
        }
        ZoneId zoneId = this.extractZoneId(bytes);
        return utc.atZoneSameInstant(zoneId);
    }

    public OffsetDateTime extractUtc(byte[] bytes) {
        int year = (bytes[0] - 100) * 100 + (bytes[1] - 100);
        byte month = bytes[2];
        byte dayOfMonth = bytes[3];
        int hour = bytes[4] - 1;
        int minute = bytes[5] - 1;
        int second = bytes[6] - 1;
        int nanoOfSecond = (bytes[7] & 0xFF) << 24 | (bytes[8] & 0xFF) << 16 | (bytes[9] & 0xFF) << 8 | bytes[10] & 0xFF;
        return OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, ZoneOffset.UTC);
    }

    public boolean isFixedOffset(byte[] bytes) {
        return (bytes[11] & this.RegionIdBit()) == 0;
    }

    public byte[] newTIMESTAMPTZBuffer() {
        return new byte[13];
    }

    public void writeDateTime(byte[] bytes, ZonedDateTime utc) {
        int year = utc.getYear();
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
        bytes[2] = (byte)utc.getMonthValue();
        bytes[3] = (byte)utc.getDayOfMonth();
        bytes[4] = (byte)(utc.getHour() + 1);
        bytes[5] = (byte)(utc.getMinute() + 1);
        bytes[6] = (byte)(utc.getSecond() + 1);
        int nano = utc.getNano();
        byte[] ba = package$.MODULE$.BigInt().apply(nano).toByteArray();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.byteArrayOps(ba))), (Function1 & Serializable)x0$1 -> {
            TimestamptzConverter$.$anonfun$writeDateTime$1(bytes, ba, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public int OFFSET_HOUR() {
        return OFFSET_HOUR;
    }

    public int OFFSET_MINUTE() {
        return OFFSET_MINUTE;
    }

    public ZoneOffset extractOffset(byte[] bytes) {
        return ZoneOffset.ofHoursMinutes(bytes[11] - this.OFFSET_HOUR(), bytes[12] - this.OFFSET_MINUTE());
    }

    public void writeZoneOffset(byte[] bytes, ZoneOffset offset) {
        int totalMinutes = offset.getTotalSeconds() / 60;
        bytes[11] = (byte)(totalMinutes / 60 + this.OFFSET_HOUR());
        bytes[12] = (byte)(totalMinutes % 60 + this.OFFSET_MINUTE());
    }

    public int highBits() {
        return highBits;
    }

    public int lowBits() {
        return lowBits;
    }

    public ZoneId extractZoneId(byte[] bytes) {
        Integer regionCode = Predef$.MODULE$.int2Integer(((bytes[11] & this.highBits()) << 6) + ((bytes[12] & this.lowBits()) >> 2));
        return ZoneId.of((String)this.zoneIdGetRegion().invoke(null, regionCode));
    }

    public int msb() {
        return msb;
    }

    public int lsb() {
        return lsb;
    }

    public void writeZoneId(byte[] bytes, int regionCode) {
        bytes[11] = (byte)(this.RegionIdBit() | (regionCode & this.msb()) >>> 6);
        bytes[12] = (byte)((regionCode & this.lsb()) << 2);
    }

    public static final /* synthetic */ void $anonfun$writeDateTime$1(byte[] bytes$1, byte[] ba$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            byte b = BoxesRunTime.unboxToByte((Object)x0$1._1());
            int i = x0$1._2$mcI$sp();
            bytes$1[11 - ba$1.length + i] = b;
            return;
        }
        throw new MatchError(null);
    }

    private TimestamptzConverter$() {
    }
}

