/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.config;

import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.security.DefaultReleaseRoleService;
import com.xebialabs.xlrelease.security.DefaultUserGroupService;
import com.xebialabs.xlrelease.security.ReleaseRolePermissionRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleService;
import com.xebialabs.xlrelease.security.SqlReleaseRoleRepository;
import com.xebialabs.xlrelease.security.SqlUserGroupRepository;
import com.xebialabs.xlrelease.security.SqlUserGroupRepositoryCache;
import com.xebialabs.xlrelease.security.UserGroupRepository;
import com.xebialabs.xlrelease.security.UserGroupService;
import com.xebialabs.xlrelease.security.sql.CachingPermissionEditor;
import com.xebialabs.xlrelease.security.sql.CachingPermissionLister;
import com.xebialabs.xlrelease.security.sql.CachingSqlRoleService;
import com.xebialabs.xlrelease.security.sql.CachingSqlUserService;
import com.xebialabs.xlrelease.security.sql.SqlPermissionChecker;
import com.xebialabs.xlrelease.security.sql.SqlPermissionLister;
import com.xebialabs.xlrelease.security.sql.SqlReleaseRolePermissionRepository;
import com.xebialabs.xlrelease.security.sql.SqlRoleService;
import com.xebialabs.xlrelease.security.sql.SqlUserService;
import com.xebialabs.xlrelease.security.sql.UserCacheEvicter;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.spring.config.SqlConfiguration;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import scala.reflect.ScalaSignature;

@Configuration
@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001\u0002\t\u0012\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015\t\b\u0001\"\u0001s\u0011\u0015A\b\u0001\"\u0001z\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\b\u0001\u0005\u0002\u0005u\"\u0001G*rYN+7-\u001e:jif\u001cuN\u001c4jOV\u0014\u0018\r^5p]*\u0011!cE\u0001\u0007G>tg-[4\u000b\u0005Q)\u0012AB:qe&twM\u0003\u0002\u0017/\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00031e\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\t1aY8n\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003A\u0019\u0018\u000f\\\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002&M5\t\u0011#\u0003\u0002(#\t\u00012+\u001d7D_:4\u0017nZ;sCRLwN\\\u0001\nq2\u00148i\u001c8gS\u001e\u0004\"A\u000b\u0017\u000e\u0003-R!AE\u000b\n\u00055Z#!\u0003-me\u000e{gNZ5h\u0003A\u0011'o\\1eG\u0006\u001cHoU3sm&\u001cW\r\u0005\u00021g5\t\u0011G\u0003\u00023+\u000591/\u001a:wS\u000e,\u0017B\u0001\u001b2\u0005A\u0011%o\\1eG\u0006\u001cHoU3sm&\u001cW-\u0001\u0005fm\u0016tGOQ;t!\t9$(D\u00019\u0015\tIT#\u0001\u0004fm\u0016tGo]\u0005\u0003wa\u0012\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q)ah\u0010!B\u0005B\u0011Q\u0005\u0001\u0005\u0006G\u0015\u0001\r\u0001\n\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006]\u0015\u0001\ra\f\u0005\u0006k\u0015\u0001\rAN\u0001\fe>dWmU3sm&\u001cW\rF\u0001F!\t15*D\u0001H\u0015\tA\u0015*A\u0002tc2T!AS\u000b\u0002\u0011M,7-\u001e:jifL!\u0001T$\u0003+\r\u000b7\r[5oON\u000bHNU8mKN+'O^5dK\"\u0012aA\u0014\t\u0003\u001fbk\u0011\u0001\u0015\u0006\u0003#J\u000b!\"\u00198o_R\fG/[8o\u0015\t\u0019F+A\u0004d_:$X\r\u001f;\u000b\u0005U3\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003]\u000b1a\u001c:h\u0013\tI\u0006K\u0001\u0003CK\u0006t\u0017aC;tKJ\u001cVM\u001d<jG\u0016$\"\u0001X2\u0011\u0005u\u000bW\"\u00010\u000b\u0005){&B\u00011\u0018\u0003!!W\r\u001d7ps&$\u0018B\u00012_\u0005-)6/\u001a:TKJ4\u0018nY3\t\u000b\u0011<\u0001\u0019A3\u0002\u000f\u00154\u0018n\u0019;feB\u0019am[7\u000e\u0003\u001dT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\tawM\u0001\u0005PaRLwN\\1m!\t1e.\u0003\u0002p\u000f\n\u0001Rk]3s\u0007\u0006\u001c\u0007.Z#wS\u000e$XM\u001d\u0015\u0003\u000f9\u000b!C]3mK\u0006\u001cXMU8mKN+'O^5dKR\t1\u000f\u0005\u0002uk6\t\u0011*\u0003\u0002w\u0013\n\u0011\"+\u001a7fCN,'k\u001c7f'\u0016\u0014h/[2fQ\tAa*A\u000bsK2,\u0017m]3S_2,'+\u001a9pg&$xN]=\u0015\u0003i\u0004\"\u0001^>\n\u0005qL%!\u0006*fY\u0016\f7/\u001a*pY\u0016\u0014V\r]8tSR|'/\u001f\u0015\u0003\u00139\u000b\u0001#^:fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0015\u0005\u0005\u0005\u0001c\u0001;\u0002\u0004%\u0019\u0011QA%\u0003!U\u001bXM]$s_V\u00048+\u001a:wS\u000e,\u0007F\u0001\u0006O\u0003M)8/\u001a:He>,\bOU3q_NLGo\u001c:z)\t\ti\u0001E\u0002u\u0003\u001fI1!!\u0005J\u0005M)6/\u001a:He>,\bOU3q_NLGo\u001c:zQ\tYa*\u0001\tqKJl\u0017n]:j_:d\u0015n\u001d;feR\u0011\u0011\u0011\u0004\t\u0004\r\u0006m\u0011bAA\u000f\u000f\n\u00192+\u001d7QKJl\u0017n]:j_:d\u0015n\u001d;fe\"\u0012ABT\u0001\u0011a\u0016\u0014X.[:tS>tW\tZ5u_J$\"!!\n\u0011\u0007u\u000b9#C\u0002\u0002*y\u0013\u0001\u0003U3s[&\u001c8/[8o\u000b\u0012LGo\u001c:)\u00055q\u0015\u0001\u0006=meB+'/\\5tg&|gn\u00115fG.,'\u000f\u0006\u0003\u00022\u0005]\u0002cA/\u00024%\u0019\u0011Q\u00070\u0003#A+'/\\5tg&|gn\u00115fG.,'\u000fC\u0004\u0002\u00169\u0001\r!!\u0007)\u00059q\u0015\u0001\u0007:pY\u0016\u0004VM]7jgNLwN\u001c*fa>\u001c\u0018\u000e^8ssR\u0011\u0011q\b\t\u0004i\u0006\u0005\u0013bAA\"\u0013\ny\"+\u001a7fCN,'k\u001c7f!\u0016\u0014X.[:tS>t'+\u001a9pg&$xN]=)\u0005=q\u0005f\u0001\u0001\u0002JA\u0019q*a\u0013\n\u0007\u00055\u0003KA\u0007D_:4\u0017nZ;sCRLwN\u001c")
public class SqlSecurityConfiguration {
    private final SqlConfiguration sqlConfiguration;
    private final XlrConfig xlrConfig;
    private final BroadcastService broadcastService;
    private final XLReleaseEventBus eventBus;

    @Bean
    public CachingSqlRoleService roleService() {
        return new CachingSqlRoleService(this.sqlConfiguration.xlrRepositoryDatabase(), this.broadcastService);
    }

    @Bean
    public UserService userService(Optional<UserCacheEvicter> evicter) {
        if (this.xlrConfig.isSecurityUserCacheEnabled()) {
            return new CachingSqlUserService(this.sqlConfiguration.xlrRepositoryDatabase(), evicter.get());
        }
        return new SqlUserService(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public ReleaseRoleService releaseRoleService() {
        return new DefaultReleaseRoleService(this.eventBus, (CiIdService)this.sqlConfiguration.ciIdService(), this.releaseRoleRepository(), this.rolePermissionRepository());
    }

    @Bean
    public ReleaseRoleRepository releaseRoleRepository() {
        return new SqlReleaseRoleRepository(this.sqlConfiguration.xlrDatabaseInformation(), this.sqlConfiguration.xlrRepositoryJdbcTemplate(), this.sqlConfiguration.xlrRepositorySqlDialect(), (SqlRoleService)this.roleService());
    }

    @Bean
    public UserGroupService userGroupService() {
        return new DefaultUserGroupService(this.userGroupRepository());
    }

    @Bean
    public UserGroupRepository userGroupRepository() {
        SqlUserGroupRepository repository = new SqlUserGroupRepository(this.sqlConfiguration.ciIdService(), this.sqlConfiguration.xlrRepositoryJdbcTemplate(), this.sqlConfiguration.xlrRepositorySqlDialect());
        if (this.xlrConfig.isUserGroupCacheEnabled()) {
            return new SqlUserGroupRepositoryCache(repository, this.broadcastService);
        }
        return repository;
    }

    @Bean
    public SqlPermissionLister permissionLister() {
        return new CachingPermissionLister(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public PermissionEditor permissionEditor() {
        return new CachingPermissionEditor(this.sqlConfiguration.xlrRepositoryDatabase(), this.broadcastService);
    }

    @Bean
    public PermissionChecker xlrPermissionChecker(SqlPermissionLister permissionLister) {
        return new SqlPermissionChecker(this.sqlConfiguration.xlrRepositoryDatabase(), permissionLister);
    }

    @Bean
    public ReleaseRolePermissionRepository rolePermissionRepository() {
        return new SqlReleaseRolePermissionRepository(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    public SqlSecurityConfiguration(SqlConfiguration sqlConfiguration, XlrConfig xlrConfig, BroadcastService broadcastService, XLReleaseEventBus eventBus) {
        this.sqlConfiguration = sqlConfiguration;
        this.xlrConfig = xlrConfig;
        this.broadcastService = broadcastService;
        this.eventBus = eventBus;
    }
}

