/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Map;
import java.util.function.Consumer;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultOAuth2TokenRequestHeadersConverter;
import org.springframework.security.oauth2.client.endpoint.DefaultOAuth2TokenRequestParametersConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;

public abstract class AbstractRestClientOAuth2AccessTokenResponseClient<T extends AbstractOAuth2AuthorizationGrantRequest>
implements OAuth2AccessTokenResponseClient<T> {
    private static final String INVALID_TOKEN_RESPONSE_ERROR_CODE = "invalid_token_response";
    private RestClient restClient = RestClient.builder().messageConverters(messageConverters -> {
        messageConverters.clear();
        messageConverters.add(new FormHttpMessageConverter());
        messageConverters.add(new OAuth2AccessTokenResponseHttpMessageConverter());
    }).defaultStatusHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler()).build();
    private Converter<T, RestClient.RequestHeadersSpec<?>> requestEntityConverter = this::validatingPopulateRequest;
    private Converter<T, HttpHeaders> headersConverter = new DefaultOAuth2TokenRequestHeadersConverter();
    private Converter<T, MultiValueMap<String, String>> parametersConverter = new DefaultOAuth2TokenRequestParametersConverter();
    private Consumer<MultiValueMap<String, String>> parametersCustomizer = parameters -> {};

    AbstractRestClientOAuth2AccessTokenResponseClient() {
    }

    @Override
    public OAuth2AccessTokenResponse getTokenResponse(T grantRequest) {
        Assert.notNull(grantRequest, (String)"grantRequest cannot be null");
        try {
            OAuth2AccessTokenResponse accessTokenResponse = (OAuth2AccessTokenResponse)((RestClient.RequestHeadersSpec)this.requestEntityConverter.convert(grantRequest)).retrieve().body(OAuth2AccessTokenResponse.class);
            if (accessTokenResponse == null) {
                OAuth2Error error = new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, "Empty OAuth 2.0 Access Token Response", null);
                throw new OAuth2AuthorizationException(error);
            }
            return accessTokenResponse;
        }
        catch (RestClientException ex) {
            OAuth2Error error = new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, "An error occurred while attempting to retrieve the OAuth 2.0 Access Token Response: " + ex.getMessage(), null);
            throw new OAuth2AuthorizationException(error, (Throwable)ex);
        }
    }

    private RestClient.RequestHeadersSpec<?> validatingPopulateRequest(T grantRequest) {
        this.validateClientAuthenticationMethod(grantRequest);
        return this.populateRequest(grantRequest);
    }

    private void validateClientAuthenticationMethod(T grantRequest) {
        boolean supportedClientAuthenticationMethod;
        ClientRegistration clientRegistration = ((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getClientRegistration();
        ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod();
        boolean bl = supportedClientAuthenticationMethod = clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.NONE) || clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) || clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST);
        if (!supportedClientAuthenticationMethod) {
            throw new IllegalArgumentException(String.format("This class supports `client_secret_basic`, `client_secret_post`, and `none` by default. Client [%s] is using [%s] instead. Please use a supported client authentication method, or use `set/addParametersConverter` or `set/addHeadersConverter` to supply an instance that supports [%s].", clientRegistration.getRegistrationId(), clientAuthenticationMethod, clientAuthenticationMethod));
        }
    }

    private RestClient.RequestHeadersSpec<?> populateRequest(T grantRequest) {
        MultiValueMap parameters = (MultiValueMap)this.parametersConverter.convert(grantRequest);
        if (parameters == null) {
            parameters = new LinkedMultiValueMap();
        }
        this.parametersCustomizer.accept((MultiValueMap<String, String>)parameters);
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getClientRegistration().getProviderDetails().getTokenUri(), new Object[0])).headers(headers -> {
            HttpHeaders headersToAdd = (HttpHeaders)this.headersConverter.convert((Object)grantRequest);
            if (headersToAdd != null) {
                headers.addAll((MultiValueMap)headersToAdd);
            }
        })).body((Object)parameters);
    }

    public final void setRestClient(RestClient restClient) {
        Assert.notNull((Object)restClient, (String)"restClient cannot be null");
        this.restClient = restClient;
    }

    public final void setHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, (String)"headersConverter cannot be null");
        this.headersConverter = headersConverter;
        this.requestEntityConverter = this::populateRequest;
    }

    public final void addHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, (String)"headersConverter cannot be null");
        Converter currentHeadersConverter = this.headersConverter;
        this.headersConverter = authorizationGrantRequest -> {
            HttpHeaders headersToAdd;
            HttpHeaders headers = (HttpHeaders)currentHeadersConverter.convert(authorizationGrantRequest);
            if (headers == null) {
                headers = new HttpHeaders();
            }
            if ((headersToAdd = (HttpHeaders)headersConverter.convert(authorizationGrantRequest)) != null) {
                headers.addAll((MultiValueMap)headersToAdd);
            }
            return headers;
        };
        this.requestEntityConverter = this::populateRequest;
    }

    public final void setParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, (String)"parametersConverter cannot be null");
        if (parametersConverter instanceof DefaultOAuth2TokenRequestParametersConverter) {
            this.parametersConverter = parametersConverter;
        } else {
            DefaultOAuth2TokenRequestParametersConverter defaultParametersConverter = new DefaultOAuth2TokenRequestParametersConverter();
            this.parametersConverter = authorizationGrantRequest -> {
                MultiValueMap parameters = (MultiValueMap)defaultParametersConverter.convert(authorizationGrantRequest);
                MultiValueMap parametersToSet = (MultiValueMap)parametersConverter.convert(authorizationGrantRequest);
                if (parametersToSet != null) {
                    parameters.putAll((Map)parametersToSet);
                }
                return parameters;
            };
        }
        this.requestEntityConverter = this::populateRequest;
    }

    public final void addParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, (String)"parametersConverter cannot be null");
        Converter currentParametersConverter = this.parametersConverter;
        this.parametersConverter = authorizationGrantRequest -> {
            MultiValueMap parametersToAdd;
            MultiValueMap parameters = (MultiValueMap)currentParametersConverter.convert(authorizationGrantRequest);
            if (parameters == null) {
                parameters = new LinkedMultiValueMap();
            }
            if ((parametersToAdd = (MultiValueMap)parametersConverter.convert(authorizationGrantRequest)) != null) {
                parameters.addAll(parametersToAdd);
            }
            return parameters;
        };
        this.requestEntityConverter = this::populateRequest;
    }

    public void setParametersCustomizer(Consumer<MultiValueMap<String, String>> parametersCustomizer) {
        Assert.notNull(parametersCustomizer, (String)"parametersCustomizer cannot be null");
        this.parametersCustomizer = parametersCustomizer;
    }
}

