/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.jdbc.snapshot.dao.legacy;

import java.io.Serializable;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.jdbc.config.SnapshotConfig;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotDao;
import org.apache.pekko.persistence.jdbc.snapshot.dao.legacy.ByteArraySnapshotSerializer;
import org.apache.pekko.persistence.jdbc.snapshot.dao.legacy.SnapshotQueries;
import org.apache.pekko.persistence.jdbc.snapshot.dao.legacy.SnapshotTables;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.stream.Materializer;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.RunnableCompiled;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\r\u001a\u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\t\u0006A!A!\u0002\u0017\u0011\u0006\u0002\u0003-\u0001\u0005\u000b\u0007I1A-\t\u0011\u0001\u0004!\u0011!Q\u0001\niCQ!\u0019\u0001\u0005\u0002\tDq\u0001\u001c\u0001C\u0002\u0013\u0005Q\u000e\u0003\u0004r\u0001\u0001\u0006IA\u001c\u0005\be\u0002\u0011\r\u0011\"\u0001t\u0011\u00199\b\u0001)A\u0005i\")\u0001\u0010\u0001C\u0001s\"9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\tI\b\u0001C!\u0003wBq!a!\u0001\t\u0003\n)\tC\u0004\u0002\u0016\u0002!\t%a&\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0006bBAW\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003k\u0003A\u0011IA\\\u0005Q\u0011\u0015\u0010^3BeJ\f\u0017p\u00158baNDw\u000e\u001e#b_*\u0011!dG\u0001\u0007Y\u0016<\u0017mY=\u000b\u0005qi\u0012a\u00013b_*\u0011adH\u0001\tg:\f\u0007o\u001d5pi*\u0011\u0001%I\u0001\u0005U\u0012\u00147M\u0003\u0002#G\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t!S%A\u0003qK.\\wN\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0004\u0001-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023g5\t1$\u0003\u000257\tY1K\\1qg\"|G\u000fR1p\u0003\t!'\r\u0005\u00028}A\u0011\u0001\bP\u0007\u0002s)\u0011\u0001E\u000f\u0006\u0002w\u0005)1\u000f\\5dW&\u0011Q(\u000f\u0002\f\u0015\u0012\u00147MQ1dW\u0016tG-\u0003\u0002@y\ty!\n\u001a2d\t\u0006$\u0018MY1tK\u0012+g-A\u0004qe>4\u0017\u000e\\3\u0011\u0005a\u0012\u0015BA\":\u0005-QEMY2Qe>4\u0017\u000e\\3\u0002\u001dMt\u0017\r]:i_R\u001cuN\u001c4jOB\u0011a)S\u0007\u0002\u000f*\u0011\u0001jH\u0001\u0007G>tg-[4\n\u0005);%AD*oCB\u001c\bn\u001c;D_:4\u0017nZ\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0011\u00055{U\"\u0001(\u000b\u0005-\u001b\u0013B\u0001)O\u00055\u0019VM]5bY&T\u0018\r^5p]\u0006\u0011Qm\u0019\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+6\n!bY8oGV\u0014(/\u001a8u\u0013\t9FK\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Q.\u0019;\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS!!X\u0012\u0002\rM$(/Z1n\u0013\tyFL\u0001\u0007NCR,'/[1mSj,'/\u0001\u0003nCR\u0004\u0013A\u0002\u001fj]&$h\bF\u0003dQ&T7\u000eF\u0002eM\u001e\u0004\"!\u001a\u0001\u000e\u0003eAQ!\u0015\u0005A\u0004ICQ\u0001\u0017\u0005A\u0004iCQ!\u000e\u0005A\u0002YBQ\u0001\u0011\u0005A\u0002\u0005CQ\u0001\u0012\u0005A\u0002\u0015CQa\u0013\u0005A\u00021\u000bq!];fe&,7/F\u0001o!\t)w.\u0003\u0002q3\ty1K\\1qg\"|G/U;fe&,7/\u0001\u0005rk\u0016\u0014\u0018.Z:!\u0003)\u0019XM]5bY&TXM]\u000b\u0002iB\u0011Q-^\u0005\u0003mf\u00111DQ=uK\u0006\u0013(/Y=T]\u0006\u00048\u000f[8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018aC:fe&\fG.\u001b>fe\u0002\na\u0002^8T]\u0006\u00048\u000f[8u\t\u0006$\u0018\rF\u0002{\u0003\u0013\u0001R\u0001L>~\u0003\u0007I!\u0001`\u0017\u0003\rQ+\b\u000f\\33!\tqx0D\u0001\"\u0013\r\t\t!\t\u0002\u0011':\f\u0007o\u001d5pi6+G/\u00193bi\u0006\u00042\u0001LA\u0003\u0013\r\t9!\f\u0002\u0004\u0003:L\bbBA\u0006\u001b\u0001\u0007\u0011QB\u0001\u0004e><\b\u0003BA\b\u0003_qA!!\u0005\u0002,9!\u00111CA\u0015\u001d\u0011\t)\"a\n\u000f\t\u0005]\u0011Q\u0005\b\u0005\u00033\t\u0019C\u0004\u0003\u0002\u001c\u0005\u0005b\u0002BA\u000f\u0003?i\u0011!J\u0005\u0003I\u0015J!AI\u0012\n\u0005\u0001\n\u0013B\u0001\u0010 \u0013\taR$\u0003\u0002\u001b7%\u0019\u0011QF\r\u0002\u001dMs\u0017\r]:i_R$\u0016M\u00197fg&!\u0011\u0011GA\u001a\u0005-\u0019f.\u00199tQ>$(k\\<\u000b\u0007\u00055\u0012$\u0001\bmCR,7\u000f^*oCB\u001c\bn\u001c;\u0015\t\u0005e\u0012Q\t\t\u0006'\u0006m\u0012qH\u0005\u0004\u0003{!&A\u0002$viV\u0014X\r\u0005\u0003-\u0003\u0003R\u0018bAA\"[\t1q\n\u001d;j_:Dq!a\u0012\u000f\u0001\u0004\tI%A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\t\u0005\u0003\u0017\nIF\u0004\u0003\u0002N\u0005U\u0003cAA([5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'J\u0013A\u0002\u001fs_>$h(C\u0002\u0002X5\na\u0001\u0015:fI\u00164\u0017\u0002BA.\u0003;\u0012aa\u0015;sS:<'bAA,[\u000592O\\1qg\"|GOR8s\u001b\u0006DH+[7fgR\fW\u000e\u001d\u000b\u0007\u0003s\t\u0019'!\u001a\t\u000f\u0005\u001ds\u00021\u0001\u0002J!9\u0011qM\bA\u0002\u0005%\u0014\u0001D7bqRKW.Z:uC6\u0004\bc\u0001\u0017\u0002l%\u0019\u0011QN\u0017\u0003\t1{gnZ\u0001\u0019g:\f\u0007o\u001d5pi\u001a{'/T1y'\u0016\fX/\u001a8dK:\u0013HCBA\u001d\u0003g\n)\bC\u0004\u0002HA\u0001\r!!\u0013\t\u000f\u0005]\u0004\u00031\u0001\u0002j\u0005iQ.\u0019=TKF,XM\\2f\u001dJ\fqe\u001d8baNDw\u000e\u001e$pe6\u000b\u0007pU3rk\u0016t7-\u001a(s\u0003:$W*\u0019=US6,7\u000f^1naRA\u0011\u0011HA?\u0003\u007f\n\t\tC\u0004\u0002HE\u0001\r!!\u0013\t\u000f\u0005]\u0014\u00031\u0001\u0002j!9\u0011qM\tA\u0002\u0005%\u0014\u0001B:bm\u0016$b!a\"\u0002\u0010\u0006M\u0005#B*\u0002<\u0005%\u0005c\u0001\u0017\u0002\f&\u0019\u0011QR\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003#\u0013\u0002\u0019A?\u0002!Mt\u0017\r]:i_RlU\r^1eCR\f\u0007B\u0002\u0010\u0013\u0001\u0004\t\u0019!\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003\u000f\u000bI*a'\t\u000f\u0005\u001d3\u00031\u0001\u0002J!9\u0011QT\nA\u0002\u0005%\u0014AC:fcV,gnY3Oe\u0006\u0011B-\u001a7fi\u0016\fE\u000e\\*oCB\u001c\bn\u001c;t)\u0011\t9)a)\t\u000f\u0005\u001dC\u00031\u0001\u0002J\u00059B-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ\u001d\u000b\u0007\u0003\u000f\u000bI+a+\t\u000f\u0005\u001dS\u00031\u0001\u0002J!9\u0011qO\u000bA\u0002\u0005%\u0014A\u00063fY\u0016$X-\u00169U_6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\r\u0005\u001d\u0015\u0011WAZ\u0011\u001d\t9E\u0006a\u0001\u0003\u0013Bq!a\u001a\u0017\u0001\u0004\tI'\u0001\u0014eK2,G/Z+q)>l\u0015\r_*fcV,gnY3Oe\u0006sG-T1y)&lWm\u001d;b[B$\u0002\"a\"\u0002:\u0006m\u0016Q\u0018\u0005\b\u0003\u000f:\u0002\u0019AA%\u0011\u001d\t9h\u0006a\u0001\u0003SBq!a\u001a\u0018\u0001\u0004\tI\u0007")
public class ByteArraySnapshotDao
implements SnapshotDao {
    private final JdbcBackend.JdbcDatabaseDef db;
    private final JdbcProfile profile;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final SnapshotQueries queries;
    private final ByteArraySnapshotSerializer serializer;

    public Materializer mat() {
        return this.mat;
    }

    public SnapshotQueries queries() {
        return this.queries;
    }

    public ByteArraySnapshotSerializer serializer() {
        return this.serializer;
    }

    public Tuple2<SnapshotMetadata, Object> toSnapshotData(SnapshotTables.SnapshotRow row) {
        Try<Tuple2<SnapshotMetadata, Object>> try_ = this.serializer().deserialize(row);
        if (try_ instanceof Success) {
            return (Tuple2)((Success)try_).value();
        }
        if (try_ instanceof Failure) {
            throw ((Failure)try_).exception();
        }
        throw new MatchError(try_);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> latestSnapshot(String persistenceId) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectLatestByPersistenceId().apply((Object)persistenceId))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable)rows -> rows.headOption().map((Function1 & Serializable)row -> this.toSnapshotData((SnapshotTables.SnapshotRow)row)), this.ec);
    }

    @Override
    public Future<BoxedUnit> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        return Future$.MODULE$.fromTry(this.serializer().serialize(snapshotMetadata, snapshot)).map((Function1 & Serializable)snapshotRow -> this.queries().insertOrUpdate((SnapshotTables.SnapshotRow)snapshotRow), this.ec).flatMap((Function1 & Serializable)a -> $this.db.run(a), this.ec).map((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> delete(String persistenceId, long sequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdAndSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteAllSnapshots(String persistenceId) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectAll().apply((Object)persistenceId)).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {}, this.ec);
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {}, this.ec);
    }

    public ByteArraySnapshotDao(JdbcBackend.JdbcDatabaseDef db, JdbcProfile profile, SnapshotConfig snapshotConfig, Serialization serialization, ExecutionContext ec, Materializer mat) {
        this.db = db;
        this.profile = profile;
        this.ec = ec;
        this.mat = mat;
        this.queries = new SnapshotQueries(profile, snapshotConfig.legacySnapshotTableConfiguration());
        this.serializer = new ByteArraySnapshotSerializer(serialization);
    }
}

