/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;

public enum NumericTypeCategory {
    INTEGER,
    LONG,
    BIG_INTEGER,
    DOUBLE,
    FLOAT,
    BIG_DECIMAL;


    public <N extends Number> N parseLiteralValue(String value) {
        switch (this) {
            case INTEGER: {
                return (N)Integer.valueOf(value);
            }
            case LONG: {
                return (N)Long.valueOf(value);
            }
            case BIG_INTEGER: {
                return (N)new BigInteger(value);
            }
            case DOUBLE: {
                return (N)Double.valueOf(value);
            }
            case FLOAT: {
                return (N)Float.valueOf(value);
            }
            case BIG_DECIMAL: {
                return (N)new BigDecimal(value);
            }
        }
        throw new IllegalStateException(String.format(Locale.ROOT, "Unable to parse numeric literal value `%s` - %s", value, this.name()));
    }
}

