/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.time.Instant;
import java.util.function.Function;
import org.kohsuke.github.function.SupplierThrows;

class GitHubSanityCachedValue<T> {
    private final Object lock = new Object();
    private long lastQueriedAtEpochSeconds = 0L;
    private T lastResult = null;

    GitHubSanityCachedValue() {
    }

    <E extends Throwable> T get(SupplierThrows<T, E> query) throws E {
        return (T)this.get(value -> Boolean.FALSE, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Throwable> T get(Function<T, Boolean> isExpired, SupplierThrows<T, E> query) throws E {
        Object object = this.lock;
        synchronized (object) {
            if (Instant.now().getEpochSecond() > this.lastQueriedAtEpochSeconds || isExpired.apply(this.lastResult).booleanValue()) {
                this.lastResult = query.get();
                this.lastQueriedAtEpochSeconds = Instant.now().getEpochSecond();
            }
        }
        return this.lastResult;
    }
}

