/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.util.function.Function;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.inline.InPredicateRestrictionProducer;
import org.hibernate.query.sqm.mutation.internal.inline.InlineDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.inline.InlineUpdateHandler;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public class InlineMutationStrategy
implements SqmMultiTableMutationStrategy {
    private final Function<SqmDeleteOrUpdateStatement<?>, MatchingIdRestrictionProducer> matchingIdsStrategy;

    public InlineMutationStrategy(Dialect dialect) {
        this(InlineMutationStrategy.determinePredicateProducer(dialect));
    }

    private static Function<SqmDeleteOrUpdateStatement<?>, MatchingIdRestrictionProducer> determinePredicateProducer(Dialect dialect) {
        return statement -> new InPredicateRestrictionProducer();
    }

    public InlineMutationStrategy(Function<SqmDeleteOrUpdateStatement<?>, MatchingIdRestrictionProducer> matchingIdsStrategy) {
        this.matchingIdsStrategy = matchingIdsStrategy;
    }

    @Override
    public int executeUpdate(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        InlineUpdateHandler handler = new InlineUpdateHandler(this.matchingIdsStrategy.apply(sqmUpdate), sqmUpdate, domainParameterXref, context);
        return handler.execute(context);
    }

    @Override
    public int executeDelete(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        InlineDeleteHandler deleteHandler = new InlineDeleteHandler(this.matchingIdsStrategy.apply(sqmDelete), sqmDelete, domainParameterXref, context);
        return deleteHandler.execute(context);
    }
}

