/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

final class FileTypeMap {
    private final Map<String, String> mimeTypeMap = new HashMap<String, String>();
    private final Map<String, String> extensionMap = new HashMap<String, String>();

    FileTypeMap() {
    }

    public void addExtension(String extension, String scheme) {
        this.extensionMap.put(extension, scheme);
    }

    public void addMimeType(String mimeType, String scheme) {
        this.mimeTypeMap.put(mimeType, scheme);
    }

    public void clear() {
        this.mimeTypeMap.clear();
        this.extensionMap.clear();
    }

    public String getScheme(FileObject fileObject) throws FileSystemException {
        FileContent content = fileObject.getContent();
        String mimeType = content.getContentInfo().getContentType();
        if (mimeType != null) {
            return this.mimeTypeMap.get(mimeType);
        }
        if (!fileObject.isFile()) {
            return null;
        }
        return this.extensionMap.get(fileObject.getName().getExtension());
    }
}

