import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper, act } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { ActiveTileSkeleton } from '../../CommonCardTile/active-tile.skeleton';
import { initialState as releaseTileInitialState } from './ducks/release-tile.reducer';
import { ReleaseTileComponent, ReleaseTileProps } from './release-tile.component';
import { ActiveReleaseTile } from './active-release-tile.component';

describe('ReleaseTileComponent', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const title = 'Releases';
    const description = 'Test release description';

    const defaultProps: ReleaseTileProps = {
        title,
        description,
    };

    const defaultState = {
        releaseTile: { ...releaseTileInitialState, isLoading: false },
    };

    const mount = async (props: ReleaseTileProps = defaultProps, state = defaultState) => {
        await act(async () => {
            wrapper = mountWithStoreAndTheme(<ReleaseTileComponent {...props} />, dispatch, state);
        });
    };

    const getCommonCardTileComponent = () => wrapper.find(CommonCardTileComponent);
    const getFirstButton = () => wrapper.find(DotButton).at(0);
    const getSecondButton = () => wrapper.find(DotButton).at(1);
    const getActiveReleaseTile = () => wrapper.find(ActiveReleaseTile);
    const getActiveTileSkeleton = () => wrapper.find(ActiveTileSkeleton);

    it('should render with correct props', async () => {
        await mount();
        const props = getCommonCardTileComponent().props();
        expect(props.title).toBe(title);
        expect(props.description).toBe(description);
        expect(props.imageLink).toBe('static/24.3.5/styles/img/timeline_monochromatic.svg');
        expect(props.primaryButton.buttonCaption).toBe('View releases');
        expect(props.primaryButton.buttonType).toBe('text');
        expect(props.secondaryButton?.buttonCaption).toBe('Start release');
        expect(props.secondaryButton?.buttonType).toBe('outlined');
        expect(getActiveReleaseTile()).not.toExist();
        expect(getActiveTileSkeleton()).not.toExist();
    });

    it('should handle click event', async () => {
        await mount();
        const firstButton = getFirstButton();
        firstButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/releases`);
        const secondButton = getSecondButton();
        secondButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/releases/create?fromHome=true`);
    });

    it('should show active tile skeleton if loading', async () => {
        await mount(defaultProps, { ...defaultState, releaseTile: { ...releaseTileInitialState, isLoading: true } });
        expect(getActiveTileSkeleton()).toExist();
    });
});
