/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskCalculator;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\f\u0019\u0001\rB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!i\u0005A!A!\u0002\u0013q\u0005\"\u0002+\u0001\t\u0003)\u0006bB6\u0001\u0001\u0004%I\u0001\u001c\u0005\bg\u0002\u0001\r\u0011\"\u0003u\u0011\u0019Q\b\u0001)Q\u0005[\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0002\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u000e\u0001\t\u0003\t\u0019\u0007C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBAP\u0001\u0011%\u0011\u0011\u0015\u0005\b\u0003S\u0003A\u0011BAV\u0011\u001d\t\t\f\u0001C!\u0003gCq!!.\u0001\t\u0003\n9\fC\u0004\u0002:\u0002!\t%a.\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\nY!+[:l'\u0016\u0014h/[2f\u0015\tI\"$A\u0004tKJ4\u0018nY3\u000b\u0005ma\u0012\u0001\u0002:jg.T!!\b\u0010\u0002\u0013ad'/\u001a7fCN,'BA\u0010!\u0003%AXMY5bY\u0006\u00147OC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001A\u0005L\u0019\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001\u00027b]\u001eT\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,M\t1qJ\u00196fGR\u0004\"!L\u0018\u000e\u00039R!!\u0007\u000f\n\u0005Ar#A\u0004$fCR,(/Z*feZL7-\u001a\t\u0003eMj\u0011\u0001G\u0005\u0003ia\u0011aBU5tW\u000e\u000bGnY;mCR|'/\u0001\bsSN\\'+\u001a9pg&$xN]=\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eR\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\b\u000f\u0002\u000f%&\u001c8NU3q_NLGo\u001c:z\u0003I\u0011\u0018n]6Qe>4\u0017\u000e\\3TKJ4\u0018nY3\u0011\u0005Ir\u0014BA \u0019\u0005I\u0011\u0016n]6Qe>4\u0017\u000e\\3TKJ4\u0018nY3\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005\t+U\"A\"\u000b\u0005\u0011c\u0012AB1di>\u00148/\u0003\u0002G\u0007\n\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005%[U\"\u0001&\u000b\u0005eb\u0012B\u0001'K\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bH\u0001\u0007KZ,g\u000e^:\n\u0005M\u0003&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"bAV,Y3j[\u0006C\u0001\u001a\u0001\u0011\u0015)d\u00011\u00017\u0011\u0015ad\u00011\u0001>\u0011\u0015\u0001e\u00011\u0001B\u0011\u00159e\u00011\u0001I\u0011\u0015ie\u00011\u0001OQ\t1Q\f\u0005\u0002_S6\tqL\u0003\u0002aC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\t\u001c\u0017a\u00024bGR|'/\u001f\u0006\u0003I\u0016\fQAY3b]NT!AZ4\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001[\u0001\u0004_J<\u0017B\u00016`\u0005%\tU\u000f^8xSJ,G-A\u0004f]\u0006\u0014G.\u001a3\u0016\u00035\u0004\"A\\9\u000e\u0003=T\u0011\u0001]\u0001\u0006g\u000e\fG.Y\u0005\u0003e>\u0014qAQ8pY\u0016\fg.A\u0006f]\u0006\u0014G.\u001a3`I\u0015\fHCA;y!\tqg/\u0003\u0002x_\n!QK\\5u\u0011\u001dI\b\"!AA\u00025\f1\u0001\u001f\u00132\u0003!)g.\u00192mK\u0012\u0004\u0003FA\u0005}!\tqW0\u0003\u0002\u007f_\nAao\u001c7bi&dW-A\tsSN\\\u0017i]:fgN|'\u000fV=qKN,\"!a\u0001\u0011\r\u0005\u0015\u0011QCA\u000e\u001d\u0011\t9!!\u0005\u000f\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004#\u0003\u0019a$o\\8u}%\t\u0001/C\u0002\u0002\u0014=\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0018\u0005e!\u0001\u0002'jgRT1!a\u0005p!\u0011\ti\"a\f\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tqA]3gY\u0016\u001cGO\u0003\u0003\u0002&\u0005\u001d\u0012aA1qS*!\u0011\u0011FA\u0016\u0003\u0019\u0001H.^4j]*\u0019\u0011Q\u0006\u0010\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!\r\u0002 \t!A+\u001f9f\u0003I\u0011\u0018n]6BgN,7o]8s)f\u0004Xm\u001d\u0011\u0002;\r\fGnY;mCR,'+[:l\u0003:$W\u000b\u001d3bi\u0016\u0014V\r\\3bg\u0016$2!^A\u001d\u0011\u001d\tY\u0004\u0004a\u0001\u0003{\t\u0011B]3mK\u0006\u001cX-\u00133\u0011\t\u0005}\u0012q\t\b\u0005\u0003\u0003\n\u0019\u0005E\u0002\u0002\n=L1!!\u0012p\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011JA&\u0005\u0019\u0019FO]5oO*\u0019\u0011QI8)\u000f1\ty%!\u0018\u0002`A!\u0011\u0011KA-\u001b\t\t\u0019FC\u0002a\u0003+R1!a\u0016f\u0003)\u00198\r[3ek2LgnZ\u0005\u0005\u00037\n\u0019FA\u0003Bgft7-A\u0003wC2,X-\t\u0002\u0002b\u00059\"/[:l\u0007\u0006d7-\u001e7bi&|g.\u0012=fGV$xN\u001d\u000b\u0004k\u0006\u0015\u0004bBA4\u001b\u0001\u0007\u0011\u0011N\u0001\be\u0016dW-Y:f!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA89\u00051Am\\7bS:LA!a\u001d\u0002n\t9!+\u001a7fCN,\u0007fB\u0007\u0002P\u0005u\u0013qL\u0001\u000bkB$\u0017\r^3SSN\\G#B;\u0002|\u0005u\u0004bBA\u001e\u001d\u0001\u0007\u0011Q\b\u0005\b\u0003\u007fr\u0001\u0019AAA\u0003\u001d)\b\u000fZ1uK\u0012\u0004B!a!\u0002\b6\u0011\u0011Q\u0011\u0006\u0004\u0003_R\u0012\u0002BAE\u0003\u000b\u0013AAU5tW\u0006)\"/[:l\u0003N\u001cXm]:nK:$8\t[1oO\u0016$G#B7\u0002\u0010\u0006M\u0005bBAI\u001f\u0001\u0007\u0011\u0011Q\u0001\u0002C\"9\u0011QS\bA\u0002\u0005\u0005\u0015!\u00012\u0002\u0019M\u001cwN]3DQ\u0006tw-\u001a3\u0015\u000b5\fY*!(\t\u000f\u0005E\u0005\u00031\u0001\u0002\u0002\"9\u0011Q\u0013\tA\u0002\u0005\u0005\u0015AD4f]\u0016\u0014\u0018\r^3SSN\\\u0017\n\u001a\u000b\u0005\u0003G\u000b9\u000bE\u0002&\u0003KK1!!\u0013'\u0011\u001d\tY$\u0005a\u0001\u0003{\t!cZ3oKJ\fG/Z!tg\u0016\u001c8o\u001c:JIR!\u0011QHAW\u0011\u001d\tyK\u0005a\u0001\u0003{\tA\"Y:tKN\u001cxN\u001d(b[\u0016\fAA\\1nKR\u0011\u0011QH\u0001\u0007K:\f'\r\\3\u0015\u0003U\fq\u0001Z5tC\ndW-A\u0005jg\u0016s\u0017M\u00197fIR\tQ\u000eK\u0002\u0001\u0003\u0003\u0004B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000f,\u0017AC:uKJ,w\u000e^=qK&!\u00111ZAc\u0005\u001d\u0019VM\u001d<jG\u0016Ds\u0001AAh\u0003;\fy\u000e\u0005\u0003\u0002R\u0006eWBAAj\u0015\r\u0001\u0017Q\u001b\u0006\u0004\u0003/,\u0017aB2p]R,\u0007\u0010^\u0005\u0005\u00037\f\u0019NA\u0003TG>\u0004X-A\u0005qe>D\u00180T8eK\u0012\u0012\u0011\u0011]\u0005\u0005\u0003G\f)/\u0001\u0007U\u0003J;U\tV0D\u0019\u0006\u001b6K\u0003\u0003\u0002h\u0006M\u0017aD*d_B,G\r\u0015:pqflu\u000eZ3")
public class RiskService
implements FeatureService,
RiskCalculator {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseActorService releaseActorService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private volatile boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Risk calculateRisk(RiskProfile profile, List<RiskAssessor> riskAssessors, Risk risk, Release release) {
        return RiskCalculator.calculateRisk$(this, profile, riskAssessors, risk, release);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @ManagedOperation(description="Stop service")
    public void stop() {
        super.stop();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        this.calculateRiskAndUpdateRelease(release);
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(Release release) {
        if (release.isPlannedOrActive() && !release.isWorkflow()) {
            Risk originalRisk = this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
            RiskProfile riskProfileByRelease = (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
            List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
            Risk updatedRisk = this.calculateRisk(riskProfileByRelease, (List<RiskAssessor>)riskAssessors, originalRisk, release);
            if (this.enabled()) {
                this.updateRisk(release.getId(), updatedRisk);
                return;
            }
            return;
        }
    }

    private void updateRisk(String releaseId, Risk updated) {
        Some some;
        Risk original;
        boolean bl;
        Option<Risk> maybeOriginal;
        this.logger().debug((Function0 & Serializable)() -> "UpdateRisk(" + releaseId + ")");
        String riskId = releaseId + "/Risk";
        Option<Risk> option = maybeOriginal = this.riskRepository.read(riskId);
        if (None$.MODULE$.equals(option)) {
            this.riskRepository.create(updated);
            this.logger().info((Function0 & Serializable)() -> "Created risk score for release " + releaseId + ": " + updated.getScore() + " and total risk score " + updated.getTotalScore());
            bl = true;
        } else if (option instanceof Some && (original = (Risk)(some = (Some)option).value()) != null) {
            Risk risk = original;
            if (this.scoreChanged(risk, updated) || this.riskAssessmentChanged(risk, updated)) {
                this.riskRepository.update(updated);
                this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + risk.getScore() + " to " + updated.getScore() + "\n               | and total risk score from " + risk.getTotalScore() + " to " + updated.getTotalScore())));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            throw new MatchError(option);
        }
        boolean doUpdate = bl;
        if (doUpdate) {
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.releaseActorService.updateReleaseRiskScores(releaseId, updated.getScore(), updated.getTotalScore());
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, maybeOriginal, updated));
            return;
        }
    }

    private boolean riskAssessmentChanged(Risk a, Risk b) {
        Function1 & Serializable keyMapping = (Function1 & Serializable)ra -> ra.getRiskAssessorId();
        Function2 & Serializable areEqual = (Function2 & Serializable)(ra1, ra2) -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessmentChanged$2(ra1, ra2));
        Diff diff = Diff$.MODULE$.applyWithKeyMappingAndComparator(CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)a.getRiskAssessments()).asScala(), CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)b.getRiskAssessments()).asScala(), (Function1)keyMapping, (Function2)areEqual);
        return diff.updatedEntries().nonEmpty() || diff.newEntries().nonEmpty() || diff.deletedEntries().nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public String name() {
        return "RiskService";
    }

    public void enable() {
        this.enabled_$eq(true);
    }

    public void disable() {
        this.enabled_$eq(false);
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    private static final boolean safeEquals$1(Object x, Object y) {
        Option option = Option$.MODULE$.apply(x);
        Option option2 = Option$.MODULE$.apply(y);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessmentChanged$2(RiskAssessment ra1, RiskAssessment ra2) {
        return RiskService.safeEquals$1(ra1.getScore(), ra2.getScore()) && RiskService.safeEquals$1(ra1.getHeadline(), ra2.getHeadline()) && RiskService.safeEquals$1(ra1.getMessages(), ra2.getMessages());
    }

    @Autowired
    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseActorService releaseActorService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseActorService = releaseActorService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        RiskCalculator.$init$(this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

