/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.strikethrough;

import java.util.Collections;
import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.strikethrough.internal.StrikethroughDelimiterProcessor;
import org.commonmark.ext.gfm.strikethrough.internal.StrikethroughHtmlNodeRenderer;
import org.commonmark.ext.gfm.strikethrough.internal.StrikethroughMarkdownNodeRenderer;
import org.commonmark.ext.gfm.strikethrough.internal.StrikethroughTextContentNodeRenderer;
import org.commonmark.parser.Parser;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownNodeRendererFactory;
import org.commonmark.renderer.markdown.MarkdownRenderer;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentNodeRendererFactory;
import org.commonmark.renderer.text.TextContentRenderer;

public class StrikethroughExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
TextContentRenderer.TextContentRendererExtension,
MarkdownRenderer.MarkdownRendererExtension {
    private final boolean requireTwoTildes;

    private StrikethroughExtension(Builder builder) {
        this.requireTwoTildes = builder.requireTwoTildes;
    }

    public static Extension create() {
        return StrikethroughExtension.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.customDelimiterProcessor((DelimiterProcessor)new StrikethroughDelimiterProcessor(this.requireTwoTildes));
    }

    public void extend(HtmlRenderer.Builder rendererBuilder) {
        rendererBuilder.nodeRendererFactory(new HtmlNodeRendererFactory(){

            public NodeRenderer create(HtmlNodeRendererContext context) {
                return new StrikethroughHtmlNodeRenderer(context);
            }
        });
    }

    public void extend(TextContentRenderer.Builder rendererBuilder) {
        rendererBuilder.nodeRendererFactory(new TextContentNodeRendererFactory(){

            public NodeRenderer create(TextContentNodeRendererContext context) {
                return new StrikethroughTextContentNodeRenderer(context);
            }
        });
    }

    public void extend(MarkdownRenderer.Builder rendererBuilder) {
        rendererBuilder.nodeRendererFactory(new MarkdownNodeRendererFactory(){

            public NodeRenderer create(MarkdownNodeRendererContext context) {
                return new StrikethroughMarkdownNodeRenderer(context);
            }

            public Set<Character> getSpecialCharacters() {
                return Collections.singleton(Character.valueOf('~'));
            }
        });
    }

    public static class Builder {
        private boolean requireTwoTildes = false;

        public Builder requireTwoTildes(boolean requireTwoTildes) {
            this.requireTwoTildes = requireTwoTildes;
            return this;
        }

        public Extension build() {
            return new StrikethroughExtension(this);
        }
    }
}

