/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class PDUv1
extends PDU {
    private static final long serialVersionUID = -6478805117911347898L;
    public static final int COLDSTART = 0;
    public static final int WARMSTART = 1;
    public static final int LINKDOWN = 2;
    public static final int LINKUP = 3;
    public static final int AUTHENTICATIONFAILURE = 4;
    public static final int ENTERPRISE_SPECIFIC = 6;
    private static final String OPERATION_NOT_SUPPORTED = "Operation not supported for SNMPv1 PDUs";
    private OID enterprise = new OID();
    private IpAddress agentAddress = new IpAddress("0.0.0.0");
    private Integer32 genericTrap = new Integer32(0);
    private Integer32 specificTrap = new Integer32(0);
    private TimeTicks timestamp = new TimeTicks(0L);

    public PDUv1() {
        this.setType(-92);
    }

    public PDUv1(PDUv1 pDUv1) {
        super(pDUv1);
        this.enterprise = (OID)pDUv1.enterprise.clone();
        this.agentAddress = (IpAddress)pDUv1.agentAddress.clone();
        this.genericTrap = (Integer32)pDUv1.genericTrap.clone();
        this.specificTrap = (Integer32)pDUv1.specificTrap.clone();
        this.timestamp = (TimeTicks)pDUv1.timestamp.clone();
    }

    public Object clone() {
        return new PDUv1(this);
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n = BER.decodeHeader(bERInputStream, mutableByte);
        int n2 = (int)bERInputStream.getPosition();
        switch (mutableByte.getValue()) {
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: {
                break;
            }
            default: {
                throw new IOException("Unsupported PDU type: " + mutableByte.getValue());
            }
        }
        this.setType(mutableByte.getValue());
        if (this.getType() == -92) {
            this.enterprise.decodeBER(bERInputStream);
            this.agentAddress.decodeBER(bERInputStream);
            this.genericTrap.decodeBER(bERInputStream);
            this.specificTrap.decodeBER(bERInputStream);
            this.timestamp.decodeBER(bERInputStream);
        } else {
            this.requestID.decodeBER(bERInputStream);
            this.errorStatus.decodeBER(bERInputStream);
            this.errorIndex.decodeBER(bERInputStream);
        }
        mutableByte = new BER.MutableByte();
        int n3 = BER.decodeHeader(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 48) {
            throw new IOException("Encountered invalid tag, SEQUENCE expected: " + mutableByte.getValue());
        }
        int n4 = (int)bERInputStream.getPosition();
        this.variableBindings = new Vector();
        while (bERInputStream.getPosition() - (long)n4 < (long)n3) {
            VariableBinding variableBinding = new VariableBinding();
            variableBinding.decodeBER(bERInputStream);
            if (!this.isVariableV1(variableBinding.getVariable())) {
                throw new MessageException("Counter64 encountered in SNMPv1 PDU (RFC 2576 \u00a74.1.2.1)");
            }
            this.variableBindings.add(variableBinding);
        }
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(n3, (int)bERInputStream.getPosition() - n4, this);
            BER.checkSequenceLength(n, (int)bERInputStream.getPosition() - n2, this);
        }
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        int n;
        BER.encodeHeader(outputStream, this.type, this.getBERPayloadLength());
        if (this.type == -92) {
            this.enterprise.encodeBER(outputStream);
            this.agentAddress.encodeBER(outputStream);
            this.genericTrap.encodeBER(outputStream);
            this.specificTrap.encodeBER(outputStream);
            this.timestamp.encodeBER(outputStream);
        } else {
            this.requestID.encodeBER(outputStream);
            this.errorStatus.encodeBER(outputStream);
            this.errorIndex.encodeBER(outputStream);
        }
        int n2 = 0;
        for (n = 0; n < this.variableBindings.size(); ++n) {
            n2 += ((VariableBinding)this.variableBindings.get(n)).getBERLength();
        }
        BER.encodeHeader(outputStream, 48, n2);
        for (n = 0; n < this.variableBindings.size(); ++n) {
            VariableBinding variableBinding = (VariableBinding)this.variableBindings.get(n);
            if (!this.isVariableV1(variableBinding.getVariable())) {
                throw new IOException("Cannot encode Counter64 into a SNMPv1 PDU");
            }
            variableBinding.encodeBER(outputStream);
        }
    }

    protected boolean isVariableV1(Variable variable) {
        return !(variable instanceof Counter64);
    }

    protected int getBERPayloadLengthPDU() {
        if (this.getType() != -92) {
            return super.getBERPayloadLengthPDU();
        }
        int n = 0;
        for (int i = 0; i < this.variableBindings.size(); ++i) {
            n += ((VariableBinding)this.variableBindings.get(i)).getBERLength();
        }
        n += BER.getBERLengthOfLength(n) + 1;
        n += this.agentAddress.getBERLength();
        n += this.enterprise.getBERLength();
        n += this.genericTrap.getBERLength();
        n += this.specificTrap.getBERLength();
        return n += this.timestamp.getBERLength();
    }

    public int getMaxRepetitions() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    public void setMaxRepetitions(int n) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    public void setMaxSizeScopedPDU(int n) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    public void setNonRepeaters(int n) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
    }

    private void checkV1TRAP() {
        if (this.getType() != -92) {
            throw new UnsupportedOperationException("Operation is only supported for SNMPv1 trap PDUs (V1TRAP)");
        }
    }

    public OID getEnterprise() {
        this.checkV1TRAP();
        return this.enterprise;
    }

    public void setEnterprise(OID oID) {
        this.checkV1TRAP();
        this.checkNull(oID);
        this.enterprise = (OID)oID.clone();
    }

    public IpAddress getAgentAddress() {
        this.checkV1TRAP();
        return this.agentAddress;
    }

    public void setAgentAddress(IpAddress ipAddress) {
        this.checkV1TRAP();
        this.checkNull(ipAddress);
        this.agentAddress = ipAddress;
    }

    public int getGenericTrap() {
        this.checkV1TRAP();
        return this.genericTrap.getValue();
    }

    public void setGenericTrap(int n) {
        this.checkV1TRAP();
        this.genericTrap.setValue(n);
    }

    public int getSpecificTrap() {
        this.checkV1TRAP();
        return this.specificTrap.getValue();
    }

    public void setSpecificTrap(int n) {
        this.checkV1TRAP();
        this.specificTrap.setValue(n);
    }

    public long getTimestamp() {
        this.checkV1TRAP();
        return this.timestamp.getValue();
    }

    public void setTimestamp(long l) {
        this.checkV1TRAP();
        this.timestamp.setValue(l);
    }

    protected void checkNull(Object object) {
        if (object == null) {
            throw new NullPointerException("Members of PDUv1 must not be null");
        }
    }

    public String toString() {
        if (this.type == -92) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PDUv1.getTypeString(this.type));
            stringBuffer.append("[reqestID=");
            stringBuffer.append(this.requestID);
            stringBuffer.append(",timestamp=");
            stringBuffer.append(this.timestamp);
            stringBuffer.append(",enterprise=");
            stringBuffer.append(this.enterprise);
            stringBuffer.append(",genericTrap=");
            stringBuffer.append(this.genericTrap);
            stringBuffer.append(",specificTrap=");
            stringBuffer.append(this.specificTrap);
            stringBuffer.append(", VBS[");
            for (int i = 0; i < this.variableBindings.size(); ++i) {
                stringBuffer.append(this.variableBindings.get(i));
                if (i + 1 >= this.variableBindings.size()) continue;
                stringBuffer.append("; ");
            }
            stringBuffer.append("]]");
            return stringBuffer.toString();
        }
        return super.toString();
    }
}

