/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Compiler;
import com.rabbitmq.jms.parse.ParseTreeTraverser;
import com.rabbitmq.jms.parse.sql.SqlCompilerVisitor;
import com.rabbitmq.jms.parse.sql.SqlEvaluator;
import com.rabbitmq.jms.parse.sql.SqlParseTree;

public class SqlCompiler
implements Compiler {
    private final String compiledCode;
    private final boolean compileOk;
    private final String errorMessage;

    public SqlCompiler(SqlEvaluator eval) {
        if (eval.evaluatorOk()) {
            SqlCompilerVisitor compilerVisitor;
            SqlParseTree parseTree = eval.typedParseTree();
            this.compileOk = ParseTreeTraverser.traverse(parseTree, compilerVisitor = new SqlCompilerVisitor());
            if (this.compileOk) {
                this.compiledCode = compilerVisitor.extractCode() + ".";
                this.errorMessage = null;
            } else {
                this.compiledCode = null;
                this.errorMessage = "Could not compile parsed tree " + parseTree.formattedTree();
            }
        } else {
            this.compileOk = false;
            this.compiledCode = null;
            this.errorMessage = eval.getErrorMessage();
        }
    }

    @Override
    public String compile() {
        return this.compiledCode;
    }

    @Override
    public boolean compileOk() {
        return this.compileOk;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

