/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.scm.connector.ScmConnectorService;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse$;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings$;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.views.TemplateContentAndPrevious;
import com.xebialabs.xlrelease.versioning.templates.views.VersionView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@Path(value="/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011i\u0003!\u0011!Q\u0001\nmC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\")q\u000e\u0001C\u0001a\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!3\u0001\t\u0003\tY\rC\u0004\u0002r\u0002!\t!a=\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!\u0011\u0006\u0001\u0005\u0002\t-\u0002b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u0013!\u0004V3na2\fG/\u001a,feNLwN\\5oOJ+7o\\;sG\u0016T!\u0001G\r\u0002\u0013Q,W\u000e\u001d7bi\u0016\u001c(B\u0001\u000e\u001c\u0003)1XM]:j_:Lgn\u001a\u0006\u00039u\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005yy\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0013aA2p[\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000bMdg\r\u000e6\u000b\u00039\n\u0001b\u001a:jujdW\rZ\u0005\u0003a-\u0012q\u0001T8hO&tw-A\u0006eg2,\u0005\u0010]8si\u0016\u0014\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u001d\u0019XM\u001d<jG\u0016T!aN\u000e\u0002\u0007\u0011\u001cH.\u0003\u0002:i\tYAi\u001d7FqB|'\u000f^3s\u0003i!X-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z!\tat(D\u0001>\u0015\tqt#\u0001\u0006sKB|7/\u001b;pefL!\u0001Q\u001f\u00035Q+W\u000e\u001d7bi\u0016\u0014VM^5tS>t'+\u001a9pg&$xN]=\u0002-Q,W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u0011#\u000e\u0003]I!!R\f\u0003-Q+W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\f1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001S&\u000e\u0003%S!AS\u000e\u0002\r\u0005\u001cGo\u001c:t\u0013\ta\u0015JA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-A\tqKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\u0004\"a\u0014*\u000e\u0003AS!!U\u000e\u0002\u0011M,7-\u001e:jifL!a\u0015)\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0011\u0005YCV\"A,\u000b\u0005UZ\u0012BA-X\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005qsV\"A/\u000b\u0005yZ\u0012BA0^\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\fuK6\u0004H.\u0019;f'R|'/Y4f\u0019&\u001cH/\u001a8feB\u0011!-Z\u0007\u0002G*\u0011A-G\u0001\u0004g\u000el\u0017B\u00014d\u0005e\u00196-\u001c+f[Bd\u0017\r^3Ti>\u0014\u0018mZ3TKJ4\u0018nY3\u0002'M\u001cWnQ8o]\u0016\u001cGo\u001c:TKJ4\u0018nY3\u0011\u0005%lW\"\u00016\u000b\u0005-d\u0017!C2p]:,7\r^8s\u0015\t!7$\u0003\u0002oU\n\u00192kY7D_:tWm\u0019;peN+'O^5dK\u00061A(\u001b8jiz\"\"\"\u001d:tiV4x\u000f_={!\t\u0019\u0005\u0001C\u00032\u0015\u0001\u0007!\u0007C\u0003;\u0015\u0001\u00071\bC\u0003B\u0015\u0001\u0007!\tC\u0003G\u0015\u0001\u0007q\tC\u0003N\u0015\u0001\u0007a\nC\u0003U\u0015\u0001\u0007Q\u000bC\u0003[\u0015\u0001\u00071\fC\u0003a\u0015\u0001\u0007\u0011\rC\u0003h\u0015\u0001\u0007\u0001\u000e\u000b\u0002\u000byB\u0019Q0!\u0005\u000e\u0003yT1a`A\u0001\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u0007\t)!A\u0004gC\u000e$xN]=\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003\u0017\ti!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty!A\u0002pe\u001eL1!a\u0005\u007f\u0005%\tU\u000f^8xSJ,G-\u0001\u0010hKR$V-\u001c9mCR,g+\u001a:tS>tw.\u001b8h'\u0016$H/\u001b8hgV\u0011\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0019!w.\\1j]*\u0019\u00111E\f\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\t9#!\b\u00035Q+W\u000e\u001d7bi\u00164VM]:j_:LgnZ*fiRLgnZ:)\u0007-\tY\u0003\u0005\u0003\u0002.\u0005mRBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0005I\u001c(\u0002BA\u001b\u0003o\t!a^:\u000b\u0005\u0005e\u0012a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0003{\tyCA\u0002H\u000bRCsaCA!\u0003\u000f\nI\u0005\u0005\u0003\u0002.\u0005\r\u0013\u0002BA#\u0003_\u0011A\u0001U1uQ\u0006)a/\u00197vK\u0006\u0012\u00111J\u0001\n_M,G\u000f^5oON\fabY8o]\u0016\u001cG/[8o\u0013:4w\u000e\u0006\u0003\u0002R\u0005u\u0003\u0003BA*\u00033j!!!\u0016\u000b\t\u0005]\u0013qF\u0001\u0005G>\u0014X-\u0003\u0003\u0002\\\u0005U#\u0001\u0003*fgB|gn]3\t\u000f\u0005}C\u00021\u0001\u0002b\u0005QA/Z7qY\u0006$X-\u00133\u0011\t\u0005\r\u0014\u0011\u000f\b\u0005\u0003K\ni\u0007E\u0002\u0002h\u0015j!!!\u001b\u000b\u0007\u0005-\u0014%\u0001\u0004=e>|GOP\u0005\u0004\u0003_*\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002t\u0005U$AB*ue&twMC\u0002\u0002p\u0015B\u0003\"!\u0018\u0002z\u0005\u001d\u0013q\u0010\t\u0005\u0003[\tY(\u0003\u0003\u0002~\u0005=\"!\u0003)bi\"\u0004\u0016M]1nC\t\ty\u0006\u000b\u0003\u0002^\u0005\r\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%5$A\u0003qCJ\fW.\u0003\u0003\u0002\u000e\u0006\u001d%aB%e!\u0006\u0014\u0018-\u001c\u0015\u0004\u0019\u0005-\u0002f\u0002\u0007\u0002B\u0005\u001d\u00131S\u0011\u0003\u0003+\u000b1f\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSpL2p]:,7\r^5p]&sgm\\\u0001\rO\u0016$(+\u001a<jg&|gn\u001d\u000b\u0005\u0003#\nY\nC\u0004\u0002`5\u0001\r!!\u0019)\u0011\u0005m\u0015\u0011PA$\u0003\u007fBC!a'\u0002\u0004\"\u001aQ\"a\u000b)\u000f5\t\t%a\u0012\u0002&\u0006\u0012\u0011qU\u0001(_m$X-\u001c9mCR,\u0017\n\u001a\u001e/UI+G.Z1tKnsv&L/+{>\u0012XM^5tS>t7/\u0001\nhKR\u0014VM^5tS>t7i\u001c8uK:$HCBA)\u0003[\u000b\u0019\fC\u0004\u0002`9\u0001\r!!\u0019)\u0011\u00055\u0016\u0011PA$\u0003\u007fBC!!,\u0002\u0004\"9\u0011Q\u0017\bA\u0002\u0005]\u0016A\u0003:fm&\u001c\u0018n\u001c8JIB\u0019A%!/\n\u0007\u0005mVEA\u0002J]RD\u0003\"a-\u0002z\u0005\u001d\u0013qX\u0011\u0003\u0003kC3ADA\u0016Q\u001dq\u0011\u0011IA$\u0003\u000b\f#!a2\u0002y=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|#/\u001a<jg&|gn]\u0018|e\u00164\u0018n]5p]&#WpL2p]R,g\u000e^\u0001\u000eGJ,\u0017\r^3WKJ\u001c\u0018n\u001c8\u0015\r\u0005E\u0013QZAj\u0011\u001d\tyf\u0004a\u0001\u0003CB\u0003\"!4\u0002z\u0005\u001d\u0013q\u0010\u0015\u0005\u0003\u001b\f\u0019\tC\u0004\u0002V>\u0001\r!a6\u0002\u0017Y,'o]5p]ZKWm\u001e\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\\\f\u0002\u000bYLWm^:\n\t\u0005\u0005\u00181\u001c\u0002\f-\u0016\u00148/[8o-&,w\u000fK\u0002\u0010\u0003K\u0004B!!\f\u0002h&!\u0011\u0011^A\u0018\u0005\u0011\u0001vj\u0015+)\u000f=\t\t%a\u0012\u0002n\u0006\u0012\u0011q^\u0001'_m$X-\u001c9mCR,\u0017\n\u001a\u001e/UI+G.Z1tKnsv&L/+{>2XM]:j_:\u001c\u0018a\u0004:fgR|'/\u001a*fm&\u001c\u0018n\u001c8\u0015\r\u0005E\u0013Q_A~\u0011\u001d\ty\u0006\u0005a\u0001\u0003CB\u0003\"!>\u0002z\u0005\u001d\u0013q\u0010\u0015\u0005\u0003k\f\u0019\tC\u0004\u00026B\u0001\r!a.)\u0011\u0005m\u0018\u0011PA$\u0003\u007fC3\u0001\u0005B\u0001!\u0011\tiCa\u0001\n\t\t\u0015\u0011q\u0006\u0002\u0004!V#\u0006f\u0002\t\u0002B\u0005\u001d#\u0011B\u0011\u0003\u0005\u0017\tAhL>uK6\u0004H.\u0019;f\u0013\u0012TdF\u000b*fY\u0016\f7/Z.__5j&&`\u0018sKZL7/[8og>Z(/\u001a<jg&|g.\u00133~_I,7\u000f^8sK\u0006qA-\u001a7fi\u0016\u0014VM^5tS>tGCBA)\u0005#\u00119\u0002C\u0004\u0002`E\u0001\r!!\u0019)\u0011\tE\u0011\u0011PA$\u0003\u007fBCA!\u0005\u0002\u0004\"9\u0011QW\tA\u0002\u0005]\u0006\u0006\u0003B\f\u0003s\n9%a0)\u0007E\u0011i\u0002\u0005\u0003\u0002.\t}\u0011\u0002\u0002B\u0011\u0003_\u0011a\u0001R#M\u000bR+\u0005fB\t\u0002B\u0005\u001d#QE\u0011\u0003\u0005O\tAgL>uK6\u0004H.\u0019;f\u0013\u0012TdF\u000b*fY\u0016\f7/Z.__5j&&`\u0018sKZL7/[8og>Z(/\u001a<jg&|g.\u00133~\u0003=!W\r\\3uKJ+g/[:j_:\u001cHCBA)\u0005[\u0011\u0019\u0004C\u0004\u0002`I\u0001\r!!\u0019)\u0011\t5\u0012\u0011PA$\u0003\u007fBCA!\f\u0002\u0004\"9!Q\u0007\nA\u0002\t]\u0012a\u0003:fm&\u001c\u0018n\u001c8JIN\u0004bA!\u000f\u0003D\u0005]VB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005\u0003\nAA[1wC&!!Q\tB\u001e\u0005\u0011a\u0015n\u001d;)\u0007I\u0011i\u0002K\u0004\u0013\u0003\u0003\n9%!*\u0002\u000f\r|W\u000e]1sKRA!q\nB+\u00057\u0012\t\b\u0005\u0003\u0002Z\nE\u0013\u0002\u0002B*\u00037\u0014!\u0004V3na2\fG/Z\"p]R,g\u000e^!oIB\u0013XM^5pkNDq!a\u0018\u0014\u0001\u0004\t\t\u0007\u000b\u0005\u0003V\u0005e\u0014qIA@Q\u0011\u0011)&a!\t\u000f\u0005U6\u00031\u0001\u00028\"B!1\fB0\u0003\u000f\u0012)\u0007\u0005\u0003\u0002.\t\u0005\u0014\u0002\u0002B2\u0003_\u0011A\u0002R3gCVdGOV1mk\u0016\f#Aa\u001a\u0002\u0003AB\u0003Ba\u0017\u0003l\u0005\u001d\u0013q\u0018\t\u0005\u0003[\u0011i'\u0003\u0003\u0003p\u0005=\"AC)vKJL\b+\u0019:b[\"9!1O\nA\u0002\u0005]\u0016\u0001\u0004;p%\u00164\u0018n]5p]&#\u0007\u0006\u0003B9\u0005?\n9E!\u001a)\u0011\tE$1NA$\u0005s\n#Aa\u001d)\u0007M\tY\u0003K\u0004\u0014\u0003\u0003\n9Ea \"\u0005\t\u0005\u0015!J\u0018|i\u0016l\u0007\u000f\\1uK&#'H\f\u0016SK2,\u0017m]3\\=>jSLK?0G>l\u0007/\u0019:f\u0003Q9W\r\u001e*fg>dW\u000f^5p]\u000e{g\u000e^3yiR!!q\u0011BN!\u0011\u0011IIa&\u000e\u0005\t-%\u0002\u0002BG\u0005\u001f\u000bQb]3sS\u0006d\u0017N_1uS>t'\u0002\u0002BI\u0005'\u000b\u0001\u0002\u001d7v[\nLgn\u001a\u0006\u0004\u0005+k\u0012\u0001\u00033fa2|\u00170\u001b;\n\t\te%1\u0012\u0002\u0012%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$\bbBA0)\u0001\u0007\u0011\u0011M\u0001\u0011O\u0016$H+Z7qY\u0006$X-Q:Eg2$B!!\u0019\u0003\"\"9!1U\u000bA\u0002\t\u0015\u0016\u0001\u0003;f[Bd\u0017\r^3\u0011\t\t\u001d&1V\u0007\u0003\u0005SS1!a\b\u001c\u0013\u0011\u0011iK!+\u0003\u000fI+G.Z1tK\":\u0001!!\u0011\u0002H\tE\u0016E\u0001BZ\u0003-yc/\u001a:tS>t\u0017N\\4)\u000f\u0001\u00119,a\u0012\u0003>B!\u0011Q\u0006B]\u0013\u0011\u0011Y,a\f\u0003\u0011A\u0013x\u000eZ;dKNd#Aa0\"\u0005\t\u0005\u0017\u0001E1qa2L7-\u0019;j_:|#n]8oQ\u001d\u0001!QYA$\u0005\u0017\u0004B!!\f\u0003H&!!\u0011ZA\u0018\u0005!\u0019uN\\:v[\u0016\u001cHF\u0001B`Q\r\u0001!q\u001a\t\u0005\u0005#\u00149.\u0004\u0002\u0003T*!!Q[A\u0005\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u00053\u0014\u0019N\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class TemplateVersioningResource
implements Logging {
    private final DslExporter dslExporter;
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateStorageService templateStorageService;
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ReleaseService releaseService;
    private final ConfigurationRepository configurationRepository;
    private final ScmTemplateStorageService templateStorageListener;
    private final ScmConnectorService scmConnectorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateVersioningResource templateVersioningResource = this;
        synchronized (templateVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/settings")
    public TemplateVersioningSettings getTemplateVersionoingSettings() {
        return (TemplateVersioningSettings)this.configurationRepository.read(TemplateVersioningSettings$.MODULE$.TEMPLATE_VERSIONING_ID());
    }

    @GET
    @Path(value="{templateId:.*Release[^/-]*}/connectionInfo")
    public Response connectionInfo(@PathParam(value="templateId") @IdParam String templateId) {
        String folderId = Ids.findFolderId((String)templateId);
        ScmConnectorConfig scmConfiguration = this.scmConnectorService.findScmConnectorConfig(folderId);
        return Response.ok((Object)scmConfiguration).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response getRevisions(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkView(templateId);
        List<TemplateRevision> templateRevisions = this.templateRevisionRepository.find(templateId, new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        GenericEntity<List<TemplateRevision>> entity = new GenericEntity<List<TemplateRevision>>(null, templateRevisions){};
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/content")
    public Response getRevisionContent(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkView(templateId);
        Release template = this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        return Response.ok((Object)this.getTemplateAsDsl(template), (String)"text/plain").build();
    }

    @POST
    @Path(value="/{templateId:.*Release[^/-]*}/versions")
    public Response createVersion(@PathParam(value="templateId") @IdParam String templateId, VersionView versionView) {
        Checks.checkArgument((boolean)this.releaseService.isTemplate(templateId), (String)"Snapshots can only be created for templates", (Object[])new Object[0]);
        this.permissionChecker.checkEdit(templateId);
        String user = Permissions.getAuthenticatedUserName();
        Try result = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.templateStorageListener.createNewVersion(templateId, versionView.name(), versionView.description(), user)).map((Function1 & Serializable)tagName -> {
            Try r = (Try)$this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.NewTemplateVersion((String)tagName, versionView.description(), user));
            return new Tuple2(tagName, (Object)r);
        }).map((Function1 & Serializable)x$1 -> {
            Try r;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && (r = (Try)tuple2._2()) != null) {
                Try try_ = r;
                return try_;
            }
            throw new MatchError((Object)tuple2);
        });
        return Response.ok((Object)result.fold((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ScmException) {
                ScmException scmException = (ScmException)throwable;
                String msg = scmException.msg();
                int statusCode = scmException.statusCode();
                this.logger().warn((Function0 & Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable)() -> scmException);
                return new CreateVersionResponse(false, msg, statusCode);
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().warn((Function0 & Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable)() -> throwable2);
                return new CreateVersionResponse(false, throwable2.getMessage(), 500);
            }
            throw new MatchError((Object)throwable);
        }, (Function1 & Serializable)id -> new CreateVersionResponse(true, id.toString(), CreateVersionResponse$.MODULE$.$lessinit$greater$default$3()))).build();
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/restore")
    public Response restoreRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, templateId);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.RestoreRevision(revisionId));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}")
    public Response deleteRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevision(templateId, revisionId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response deleteRevisions(@PathParam(value="templateId") @IdParam String templateId, List<Object> revisionIds) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevisions(templateId, (Seq<Object>)CollectionConverters$.MODULE$.ListHasAsScala(revisionIds).asScala().toSeq());
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/compare")
    public TemplateContentAndPrevious compare(@PathParam(value="templateId") @IdParam String templateId, @DefaultValue(value="0") @QueryParam(value="revisionId") int revisionId, @DefaultValue(value="0") @QueryParam(value="toRevisionId") int toRevisionId) {
        this.permissionChecker.checkView(templateId);
        Release revision = revisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        Release toRevision = toRevisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(toRevisionId, this.getResolutionContext(templateId));
        return new TemplateContentAndPrevious(this.getTemplateAsDsl(revision), this.getTemplateAsDsl(toRevision));
    }

    private ResolutionContext getResolutionContext(String templateId) {
        if (Ids.isInFolder((String)templateId)) {
            return ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId));
        }
        return ResolutionContext$.MODULE$.GLOBAL();
    }

    private String getTemplateAsDsl(Release template) {
        return this.dslExporter.exportTemplate(template, this.dslExporter.exportTemplate$default$2());
    }

    @Autowired
    public TemplateVersioningResource(DslExporter dslExporter, TemplateRevisionRepository templateRevisionRepository, TemplateStorageService templateStorageService, ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ReleaseService releaseService, ConfigurationRepository configurationRepository, ScmTemplateStorageService templateStorageListener, ScmConnectorService scmConnectorService) {
        this.dslExporter = dslExporter;
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateStorageService = templateStorageService;
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.releaseService = releaseService;
        this.configurationRepository = configurationRepository;
        this.templateStorageListener = templateStorageListener;
        this.scmConnectorService = scmConnectorService;
        Logging.$init$((Logging)this);
    }
}

