/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.typed;

import com.typesafe.config.Config;
import java.time.Duration;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.singleton.ClusterSingletonManagerSettings;
import org.apache.pekko.cluster.singleton.ClusterSingletonProxySettings;
import org.apache.pekko.cluster.typed.Cluster;
import org.apache.pekko.cluster.typed.ClusterSingletonSettings$;
import org.apache.pekko.coordination.lease.LeaseUsageSettings;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\tUt!B\u0017/\u0011\u0003Id!B\u001e/\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031\u0005b\u0002B&\u0003\u0011\u0005!Q\n\u0005\b\u00057\nA\u0011\u0001B/\r\u0011YdF\u0001%\t\u0011%3!Q1A\u0005\u0002)C\u0001\"\u0017\u0004\u0003\u0002\u0003\u0006Ia\u0013\u0005\t5\u001a\u0011)\u0019!C\u00017\"A\u0011N\u0002B\u0001B\u0003%A\f\u0003\u0005k\r\t\u0015\r\u0011\"\u0001l\u0011!!hA!A!\u0002\u0013a\u0007\u0002C;\u0007\u0005\u000b\u0007I\u0011A6\t\u0011Y4!\u0011!Q\u0001\n1D\u0001b\u001e\u0004\u0003\u0006\u0004%\ta\u001b\u0005\tq\u001a\u0011\t\u0011)A\u0005Y\"A\u0011P\u0002BC\u0002\u0013\u0005!\u0010\u0003\u0005\u007f\r\t\u0005\t\u0015!\u0003|\u0011%yhA!b\u0001\n\u0003\t\t\u0001\u0003\u0006\u0002\u0016\u0019\u0011\t\u0011)A\u0005\u0003\u0007Aaa\u0011\u0004\u0005\u0002\u0005]\u0001BB\"\u0007\t\u0003\t9\u0003C\u0004\u0002J\u0019!\t!a\u0013\t\u000f\u0005=c\u0001\"\u0001\u0002R!9\u00111\u000b\u0004\u0005\u0002\u0005U\u0003bBA-\r\u0011\u0005\u0011\u0011\u000b\u0005\b\u000372A\u0011AA/\u0011\u001d\tYF\u0002C\u0001\u0003CBq!!\u001e\u0007\t\u0003\t9\bC\u0004\u0002v\u0019!\t!a\u001f\t\u000f\u0005}d\u0001\"\u0001\u0002\u0002\"9\u0011Q\u0011\u0004\u0005\u0002\u0005\u001d\u0005bBAF\r\u0011%\u0011Q\u0012\u0005\n\u0003;3\u0011\u0013!C\u0005\u0003?C\u0011\"!.\u0007#\u0003%I!a.\t\u0013\u0005mf!%A\u0005\n\u0005u\u0006\"CAa\rE\u0005I\u0011BA_\u0011%\t\u0019MBI\u0001\n\u0013\ti\fC\u0005\u0002F\u001a\t\n\u0011\"\u0003\u0002H\"I\u00111\u001a\u0004\u0012\u0002\u0013%\u0011Q\u001a\u0005\t\u0003#4A\u0011\u0001\u001a\u0002T\"A\u0011\u0011\u001f\u0004\u0005\u0002I\n\u0019\u0010\u0003\u0005\u0002\u0000\u001a!\tA\rB\u0001\u0011\u001d\u0011\u0019B\u0002C!\u0005+\t\u0001d\u00117vgR,'oU5oO2,Go\u001c8TKR$\u0018N\\4t\u0015\ty\u0003'A\u0003usB,GM\u0003\u00022e\u000591\r\\;ti\u0016\u0014(BA\u001a5\u0003\u0015\u0001Xm[6p\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\u0004\u0001A\u0011!(A\u0007\u0002]\tA2\t\\;ti\u0016\u00148+\u001b8hY\u0016$xN\\*fiRLgnZ:\u0014\u0005\u0005i\u0004C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002s\u0005)\u0011\r\u001d9msR\u0019qI!\t\u0011\u0005i21C\u0001\u0004>\u0003\u0011\u0011x\u000e\\3\u0016\u0003-\u00032A\u0010'O\u0013\tiuH\u0001\u0004PaRLwN\u001c\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005E{T\"\u0001*\u000b\u0005MC\u0014A\u0002\u001fs_>$h(\u0003\u0002V\u007f\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)v(A\u0003s_2,\u0007%\u0001\u0006eCR\f7)\u001a8uKJ,\u0012\u0001\u0018\t\u0004}1k\u0006C\u00010g\u001d\tyFM\u0004\u0002aG:\u0011\u0011MY\u0007\u0002i%\u00111\u0007N\u0005\u0003cIJ!!\u001a\u0019\u0002\u001f\rcWo\u001d;feN+G\u000f^5oONL!a\u001a5\u0003\u0015\u0011\u000bG/Y\"f]R,'O\u0003\u0002fa\u0005YA-\u0019;b\u0007\u0016tG/\u001a:!\u0003}\u0019\u0018N\\4mKR|g.\u00133f]RLg-[2bi&|g.\u00138uKJ4\u0018\r\\\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0011oP\u0001\u000bG>t7-\u001e:sK:$\u0018BA:o\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0001e]5oO2,Go\u001c8JI\u0016tG/\u001b4jG\u0006$\u0018n\u001c8J]R,'O^1mA\u0005i!/Z7pm\u0006dW*\u0019:hS:\faB]3n_Z\fG.T1sO&t\u0007%A\u000biC:$wJ^3s%\u0016$(/_%oi\u0016\u0014h/\u00197\u0002-!\fg\u000eZ(wKJ\u0014V\r\u001e:z\u0013:$XM\u001d<bY\u0002\n!BY;gM\u0016\u00148+\u001b>f+\u0005Y\bC\u0001 }\u0013\tixHA\u0002J]R\f1BY;gM\u0016\u00148+\u001b>fA\u0005iA.Z1tKN+G\u000f^5oON,\"!a\u0001\u0011\tyb\u0015Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0015aW-Y:f\u0015\r\tyAM\u0001\rG>|'\u000fZ5oCRLwN\\\u0005\u0005\u0003'\tIA\u0001\nMK\u0006\u001cX-V:bO\u0016\u001cV\r\u001e;j]\u001e\u001c\u0018A\u00047fCN,7+\u001a;uS:<7\u000f\t\u000b\u0010\u000f\u0006e\u00111DA\u000f\u0003?\t\t#a\t\u0002&!)\u0011*\u0006a\u0001\u0017\")!,\u0006a\u00019\")!.\u0006a\u0001Y\")Q/\u0006a\u0001Y\")q/\u0006a\u0001Y\")\u00110\u0006a\u0001w\"1q0\u0006a\u0001\u0003\u0007!RbRA\u0015\u0003W\ti#a\f\u00022\u0005M\u0002\"B%\u0017\u0001\u0004Y\u0005\"\u0002.\u0017\u0001\u0004a\u0006\"\u00026\u0017\u0001\u0004a\u0007\"B;\u0017\u0001\u0004a\u0007\"B<\u0017\u0001\u0004a\u0007\"B=\u0017\u0001\u0004Y\bf\u0003\f\u00028\u0005u\u0012qHA\"\u0003\u000b\u00022APA\u001d\u0013\r\tYd\u0010\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0003\u0003\u0003\n!%V:fA\r|gn\u001d;sk\u000e$xN\u001d\u0011xSRD\u0007\u0005\\3bg\u0016\u001cV\r\u001e;j]\u001e\u001c\u0018!B:j]\u000e,\u0017EAA$\u0003-\t5n[1!e92d&M\u001b\u0002\u0011]LG\u000f\u001b*pY\u0016$2aRA'\u0011\u0015Iu\u00031\u0001O\u0003)9\u0018\u000e\u001e5O_J{G.\u001a\u000b\u0002\u000f\u0006qq/\u001b;i\t\u0006$\u0018mQ3oi\u0016\u0014HcA$\u0002X!)!,\u0007a\u0001;\u0006\u0001r/\u001b;i\u001d>$\u0015\r^1DK:$XM]\u0001\u0012o&$\bNU3n_Z\fG.T1sO&tGcA$\u0002`!)Qo\u0007a\u0001YR\u0019q)a\u0019\t\rUd\u0002\u0019AA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nA\u0001^5nK*\u0011\u0011qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002t\u0005%$\u0001\u0003#ve\u0006$\u0018n\u001c8\u00023]LG\u000f\u001b%b]\u0012|g/\u001a:SKR\u0014\u00180\u00138uKJ4\u0018\r\u001c\u000b\u0004\u000f\u0006e\u0004\"B<\u001e\u0001\u0004aGcA$\u0002~!1qO\ba\u0001\u0003K\nab^5uQ\n+hMZ3s'&TX\rF\u0002H\u0003\u0007CQ!_\u0010A\u0002m\f\u0011c^5uQ2+\u0017m]3TKR$\u0018N\\4t)\r9\u0015\u0011\u0012\u0005\u0007\u007f\u0002\u0002\r!!\u0002\u0002\t\r|\u0007/\u001f\u000b\u0010\u000f\u0006=\u0015\u0011SAJ\u0003+\u000b9*!'\u0002\u001c\"9\u0011*\tI\u0001\u0002\u0004Y\u0005b\u0002.\"!\u0003\u0005\r\u0001\u0018\u0005\bU\u0006\u0002\n\u00111\u0001m\u0011\u001d)\u0018\u0005%AA\u00021Dqa^\u0011\u0011\u0002\u0003\u0007A\u000eC\u0004zCA\u0005\t\u0019A>\t\u0011}\f\u0003\u0013!a\u0001\u0003\u0007\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\"*\u001a1*a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,@\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002:*\u001aA,a)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0018\u0016\u0004Y\u0006\r\u0016AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"!!3+\u0007m\f\u0019+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0005='\u0006BA\u0002\u0003G\u000b\u0011\u0003^8NC:\fw-\u001a:TKR$\u0018N\\4t)\u0011\t).!9\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a71\u0003%\u0019\u0018N\\4mKR|g.\u0003\u0003\u0002`\u0006e'aH\"mkN$XM]*j]\u001edW\r^8o\u001b\u0006t\u0017mZ3s'\u0016$H/\u001b8hg\"1\u00111]\u0015A\u00029\u000bQb]5oO2,Go\u001c8OC6,\u0007fA\u0015\u0002hB!\u0011\u0011^Aw\u001b\t\tYOC\u0002\u00020JJA!a<\u0002l\nY\u0011J\u001c;fe:\fG.\u00119j\u0003=!x\u000e\u0015:pqf\u001cV\r\u001e;j]\u001e\u001cH\u0003BA{\u0003w\u0004B!a6\u0002x&!\u0011\u0011`Am\u0005u\u0019E.^:uKJ\u001c\u0016N\\4mKR|g\u000e\u0015:pqf\u001cV\r\u001e;j]\u001e\u001c\bBBArU\u0001\u0007a\nK\u0002+\u0003O\f\u0001c\u001d5pk2$'+\u001e8NC:\fw-\u001a:\u0015\t\t\r!\u0011\u0002\t\u0004}\t\u0015\u0011b\u0001B\u0004\u007f\t9!i\\8mK\u0006t\u0007BB\u0019,\u0001\u0004\u0011Y\u0001E\u0002;\u0005\u001bI1Aa\u0004/\u0005\u001d\u0019E.^:uKJD3aKAt\u0003!!xn\u0015;sS:<GC\u0001B\f!\u0011\u0011IBa\b\u000e\u0005\tm!\u0002\u0002B\u000f\u0003[\nA\u0001\\1oO&\u0019qKa\u0007\t\u000f\t\r2\u00011\u0001\u0003&\u000511/_:uK6\u0004DAa\n\u0003:A1!\u0011\u0006B\u0019\u0005ki!Aa\u000b\u000b\u0007=\u0012iCC\u0002\u00030I\nQ!Y2u_JLAAa\r\u0003,\tY\u0011i\u0019;peNK8\u000f^3n!\u0011\u00119D!\u000f\r\u0001\u0011a!1\bB\u0011\u0003\u0003\u0005\tQ!\u0001\u0003>\t\u0019q\fJ\u0019\u0012\t\t}\"Q\t\t\u0004}\t\u0005\u0013b\u0001B\"\u007f\t9aj\u001c;iS:<\u0007c\u0001 \u0003H%\u0019!\u0011J \u0003\u0007\u0005s\u00170\u0001\u0004de\u0016\fG/\u001a\u000b\u0004\u000f\n=\u0003b\u0002B\u0012\t\u0001\u0007!\u0011\u000b\u0019\u0005\u0005'\u00129\u0006\u0005\u0004\u0003*\tE\"Q\u000b\t\u0005\u0005o\u00119\u0006\u0002\u0007\u0003Z\t=\u0013\u0011!A\u0001\u0006\u0003\u0011iDA\u0002`II\n!B\u001a:p[\u000e{gNZ5h)\r9%q\f\u0005\b\u0005C*\u0001\u0019\u0001B2\u0003\u0019\u0019wN\u001c4jOB!!Q\rB9\u001b\t\u00119G\u0003\u0003\u0003b\t%$\u0002\u0002B6\u0005[\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0005_\n1aY8n\u0013\u0011\u0011\u0019Ha\u001a\u0003\r\r{gNZ5h\u0001")
public final class ClusterSingletonSettings {
    private final Option<String> role;
    private final Option<String> dataCenter;
    private final FiniteDuration singletonIdentificationInterval;
    private final FiniteDuration removalMargin;
    private final FiniteDuration handOverRetryInterval;
    private final int bufferSize;
    private final Option<LeaseUsageSettings> leaseSettings;

    public static ClusterSingletonSettings fromConfig(Config config) {
        return ClusterSingletonSettings$.MODULE$.fromConfig(config);
    }

    public static ClusterSingletonSettings create(ActorSystem<?> system) {
        return ClusterSingletonSettings$.MODULE$.create(system);
    }

    public static ClusterSingletonSettings apply(ActorSystem<?> system) {
        return ClusterSingletonSettings$.MODULE$.apply(system);
    }

    public Option<String> role() {
        return this.role;
    }

    public Option<String> dataCenter() {
        return this.dataCenter;
    }

    public FiniteDuration singletonIdentificationInterval() {
        return this.singletonIdentificationInterval;
    }

    public FiniteDuration removalMargin() {
        return this.removalMargin;
    }

    public FiniteDuration handOverRetryInterval() {
        return this.handOverRetryInterval;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Option<LeaseUsageSettings> leaseSettings() {
        return this.leaseSettings;
    }

    public ClusterSingletonSettings withRole(String role) {
        return this.copy((Option<String>)new Some((Object)role), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public ClusterSingletonSettings withNoRole() {
        return this.copy((Option<String>)None$.MODULE$, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public ClusterSingletonSettings withDataCenter(String dataCenter) {
        Some x$1 = new Some((Object)dataCenter);
        Option<String> x$2 = this.copy$default$1();
        FiniteDuration x$3 = this.copy$default$3();
        FiniteDuration x$4 = this.copy$default$4();
        FiniteDuration x$5 = this.copy$default$5();
        int x$6 = this.copy$default$6();
        Option<LeaseUsageSettings> x$7 = this.copy$default$7();
        return this.copy(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7);
    }

    public ClusterSingletonSettings withNoDataCenter() {
        None$ x$1 = None$.MODULE$;
        Option<String> x$2 = this.copy$default$1();
        FiniteDuration x$3 = this.copy$default$3();
        FiniteDuration x$4 = this.copy$default$4();
        FiniteDuration x$5 = this.copy$default$5();
        int x$6 = this.copy$default$6();
        Option<LeaseUsageSettings> x$7 = this.copy$default$7();
        return this.copy(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7);
    }

    public ClusterSingletonSettings withRemovalMargin(FiniteDuration removalMargin) {
        FiniteDuration x$1 = removalMargin;
        Option<String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        FiniteDuration x$4 = this.copy$default$3();
        FiniteDuration x$5 = this.copy$default$5();
        int x$6 = this.copy$default$6();
        Option<LeaseUsageSettings> x$7 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7);
    }

    public ClusterSingletonSettings withRemovalMargin(Duration removalMargin) {
        return this.withRemovalMargin(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(removalMargin)));
    }

    public ClusterSingletonSettings withHandoverRetryInterval(FiniteDuration handOverRetryInterval) {
        FiniteDuration x$1 = handOverRetryInterval;
        Option<String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        FiniteDuration x$4 = this.copy$default$3();
        FiniteDuration x$5 = this.copy$default$4();
        int x$6 = this.copy$default$6();
        Option<LeaseUsageSettings> x$7 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7);
    }

    public ClusterSingletonSettings withHandoverRetryInterval(Duration handOverRetryInterval) {
        return this.withHandoverRetryInterval(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(handOverRetryInterval)));
    }

    public ClusterSingletonSettings withBufferSize(int bufferSize) {
        int x$1 = bufferSize;
        Option<String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        FiniteDuration x$4 = this.copy$default$3();
        FiniteDuration x$5 = this.copy$default$4();
        FiniteDuration x$6 = this.copy$default$5();
        Option<LeaseUsageSettings> x$7 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7);
    }

    public ClusterSingletonSettings withLeaseSettings(LeaseUsageSettings leaseSettings) {
        Option x$1 = Option$.MODULE$.apply((Object)leaseSettings);
        Option<String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$2();
        FiniteDuration x$4 = this.copy$default$3();
        FiniteDuration x$5 = this.copy$default$4();
        FiniteDuration x$6 = this.copy$default$5();
        int x$7 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option<LeaseUsageSettings>)x$1);
    }

    private ClusterSingletonSettings copy(Option<String> role, Option<String> dataCenter, FiniteDuration singletonIdentificationInterval, FiniteDuration removalMargin, FiniteDuration handOverRetryInterval, int bufferSize, Option<LeaseUsageSettings> leaseSettings) {
        return new ClusterSingletonSettings(role, dataCenter, singletonIdentificationInterval, removalMargin, handOverRetryInterval, bufferSize, leaseSettings);
    }

    private Option<String> copy$default$1() {
        return this.role();
    }

    private Option<String> copy$default$2() {
        return this.dataCenter();
    }

    private FiniteDuration copy$default$3() {
        return this.singletonIdentificationInterval();
    }

    private FiniteDuration copy$default$4() {
        return this.removalMargin();
    }

    private FiniteDuration copy$default$5() {
        return this.handOverRetryInterval();
    }

    private int copy$default$6() {
        return this.bufferSize();
    }

    private Option<LeaseUsageSettings> copy$default$7() {
        return this.leaseSettings();
    }

    @InternalApi
    public ClusterSingletonManagerSettings toManagerSettings(String singletonName) {
        return new ClusterSingletonManagerSettings(singletonName, this.role(), this.removalMargin(), this.handOverRetryInterval(), this.leaseSettings());
    }

    @InternalApi
    public ClusterSingletonProxySettings toProxySettings(String singletonName) {
        return new ClusterSingletonProxySettings(singletonName, this.role(), this.singletonIdentificationInterval(), this.bufferSize()).withDataCenter(this.dataCenter());
    }

    @InternalApi
    public boolean shouldRunManager(Cluster cluster) {
        return !(!this.role().isEmpty() && !cluster.selfMember().roles().apply(this.role().get()) || !this.dataCenter().isEmpty() && !this.dataCenter().contains((Object)cluster.selfMember().dataCenter()));
    }

    public String toString() {
        return new StringBuilder(38).append("ClusterSingletonSettings(").append(this.role()).append(", ").append(this.dataCenter()).append(", ").append(this.singletonIdentificationInterval()).append(", ").append(this.removalMargin()).append(", ").append(this.handOverRetryInterval()).append(", ").append(this.bufferSize()).append(", ").append(this.leaseSettings()).append(")").toString();
    }

    public ClusterSingletonSettings(Option<String> role, Option<String> dataCenter, FiniteDuration singletonIdentificationInterval, FiniteDuration removalMargin, FiniteDuration handOverRetryInterval, int bufferSize, Option<LeaseUsageSettings> leaseSettings) {
        this.role = role;
        this.dataCenter = dataCenter;
        this.singletonIdentificationInterval = singletonIdentificationInterval;
        this.removalMargin = removalMargin;
        this.handOverRetryInterval = handOverRetryInterval;
        this.bufferSize = bufferSize;
        this.leaseSettings = leaseSettings;
    }

    public ClusterSingletonSettings(Option<String> role, Option<String> dataCenter, FiniteDuration singletonIdentificationInterval, FiniteDuration removalMargin, FiniteDuration handOverRetryInterval, int bufferSize) {
        this(role, dataCenter, singletonIdentificationInterval, removalMargin, handOverRetryInterval, bufferSize, (Option<LeaseUsageSettings>)None$.MODULE$);
    }
}

