/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UserInputTaskUsagePoint;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="User Input", versioned=false, description="Prompts users for information or decisions")
public class UserInputTask
extends Task {
    @Property(asContainment=false)
    protected List<Variable> variables = new ArrayList<Variable>();
    @Property(defaultValue="how-to/create-a-user-input-task.html", hidden=true, required=false)
    private String documentationPage;

    @Override
    public void applyDefaults() {
        this.description = "Please enter the required information below.";
    }

    @Override
    public List<Variable> getReferencedVariables() {
        ArrayList<Variable> referencedVariables = new ArrayList<Variable>(super.getReferencedVariables());
        this.variables.stream().filter(variable -> !referencedVariables.contains(variable)).forEach(referencedVariables::add);
        return referencedVariables;
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return this.variables;
    }

    @PublicApiMember
    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public Changes removeVariable(String variableId) {
        Changes changes = new Changes();
        this.variables.removeIf(variable -> variableId.equals(variable.getId()));
        changes.remove(variableId);
        changes.update((ConfigurationItem)this);
        return changes;
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.addAll(this.getVariables().stream().map(v -> new UserInputTaskUsagePoint(this, "variables", (Variable)v)).collect(Collectors.toList()));
        return usagePoints;
    }
}

