/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.TemporalType;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampaddFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;

    public TimestampaddFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super("timestampadd", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(3), FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.INTEGER, FunctionParameterType.TEMPORAL), StandardFunctionReturnTypeResolvers.useArgType(3), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.INTEGER, FunctionParameterType.TEMPORAL));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        DurationUnit field = (DurationUnit)arguments.get(0);
        Expression magnitude = (Expression)arguments.get(1);
        Expression to = (Expression)arguments.get(2);
        this.patternRenderer(field.getUnit(), magnitude, to).render(sqlAppender, arguments, walker);
    }

    PatternRenderer patternRenderer(TemporalUnit unit, Expression interval, Expression to) {
        TemporalType temporalType = TypeConfiguration.getSqlTemporalType(to.getExpressionType());
        IntervalType intervalType = TypeConfiguration.getSqlIntervalType(interval.getExpressionType().getSingleJdbcMapping());
        return new PatternRenderer(this.dialect.timestampaddPattern(unit, temporalType, intervalType));
    }

    public SelfRenderingFunctionSqlAstExpression expression(ReturnableType<?> impliedResultType, SqlAstNode ... sqlAstArguments) {
        Expression to = (Expression)sqlAstArguments[2];
        return new SelfRenderingFunctionSqlAstExpression(this.getName(), this, Arrays.asList(sqlAstArguments), impliedResultType != null ? impliedResultType : (ReturnableType)((Object)to.getExpressionType().getSingleJdbcMapping()), to.getExpressionType());
    }

    @Override
    public String getArgumentListSignature() {
        return "(TEMPORAL_UNIT field, INTEGER magnitude, TEMPORAL datetime)";
    }
}

