/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.applications.management.security;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.utils.FolderId;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u00153A!\u0002\u0004\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00038\u0001\u0011\u0005\u0001HA\u0012NC:\fw-\u001a3BaBd\u0017nY1uS>t\u0007+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u000b\u0005\u001dA\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005%Q\u0011AC7b]\u0006<W-\\3oi*\u00111\u0002D\u0001\rCB\u0004H.[2bi&|gn\u001d\u0006\u0003\u001b9\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005=\u0001\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\t\u0012aA2p[\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u0006Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t!\tab$D\u0001\u001e\u0015\t9A\"\u0003\u0002 ;\t\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0002\rqJg.\u001b;?)\t\u0011C\u0005\u0005\u0002$\u00015\ta\u0001C\u0003\u001b\u0005\u0001\u00071$A\u0011dQ\u0016\u001c7.T1oC\u001e,\u0017\t\u001d9QSB,G.\u001b8fgB+'/\\5tg&|g\u000e\u0006\u0002(UA\u0011Q\u0003K\u0005\u0003SY\u0011A!\u00168ji\")1f\u0001a\u0001Y\u0005Aam\u001c7eKJLE\r\u0005\u0002.i9\u0011aF\r\t\u0003_Yi\u0011\u0001\r\u0006\u0003cI\ta\u0001\u0010:p_Rt\u0014BA\u001a\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M2\u0012aH2iK\u000e\\g+[3x\u0003B\u0004\b+\u001b9fY&tWm\u001d)fe6L7o]5p]R\u0011q%\u000f\u0005\u0006W\u0011\u0001\r\u0001\f\u0015\u0003\u0001m\u0002\"\u0001P\"\u000e\u0003uR!AP \u0002\u0015M$XM]3pif\u0004XM\u0003\u0002A\u0003\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001C\u0003\ry'oZ\u0005\u0003\tv\u0012\u0011bQ8na>tWM\u001c;")
public class ManagedApplicationPermissionChecker {
    private final PermissionChecker permissions;

    public void checkManageAppPipelinesPermission(String folderId) {
        if (!this.permissions.isCurrentUserAdmin() && !this.permissions.hasPermission(XLReleasePermissions.EDIT_APP_PIPELINES, new FolderId(folderId).absolute())) {
            throw PermissionDeniedException.withMessage((String)("You do not have " + XLReleasePermissions.EDIT_APP_PIPELINES + " permission on " + folderId));
        }
    }

    public void checkViewAppPipelinesPermission(String folderId) {
        if (!this.permissions.isCurrentUserAdmin() && !this.permissions.hasPermission(XLReleasePermissions.VIEW_APP_PIPELINES, new FolderId(folderId).absolute())) {
            throw PermissionDeniedException.withMessage((String)("You do not have " + XLReleasePermissions.VIEW_APP_PIPELINES + " permission on " + folderId));
        }
    }

    public ManagedApplicationPermissionChecker(PermissionChecker permissions) {
        this.permissions = permissions;
    }
}

