import React, { useEffect } from 'react';
import { ButtonWithLink, CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { ActiveReleaseTile } from './active-release-tile.component';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getReleaseTileState, releaseTile } from './ducks/release-tile.reducer';
import { ActiveTileSkeleton } from '../../CommonCardTile/active-tile.skeleton';

const { loadTopReleases } = releaseTile.actions;

const releasesImgSrc = 'static/24.3.0-beta.4/styles/img/timeline_monochromatic.svg';

export interface ReleaseTileProps {
    description: string;
    title: string;
}

export const ReleaseTileComponent = ({ description, title }: ReleaseTileProps) => {
    const dispatch = useAppDispatch();
    const { isLoading, topReleases } = useAppSelector(getReleaseTileState);

    useEffect(() => {
        dispatch(loadTopReleases());
    }, []);

    const handleViewReleasesClick = () => {
        window.location.href = '#/releases';
    };

    const handleStartReleaseClick = () => {
        window.location.href = '#/releases/create?fromHome=true';
    };

    const primaryButton: ButtonWithLink = {
        buttonCaption: 'View releases',
        onClick: handleViewReleasesClick,
        buttonType: 'text',
    };

    const secondaryButton: ButtonWithLink = {
        buttonCaption: 'Start release',
        onClick: handleStartReleaseClick,
        buttonType: 'outlined',
    };

    const renderTile = () =>
        topReleases.length > 0 ? (
            <ActiveReleaseTile primaryButton={primaryButton} releases={topReleases} secondaryButton={secondaryButton} title={title} />
        ) : (
            <CommonCardTileComponent
                description={description}
                imageLink={releasesImgSrc}
                isMarkdown={true}
                primaryButton={primaryButton}
                secondaryButton={secondaryButton}
                title={title}
            />
        );

    return isLoading ? <ActiveTileSkeleton /> : renderTile();
};
