/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.ColumnResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.ResultMementoBasic;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValuedConverted;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValuedStandard;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class ResultMementoBasicStandard
implements ResultMementoBasic {
    public final String explicitColumnName;
    private final ResultBuilderBasicValued builder;

    public ResultMementoBasicStandard(ColumnResult definition, ResultSetMappingResolutionContext context) {
        this.explicitColumnName = definition.name();
        SessionFactoryImplementor sessionFactory = context.getSessionFactory();
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        Class definedType = definition.type();
        if (Void.TYPE == definedType) {
            this.builder = new CompleteResultBuilderBasicValuedStandard(this.explicitColumnName, null, null);
        } else if (AttributeConverter.class.isAssignableFrom(definedType)) {
            Class converterClass = definedType;
            ManagedBean converterBean = sessionFactory.getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(converterClass);
            JavaType converterJtd = typeConfiguration.getJavaTypeRegistry().getDescriptor(converterClass);
            ParameterizedType parameterizedType = ConverterHelper.extractAttributeConverterParameterizedType(converterBean.getBeanClass());
            this.builder = new CompleteResultBuilderBasicValuedConverted(this.explicitColumnName, converterBean, converterJtd, this.determineDomainJavaType(parameterizedType, typeConfiguration.getJavaTypeRegistry()), this.resolveUnderlyingMapping(parameterizedType, typeConfiguration));
        } else {
            JavaType<Object> explicitJavaType;
            CustomType explicitType;
            CustomType registeredBasicType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(definition.type().getName());
            if (registeredBasicType != null) {
                explicitType = registeredBasicType;
                explicitJavaType = registeredBasicType.getJavaTypeDescriptor();
            } else {
                JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
                JavaType registeredJtd = jtdRegistry.getDescriptor(definition.type());
                ManagedBeanRegistry beanRegistry = sessionFactory.getServiceRegistry().getService(ManagedBeanRegistry.class);
                if (BasicType.class.isAssignableFrom(registeredJtd.getJavaTypeClass())) {
                    ManagedBean typeBean = beanRegistry.getBean(registeredJtd.getJavaTypeClass());
                    explicitType = (CustomType)typeBean.getBeanInstance();
                    explicitJavaType = explicitType.getJavaTypeDescriptor();
                } else if (UserType.class.isAssignableFrom(registeredJtd.getJavaTypeClass())) {
                    ManagedBean userTypeBean = beanRegistry.getBean(registeredJtd.getJavaTypeClass());
                    explicitType = new CustomType((UserType)userTypeBean.getBeanInstance(), typeConfiguration);
                    explicitJavaType = explicitType.getJavaTypeDescriptor();
                } else {
                    explicitType = null;
                    explicitJavaType = jtdRegistry.getDescriptor(definition.type());
                }
            }
            this.builder = new CompleteResultBuilderBasicValuedStandard(this.explicitColumnName, explicitType, explicitJavaType);
        }
    }

    private BasicJavaType<?> determineDomainJavaType(ParameterizedType parameterizedType, JavaTypeRegistry jtdRegistry) {
        Type[] typeParameters = parameterizedType.getActualTypeArguments();
        Type domainTypeType = typeParameters[0];
        Class domainClass = (Class)domainTypeType;
        return (BasicJavaType)jtdRegistry.getDescriptor(domainClass);
    }

    private BasicValuedMapping resolveUnderlyingMapping(ParameterizedType parameterizedType, TypeConfiguration typeConfiguration) {
        Type[] typeParameters = parameterizedType.getActualTypeArguments();
        return typeConfiguration.standardBasicTypeForJavaType((Class)typeParameters[1]);
    }

    public ResultMementoBasicStandard(String explicitColumnName, BasicType<?> explicitType, ResultSetMappingResolutionContext context) {
        this.explicitColumnName = explicitColumnName;
        this.builder = new CompleteResultBuilderBasicValuedStandard(explicitColumnName, explicitType, explicitType != null ? explicitType.getJavaTypeDescriptor() : null);
    }

    @Override
    public ResultBuilderBasicValued resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        return this.builder;
    }
}

