/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class Index
implements Exportable,
Serializable {
    private Identifier name;
    private Table table;
    private final List<Column> columns = new ArrayList<Column>();
    private final Map<Column, String> columnOrderMap = new HashMap<Column, String>();

    public static String buildSqlDropIndexString(String name, String tableName) {
        return "drop index " + StringHelper.qualify(tableName, name);
    }

    public static String buildSqlCreateIndexString(Dialect dialect, String name, String tableName, List<Column> columns, Map<Column, String> columnOrderMap, boolean unique) {
        StringBuilder statement = new StringBuilder(dialect.getCreateIndexString(unique)).append(" ").append(dialect.qualifyIndexName() ? name : StringHelper.unqualify(name)).append(" on ").append(tableName).append(" (");
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                first = false;
            } else {
                statement.append(", ");
            }
            statement.append(column.getQuotedName(dialect));
            if (!columnOrderMap.containsKey(column)) continue;
            statement.append(" ").append(columnOrderMap.get(column));
        }
        statement.append(")");
        statement.append(dialect.getCreateIndexTail(unique, columns));
        return statement.toString();
    }

    public static String buildSqlCreateIndexString(SqlStringGenerationContext context, String name, Table table, List<Column> columns, Map<Column, String> columnOrderMap, boolean unique, Metadata metadata) {
        return Index.buildSqlCreateIndexString(context.getDialect(), name, context.format(table.getQualifiedTableName()), columns, columnOrderMap, unique);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    @Deprecated
    public Iterator<Column> getColumnIterator() {
        return this.getColumns().iterator();
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public Map<Column, String> getColumnOrderMap() {
        return Collections.unmodifiableMap(this.columnOrderMap);
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumn(Column column, String order) {
        this.addColumn(column);
        if (StringHelper.isNotEmpty(order)) {
            this.columnOrderMap.put(column, order);
        }
    }

    public void addColumns(List<Column> extraColumns) {
        for (Column column : extraColumns) {
            this.addColumn(column);
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "IDX-" + this.getName());
    }
}

