/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.RemoteExecution;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.runner.impl.ContainerScriptException;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotely;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyActor;
import com.xebialabs.xlrelease.runner.impl.ExecuteRemotelyResponse;
import com.xebialabs.xlrelease.runner.impl.JobRunnerService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService;
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001B\u0007\u000f\u0001eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003;\u0001\u0011\u00051\b\u0003\u0005A\u0001!\u0015\r\u0011\"\u0003B\u0011\u0015i\u0005\u0001\"\u0003O\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u00151\b\u0001\"\u0011x\u0011\u00191\b\u0001\"\u0011\u0002:!9\u0011q\u000b\u0001\u0005B\u0005e\u0003bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003g\u0002A\u0011IA;\u0005]\u0011VO\u001c8feN\u001b'/\u001b9u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u0010!\u0005!\u0011.\u001c9m\u0015\t\t\"#\u0001\u0004sk:tWM\u001d\u0006\u0003'Q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0012\u000e\u00039I!a\t\b\u0003'I+hN\\3s'\u000e\u0014\u0018\u000e\u001d;TKJ4\u0018nY3\u0002\u001fM\u0004(/\u001b8h\u000bb$XM\\:j_:\u0004\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\rM\u0004(/\u001b8h\u0015\tQ3&A\u0003qK.\\wN\u0003\u0002-%\u000591/\u001e9q_J$\u0018B\u0001\u0018(\u0005=\u0019\u0006O]5oO\u0016CH/\u001a8tS>t\u0017!\u0003=me\u000e{gNZ5h!\t\tD'D\u00013\u0015\t\u0019$#\u0001\u0004d_:4\u0017nZ\u0005\u0003kI\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002!)|'MU;o]\u0016\u00148+\u001a:wS\u000e,\u0007CA\u00119\u0013\tIdB\u0001\tK_\n\u0014VO\u001c8feN+'O^5dK\u00061A(\u001b8jiz\"B\u0001P\u001f?\u007fA\u0011\u0011\u0005\u0001\u0005\u0006I\u0011\u0001\r!\n\u0005\u0006_\u0011\u0001\r\u0001\r\u0005\u0006m\u0011\u0001\raN\u0001\tC\u000e$xN\u001d*fMV\t!\t\u0005\u0002D\u00176\tAI\u0003\u0002F\r\u0006)\u0011m\u0019;pe*\u0011!f\u0012\u0006\u0003\u0011&\u000ba!\u00199bG\",'\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\t\nA\u0011i\u0019;peJ+g-\u0001\u0007pE*,7\r^'baB,'/F\u0001P!\t\u0001v+D\u0001R\u0015\t\u00116+\u0001\u0005eCR\f'-\u001b8e\u0015\t!V+A\u0004kC\u000e\\7o\u001c8\u000b\u0005Y3\u0012!\u00034bgR,'\u000f_7m\u0013\tA\u0016K\u0001\u0007PE*,7\r^'baB,'/A\u0006bg.\fe\u000eZ!xC&$XCA._)\rav\r\u001d\t\u0003;zc\u0001\u0001B\u0003`\u000f\t\u0007\u0001MA\u0001U#\t\tG\r\u0005\u0002\u001cE&\u00111\r\b\u0002\b\u001d>$\b.\u001b8h!\tYR-\u0003\u0002g9\t\u0019\u0011I\\=\t\u000b!<\u0001\u0019A5\u0002\u0013)|'MU;o]\u0016\u0014\bC\u00016o\u001b\u0005Y'BA\tm\u0015\ti'#\u0001\u0004e_6\f\u0017N\\\u0005\u0003_.\u0014\u0011BS8c%Vtg.\u001a:\t\u000bE<\u0001\u0019\u0001:\u0002\u001fI,Wn\u001c;f\u000bb,7-\u001e;j_:\u0004\"a\u001d;\u000e\u00031L!!\u001e7\u0003\u001fI+Wn\u001c;f\u000bb,7-\u001e;j_:\fQ\"\u001a=fGV$XmU2sSB$XC\u0001={)\u0019I80!\u0005\u0002&A\u0011QL\u001f\u0003\u0006?\"\u0011\r\u0001\u0019\u0005\u0006y\"\u0001\r!`\u0001\u0007g\u000e\u0014\u0018\u000e\u001d;\u0011\u0007y\fYAD\u0002\u0000\u0003\u000f\u00012!!\u0001\u001d\u001b\t\t\u0019AC\u0002\u0002\u0006a\ta\u0001\u0010:p_Rt\u0014bAA\u00059\u00051\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u0003\u001d\u0011\u001d\t\u0019\u0002\u0003a\u0001\u0003+\tq\"\u001b8qkR\u0004\u0016M]1nKR,'o\u001d\t\u0007\u0003/\t\t# \u000e\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tA!\u001e;jY*\u0011\u0011qD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002$\u0005e!aA'ba\"9\u0011q\u0005\u0005A\u0002\u0005%\u0012!\u0004;za\u0016\u0014VMZ3sK:\u001cW\rE\u0003\u0002,\u0005U\u00120\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\u0011!\u0018\u0010]3\u000b\u0007\u0005M2+\u0001\u0003d_J,\u0017\u0002BA\u001c\u0003[\u0011Q\u0002V=qKJ+g-\u001a:f]\u000e,W\u0003BA\u001e\u0003#\"b!!\u0010\u0002T\u0005U\u0003CBA \u0003\u0013\nyE\u0004\u0003\u0002B\u0005\u0015c\u0002BA\u0001\u0003\u0007J\u0011!H\u0005\u0004\u0003\u000fb\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\niE\u0001\u0004WK\u000e$xN\u001d\u0006\u0004\u0003\u000fb\u0002cA/\u0002R\u0011)q,\u0003b\u0001A\")A0\u0003a\u0001{\"9\u00111C\u0005A\u0002\u0005U\u0011AF3yK\u000e,H/Z*de&\u0004HOR8s\u001f\nTWm\u0019;\u0016\t\u0005m\u0013q\f\u000b\u0007\u0003;\n\t'a\u0019\u0011\u0007u\u000by\u0006B\u0003`\u0015\t\u0007\u0001\rC\u0003}\u0015\u0001\u0007Q\u0010C\u0004\u0002\u0014)\u0001\r!!\u0006\u0002\u001f\u0015DXmY;uKJ+Wn\u001c;fYf$b!!\u001b\u0002p\u0005E\u0004cA\u0011\u0002l%\u0019\u0011Q\u000e\b\u0003/\u0015CXmY;uKJ+Wn\u001c;fYf\u0014Vm\u001d9p]N,\u0007\"\u0002?\f\u0001\u0004i\bbBA\n\u0017\u0001\u0007\u0011QC\u0001\u000fg\u000e\u0014\u0018\u000e\u001d;Fq\u0016\u001cW\u000f^3e)\u0019\t9(! \u0002\u0002B\u00191$!\u001f\n\u0007\u0005mDD\u0001\u0003V]&$\bBBA@\u0019\u0001\u0007Q0A\ttGJL\u0007\u000f^#yK\u000e,H/[8o\u0013\u0012Dq!a!\r\u0001\u0004\t)\"A\u0004qCfdw.\u00193)\u0007\u0001\t9\t\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\u0015M$XM]3pif\u0004XMC\u0002\u0002\u0012&\u000bqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0003+\u000bYIA\u0004TKJ4\u0018nY3")
public class RunnerScriptServiceImpl
implements RunnerScriptService {
    private ActorRef actorRef;
    private final SpringExtension springExtension;
    private final XlrConfig xlrConfig;
    private final JobRunnerService jobRunnerService;
    private volatile boolean bitmap$0;

    private ActorRef actorRef$lzycompute() {
        RunnerScriptServiceImpl runnerScriptServiceImpl = this;
        synchronized (runnerScriptServiceImpl) {
            if (!this.bitmap$0) {
                this.actorRef = this.springExtension.actorOf(ExecuteRemotelyActor.class, this.springExtension.actorOf$default$2(), this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.actorRef;
    }

    private ActorRef actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    private <T> T askAndAwait(JobRunner jobRunner, RemoteExecution remoteExecution) {
        Object object;
        Timeout askTimeout = Timeout$.MODULE$.durationToTimeout(this.xlrConfig.timeouts().releaseActionResponse());
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.actorRef());
            ExecuteRemotely x$1 = new ExecuteRemotely(jobRunner, remoteExecution);
            Timeout x$2 = askTimeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)askTimeout.duration());
        }
        catch (Exception e) {
            throw new ContainerScriptException(e.getMessage());
        }
        return (T)object;
    }

    @Override
    public <T> T executeScript(String script, Map<String, Object> inputParameters, TypeReference<T> typeReference) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.objectMapper().readValue(this.objectMapper().writeValueAsString(commandResponse), typeReference));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> Vector<T> executeScript(String script, Map<String, Object> inputParameters) {
        Some some;
        Object commandResponse;
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some && (commandResponse = (some = (Some)option).value()) instanceof List) {
            List list = (List)commandResponse;
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)resultItem -> {
                String nodeString = this.objectMapper().writeValueAsString(resultItem);
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object result = success.value();
                    return result;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
                }
                throw new MatchError((Object)try_);
            })).toVector();
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    @Override
    public <T> T executeScriptForObject(String script, Map<String, Object> inputParameters) {
        scala.collection.immutable.Map scriptResponse = CollectionConverters$.MODULE$.MapHasAsScala(this.executeRemotely(script, inputParameters).payload()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = scriptResponse.get((Object)RunnerScriptService$.MODULE$.CommandResponseKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            Object commandResponse = some.value();
            String nodeString = this.objectMapper().writeValueAsString(commandResponse);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiSerializerHelper$.MODULE$.deserialize(nodeString, null, CiSerializerHelper$.MODULE$.newEncryptingConverter()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new ContainerScriptException("Error deserializing container " + script + " response: " + exception);
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option) && scriptResponse.contains((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())) {
            String error = (String)this.objectMapper().readValue(this.objectMapper().writeValueAsString(scriptResponse.apply((Object)RunnerScriptService$.MODULE$.ErrorMessageKey())), String.class);
            throw new ContainerScriptException("Container script " + script + " failed with error: " + error);
        }
        throw new ContainerScriptException("Failed to process container script " + script + " result");
    }

    private ExecuteRemotelyResponse executeRemotely(String script, Map<String, Object> inputParameters) {
        RemoteScriptExecution scriptTask = TaskBuilder.newRemoteExecution((String)script).withInputParameters(inputParameters).build();
        Option<JobRunner> option = this.jobRunnerService.findScriptExecutor();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new ContainerScriptException("Cannot find active remote runner for executing script '" + script + "'");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        JobRunner runner = (JobRunner)some.value();
        JobRunner runner2 = runner;
        return (ExecuteRemotelyResponse)this.askAndAwait(runner2, (RemoteExecution)scriptTask);
    }

    @Override
    public void scriptExecuted(String scriptExecutionId, Map<String, Object> payload) {
        ExecuteRemotelyResponse x$1 = new ExecuteRemotelyResponse(scriptExecutionId, payload);
        ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$1);
        this.actorRef().$bang((Object)x$1, x$2);
    }

    public RunnerScriptServiceImpl(SpringExtension springExtension, XlrConfig xlrConfig, JobRunnerService jobRunnerService) {
        this.springExtension = springExtension;
        this.xlrConfig = xlrConfig;
        this.jobRunnerService = jobRunnerService;
    }
}

