/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ApplicationSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tud\u0001\u0002\u0015*\u0001aB\u0001B\u0012\u0001\u0003\u0006\u0004%\u0019a\u0012\u0005\t)\u0002\u0011\t\u0011)A\u0005\u0011\"AQ\u000b\u0001BC\u0002\u0013\ra\u000b\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003X\u0011!y\u0007A!b\u0001\n\u0007\u0001\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0011a\u0004!Q1A\u0005\u0002eD\u0001B \u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\n\u007f\u0002\u0011)\u0019!C\u0001\u0003\u0003A!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0002\u0011)\tY\u0001\u0001BC\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005=\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003/B\u0001\"!\u001b\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003W\u0002!\u0019!C\u0005\u0003/B\u0001\"!\u001c\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003/B\u0001\"!\u001d\u0001A\u0003%\u0011\u0011\f\u0005\b\u0003g\u0002A\u0011AA;\u0011%\t\u0019\u000b\u0001b\u0001\n\u0013\t9\u0006\u0003\u0005\u0002&\u0002\u0001\u000b\u0011BA-\u0011%\t9\u000b\u0001b\u0001\n\u0013\t9\u0006\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BA-\u0011%\tY\u000b\u0001b\u0001\n\u0013\t9\u0006\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BA-\u0011\u001d\ty\u000b\u0001C\u0001\u0003cC\u0011\"a/\u0001\u0005\u0004%I!a\u0016\t\u0011\u0005u\u0006\u0001)A\u0005\u00033Bq!a0\u0001\t\u0003\t\t\rC\u0004\u0002T\u0002!\t!!6\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005oAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003T\u0001!IA!\u0016\t\u000f\tm\u0003\u0001\"\u0003\u0003^\t1\u0012\t\u001d9mS\u000e\fG/[8o!\u0016\u00148/[:uK:\u001cWM\u0003\u0002+W\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\taS&A\u0002tc2T!AL\u0018\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u00021c\u0005aQM\u001c<je>tW.\u001a8ug*\u0011!gM\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001N\u001b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u001c\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001It\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0001\u0012k\u0011!\u0011\u0006\u0003U\tS!\u0001L\"\u000b\u00059\n\u0014BA#B\u0005I\u0001VM]:jgR,gnY3TkB\u0004xN\u001d;\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003!\u0003\"!\u0013*\u000e\u0003)S!a\u0013'\u0002\t\r|'/\u001a\u0006\u0003\u001b:\u000bAA\u001b3cG*\u0011q\nU\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011+A\u0002pe\u001eL!a\u0015&\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003\u001d!\u0017.\u00197fGR,\u0012a\u0016\t\u00031.t!!\u00175\u000f\u0005i3gBA.e\u001d\ta6M\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001mN\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!\u0001N\u001b\n\u0005I\u001a\u0014BA32\u0003\t!'-\u0003\u0002-O*\u0011Q-M\u0005\u0003S*\f!bU9m\u0005VLG\u000eZ3s\u0015\tas-\u0003\u0002m[\n9A)[1mK\u000e$(BA5k\u0003!!\u0017.\u00197fGR\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003iF\nqa]3sm&\u001cW-\u0003\u0002wg\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003Y)gN^5s_:lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,W#\u0001>\u0011\u0005mdX\"A\u0015\n\u0005uL#AF#om&\u0014xN\\7f]R\u0004VM]:jgR,gnY3\u0002/\u0015tg/\u001b:p]6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\u0013!\u00054pY\u0012,'\u000fU3sg&\u001cH/\u001a8dKV\u0011\u00111\u0001\t\u0004\u0001\u0006\u0015\u0011bAA\u0004\u0003\n\tbi\u001c7eKJ\u0004VM]:jgR,gnY3\u0002%\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0015g\u0016\u001cWO]1cY\u0016\u0004VM]:jgR,gnY3\u0016\u0005\u0005=\u0001c\u0001!\u0002\u0012%\u0019\u00111C!\u0003)M+7-\u001e:bE2,\u0007+\u001a:tSN$XM\\2f\u0003U\u0019XmY;sC\ndW\rU3sg&\u001cH/\u001a8dK\u0002\na\u0001P5oSRtDCAA\u000e)9\ti\"a\b\u0002>\u0005\u0015\u0013qIA%\u0003\u0017\u0002\"a\u001f\u0001\t\u000b\u0019k\u00019\u0001%)\u0011\u0005}\u00111EA\u001c\u0003s\u0001B!!\n\u000245\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0006b]:|G/\u0019;j_:TA!!\f\u00020\u00059a-Y2u_JL(bAA\u0019\u001d\u0006)!-Z1og&!\u0011QGA\u0014\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-\t\u0002\u0002<\u0005I\u0002\u0010\u001c:SKB|7/\u001b;pefTEMY2UK6\u0004H.\u0019;f\u0011\u0015)V\u0002q\u0001XQ!\ti$a\t\u00028\u0005\u0005\u0013EAA\"\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000fC\u0003p\u001b\u0001\u000f\u0011\u000fC\u0003y\u001b\u0001\u0007!\u0010\u0003\u0004\u0000\u001b\u0001\u0007\u00111\u0001\u0005\b\u0003\u0017i\u0001\u0019AA\bQ\ri\u0011q\n\t\u0005\u0003K\t\t&\u0003\u0003\u0002T\u0005\u001d\"!C!vi><\u0018N]3e\u0003a\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u0003B\u0003F*S\"B)&{ejU\u000b\u0003\u00033\u0002B!a\u0017\u0002d9!\u0011QLA0!\tq6(C\u0002\u0002bm\na\u0001\u0015:fI\u00164\u0017\u0002BA3\u0003O\u0012aa\u0015;sS:<'bAA1w\u0005I2\u000bV'U?&s5+\u0012*U?\u0006\u0003\u0006\u000bT%D\u0003RKuJT*!\u0003\u0019\u001aF+\u0014+`\u000bbK5\u000bV*`\u0005f{F+\u0013+M\u000b~KuIT(S\u000b\u000e\u000b5+R0G\u001f2#UIU\u0001('RkEkX#Y\u0013N#6k\u0018\"Z?RKE\u000bT#`\u0013\u001esuJU#D\u0003N+uLR(M\t\u0016\u0013\u0006%\u0001\u0014T)6#v,\u0012-J'R\u001bvLQ-`)&#F*R0J\u000f:{%+R\"B'\u0016{v\tT(C\u00032\u000bqe\u0015+N)~+\u0005,S*U'~\u0013\u0015l\u0018+J)2+u,S$O\u001fJ+5)Q*F?\u001ecuJQ!MA\u00051\u0011N\\:feR$B!a\u001e\u0002\u0012B!\u0011\u0011PAF\u001d\u0011\tY(a\"\u000f\t\u0005u\u0014Q\u0011\b\u0005\u0003\u007f\n\u0019ID\u0002\\\u0003\u0003K!AL\u0019\n\u00051\u001a\u0015B\u0001\u0016C\u0013\r\tI)Q\u0001\u0005\u0007&LE-\u0003\u0003\u0002\u000e\u0006=%\u0001B\"j\u0013\u0012T1!!#B\u0011\u001d\t\u0019\n\u0006a\u0001\u0003+\u000b1\"\u00199qY&\u001c\u0017\r^5p]B!\u0011qSAP\u001b\t\tIJC\u00021\u00037S1!!(2\u0003\u0019!w.\\1j]&!\u0011\u0011UAM\u0005-\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u00021M#V\nV0V!\u0012\u000bE+R0B!Bc\u0015jQ!U\u0013>s5+A\rT)6#v,\u0016)E\u0003R+u,\u0011)Q\u0019&\u001b\u0015\tV%P\u001dN\u0003\u0013!K*U\u001bR{V\tW%T)N{\u0016IT(U\u0011\u0016\u0013v,\u0011)Q?^KE\u000bS0U\u0013RcUiX$M\u001f\n\u000bE*\u0001\u0016T)6#v,\u0012-J'R\u001bv,\u0011(P)\"+%kX!Q!~;\u0016\n\u0016%`)&#F*R0H\u0019>\u0013\u0015\t\u0014\u0011\u0002SM#V\nV0F1&\u001bFkU0B\u001d>#\u0006*\u0012*`\u0003B\u0003vlV%U\u0011~#\u0016\n\u0016'F?\u001a{E\nR#S\u0003)\u001aF+\u0014+`\u000bbK5\u000bV*`\u0003:{E\u000bS#S?\u0006\u0003\u0006kX,J)\"{F+\u0013+M\u000b~3u\n\u0014#F%\u0002\na!\u001e9eCR,G\u0003BAZ\u0003s\u00032AOA[\u0013\r\t9l\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019j\u0007a\u0001\u0003+\u000bad\u0015+N)~#U\tT#U\u000b~\u000b\u0005\u000b\u0015'J\u0007\u0006#\u0016j\u0014(T?\nKv,\u0013#\u0002?M#V\nV0E\u000b2+E+R0B!Bc\u0015jQ!U\u0013>s5k\u0018\"Z?&#\u0005%\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u0007\fy\r\u0005\u0004\u0002F\u0006-\u00171W\u0007\u0003\u0003\u000fT1!!3<\u0003\u0011)H/\u001b7\n\t\u00055\u0017q\u0019\u0002\u0004)JL\bbBAi=\u0001\u0007\u0011qO\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$B!a6\u0002^B)!(!7\u0002\u0016&\u0019\u00111\\\u001e\u0003\r=\u0003H/[8o\u0011\u001d\t\tn\ba\u0001\u0003o\n1BZ5oI\nKH+\u001b;mKR!\u0011q[Ar\u0011\u001d\t)\u000f\ta\u0001\u00033\nQ\u0001^5uY\u0016\f1BZ5oIVKGMQ=JIR!\u00111^A~!\u0015Q\u0014\u0011\\Aw!\u0011\ty/!>\u000f\t\u0005m\u0014\u0011_\u0005\u0004\u0003g\f\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003o\fIPA\u0003DSVKGMC\u0002\u0002t\u0006Cq!!5\"\u0001\u0004\t9(\u0001\u0007hKR,\u0016\u000eZ:Cs&#7\u000f\u0006\u0003\u0003\u0002\t\u001d\u0001\u0003CA.\u0005\u0007\t9(!<\n\t\t\u0015\u0011q\r\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u0005E\u0001\u0007!1B\u0001\u000fCB\u0004H.[2bi&|g.\u00133t!\u0019\u0011iA!\u0006\u0002x9!!q\u0002B\n\u001d\rq&\u0011C\u0005\u0002y%\u0019\u00111_\u001e\n\t\t]!\u0011\u0004\u0002\t\u0013R,'/\u00192mK*\u0019\u00111_\u001e\u0002\rM,\u0017M]2i)\u0011\u0011yB!\n\u0011\r\t5!\u0011EAK\u0013\u0011\u0011\u0019C!\u0007\u0003\u0007M+\u0017\u000fC\u0004\u0003(\r\u0002\rA!\u000b\u0002#M\fHnV5uQB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0003,\t=bbA-\u0003.%\u0019\u00111\u001f6\n\t\tE\"1\u0007\u0002\u0012'Fdw+\u001b;i!\u0006\u0014\u0018-\\3uKJ\u001c(bAAzU\u0006\u0011r-\u001a;F]ZL'o\u001c8nK:$X+\u001b3t)\u0011\u0011\tA!\u000f\t\u000f\u0005ME\u00051\u0001\u0002\u0016\u0006A\u0012N\\:feR\f\u0005\u000f\u001d+p\u000b:4(+\u001a4fe\u0016t7-Z:\u0015\r\t}\"Q\tB%!\rQ$\u0011I\u0005\u0004\u0005\u0007Z$\u0001B+oSRDqAa\u0012&\u0001\u0004\ti/\u0001\bbaBd\u0017nY1uS>tW+\u001b3\t\u000f\t-S\u00051\u0001\u0003N\u00059QM\u001c<VS\u0012\u001c\bCBA.\u0005\u001f\ni/\u0003\u0003\u0003R\u0005\u001d$aA*fi\u0006AR\u000f\u001d3bi\u0016\f\u0005\u000f\u001d+p\u000b:4(+\u001a4fe\u0016t7-Z:\u0015\r\t}\"q\u000bB-\u0011\u001d\t\u0019J\na\u0001\u0003+CqAa\u0012'\u0001\u0004\ti/\u0001\rtC:LG/\u001b>f\u0003B\u0004H.[2bi&|g.\u00138qkR$BAa\u0010\u0003`!9\u00111S\u0014A\u0002\u0005U\u0005f\u0001\u0001\u0003dA!!Q\rB6\u001b\t\u00119GC\u0002\u0003j9\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011iGa\u001a\u0003\u0015I+\u0007o\\:ji>\u0014\u0018\u0010K\u0002\u0001\u0005c\u0002BAa\u001d\u0003z5\u0011!Q\u000f\u0006\u0004\u0005oR\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:LAAa\u001f\u0003v\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class ApplicationPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentPersistence environmentPersistence;
    private final FolderPersistence folderPersistence;
    private final SecurablePersistence securablePersistence;
    private final String STMT_INSERT_APPLICATIONS;
    private final String STMT_EXISTS_BY_TITLE_IGNORECASE_FOLDER;
    private final String STMT_EXISTS_BY_TITLE_IGNORECASE_GLOBAL;
    private final String STMT_UPDATE_APPLICATIONS;
    private final String STMT_EXISTS_ANOTHER_APP_WITH_TITLE_GLOBAL;
    private final String STMT_EXISTS_ANOTHER_APP_WITH_TITLE_FOLDER;
    private final String STMT_DELETE_APPLICATIONS_BY_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, scala.collection.immutable.Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        ApplicationPersistence applicationPersistence = this;
        synchronized (applicationPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EnvironmentPersistence environmentPersistence() {
        return this.environmentPersistence;
    }

    public FolderPersistence folderPersistence() {
        return this.folderPersistence;
    }

    public SecurablePersistence securablePersistence() {
        return this.securablePersistence;
    }

    private String STMT_INSERT_APPLICATIONS() {
        return this.STMT_INSERT_APPLICATIONS;
    }

    private String STMT_EXISTS_BY_TITLE_IGNORECASE_FOLDER() {
        return this.STMT_EXISTS_BY_TITLE_IGNORECASE_FOLDER;
    }

    private String STMT_EXISTS_BY_TITLE_IGNORECASE_GLOBAL() {
        return this.STMT_EXISTS_BY_TITLE_IGNORECASE_GLOBAL;
    }

    public String insert(Application application) {
        this.sanitizeApplicationInput(application);
        boolean exists = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)application.getFolderId()).map((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$insert$1(this, application, id))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_BY_TITLE_IGNORECASE_GLOBAL(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())})), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$insert$4(x$2))).head())));
        if (exists) {
            throw new IllegalArgumentException(package$.MODULE$.alreadyExistsMessage("Application", application.getTitle(), (Option<String>)Option$.MODULE$.apply((Object)application.getFolderId())));
        }
        Map<String, Integer> environmentUids = this.getEnvironmentUids(application);
        Integer ciUid = this.securablePersistence().insert();
        String appId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(Application.class), this.ciIdService());
        String displayedAppId = package$.MODULE$.toDisplayId(appId);
        try {
            this.sqlExec(this.STMT_INSERT_APPLICATIONS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID()), Option$.MODULE$.apply((Object)application.getFolderId()).map((Function1 & Serializable)folderId -> this.folderPersistence().getUid(folderId)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)appId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())})), x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.execute()));
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException("Application with ID '" + displayedAppId + "' already exists", ex);
        }
        this.insertAppToEnvReferences(ciUid, (scala.collection.immutable.Set<Integer>)environmentUids.valuesIterator().toSet());
        return displayedAppId;
    }

    private String STMT_UPDATE_APPLICATIONS() {
        return this.STMT_UPDATE_APPLICATIONS;
    }

    private String STMT_EXISTS_ANOTHER_APP_WITH_TITLE_GLOBAL() {
        return this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE_GLOBAL;
    }

    private String STMT_EXISTS_ANOTHER_APP_WITH_TITLE_FOLDER() {
        return this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE_FOLDER;
    }

    public boolean update(Application application) {
        Integer applicationUid = (Integer)this.findUidById(application.getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Application [" + application.getId() + "] not found", new Object[0]);
        });
        this.sanitizeApplicationInput(application);
        boolean existsAnotherWithSameTitle = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)application.getFolderId()).map((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$update$2(this, application, applicationUid, id))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE_GLOBAL(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid)})), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$update$5(x$5))).head())));
        if (existsAnotherWithSameTitle) {
            throw new IllegalArgumentException(package$.MODULE$.alreadyExistsMessage("Application", application.getTitle(), (Option<String>)Option$.MODULE$.apply((Object)application.getFolderId())));
        }
        this.updateAppToEnvReferences(application, applicationUid);
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_APPLICATIONS(), this.paramMap2MapSqlParameterSource((Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())}))), (Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 == 1));
    }

    private String STMT_DELETE_APPLICATIONS_BY_ID() {
        return this.STMT_DELETE_APPLICATIONS_BY_ID;
    }

    public Try<Object> delete(String applicationId) {
        return (Try)this.sqlExec(this.STMT_DELETE_APPLICATIONS_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> ps.execute()));
    }

    public Option<Application> findById(String applicationId) {
        Tuple2<String, Seq<Object>> tuple2 = ApplicationSqlBuilder$.MODULE$.apply(ApplicationSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withApplicationId(package$.MODULE$.toPersistedId(applicationId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationResultSetExtractor());
    }

    public Option<Application> findByTitle(String title) {
        Tuple2<String, Seq<Object>> tuple2 = ApplicationSqlBuilder$.MODULE$.apply(ApplicationSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withTitle(title).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationResultSetExtractor());
    }

    public Option<Integer> findUidById(String applicationId) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n          |FROM " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + "\n          |WHERE " + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + " = :" + ApplicationSchema$APPLICATIONS$.MODULE$.ID()));
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), (Function1 & Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()))).headOption();
    }

    public Map<String, Integer> getUidsByIds(Iterable<String> applicationIds) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + ", " + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + "\n          |FROM " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + "\n          |WHERE " + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + " IN (:applicationIds)\n       "));
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationIds"), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)applicationIds.map((Function1 & Serializable)id -> package$.MODULE$.toPersistedId((String)id))).asJava())})), (Function1 & Serializable)rs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ResultSetExtension((ResultSet)rs).getCiId(ApplicationSchema$APPLICATIONS$.MODULE$.ID())), (Object)package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Seq<Application> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Seq)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationSearchResultSetExtractor());
    }

    private Map<String, Integer> getEnvironmentUids(Application application) {
        Map<String, Integer> environmentIdsToUids;
        if (CollectionUtils.isEmpty((Collection)application.getEnvironments())) {
            return Predef$.MODULE$.Map().empty();
        }
        scala.collection.immutable.Set environmentIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(application.getEnvironments()).asScala().map((Function1 & Serializable)x$10 -> x$10.getId())).toSet();
        scala.collection.immutable.Set environmentDiff = (scala.collection.immutable.Set)environmentIds.diff((Set)(environmentIdsToUids = this.environmentPersistence().getUidsByIds((Iterable<String>)environmentIds)).keySet());
        if (environmentDiff.nonEmpty()) {
            throw new NotFoundException("Environments [" + environmentDiff.mkString(", ") + "] not found", new Object[0]);
        }
        return environmentIdsToUids;
    }

    private void insertAppToEnvReferences(Integer applicationUid, scala.collection.immutable.Set<Integer> envUids) {
        String insertAppTpEnvStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE() + " (\n         |" + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID() + ",\n         |" + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID() + "\n         |)\n         |VALUES (\n         |:" + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID() + ",\n         |:" + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID() + "\n         |)\n       "));
        this.sqlBatch(insertAppTpEnvStmt, (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)envUids.map((Function1 & Serializable)envUid -> Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()), envUid)})))));
    }

    private void updateAppToEnvReferences(Application application, Integer applicationUid) {
        Map<String, Integer> envIdsToUids = this.getEnvironmentUids(application);
        String deleteAppToEnvRefsStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |DELETE FROM " + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE() + "\n         | WHERE\n         | " + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID() + " = :" + ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID() + "\n       "));
        this.sqlExec(deleteAppToEnvRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid)})), x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.execute()));
        this.insertAppToEnvReferences(applicationUid, (scala.collection.immutable.Set<Integer>)envIdsToUids.valuesIterator().toSet());
    }

    private void sanitizeApplicationInput(Application application) {
        application.setTitle(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(application.getTitle()), ApplicationSchema$.MODULE$.TITLE_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$insert$2(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$insert$1(ApplicationPersistence $this, Application application$1, String id) {
        return BoxesRunTime.unboxToBoolean((Object)$this.sqlQuery($this.STMT_EXISTS_BY_TITLE_IGNORECASE_FOLDER(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application$1.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID()), (Object)$this.folderPersistence().getUid(id))})), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$insert$2(x$1))).head());
    }

    public static final /* synthetic */ boolean $anonfun$insert$4(ResultSet x$2) {
        return x$2.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$3(ResultSet x$4) {
        return x$4.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$2(ApplicationPersistence $this, Application application$2, Integer applicationUid$1, String id) {
        return BoxesRunTime.unboxToBoolean((Object)$this.sqlQuery($this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE_FOLDER(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application$2.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID()), (Object)$this.folderPersistence().getUid(id)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid$1)})), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$update$3(x$4))).head());
    }

    public static final /* synthetic */ boolean $anonfun$update$5(ResultSet x$5) {
        return x$5.getInt(1) > 0;
    }

    @Autowired
    public ApplicationPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, EnvironmentPersistence environmentPersistence, FolderPersistence folderPersistence, SecurablePersistence securablePersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentPersistence = environmentPersistence;
        this.folderPersistence = folderPersistence;
        this.securablePersistence = securablePersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_INSERT_APPLICATIONS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|INSERT INTO " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + "\n        |   ( " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n        |   , " + ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID() + "\n        |   , " + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + "\n        |   , " + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + "\n        |   )\n        | VALUES\n        |   ( :" + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n        |   , :" + ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID() + "\n        |   , :" + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + "\n        |   , :" + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + "\n        |   )\n        "));
        this.STMT_EXISTS_BY_TITLE_IGNORECASE_FOLDER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT COUNT(*) FROM " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + " WHERE\n        |  LOWER(" + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + ") = LOWER(:" + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + ")\n        |  AND " + ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID() + " = :" + ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID()));
        this.STMT_EXISTS_BY_TITLE_IGNORECASE_GLOBAL = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT COUNT(*) FROM " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + " WHERE\n        |  LOWER(" + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + ") = LOWER(:" + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + ")\n        |  AND " + ApplicationSchema$APPLICATIONS$.MODULE$.FOLDER_UID() + " IS NULL"));
        this.STMT_UPDATE_APPLICATIONS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|UPDATE " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + "\n        | SET\n        |  " + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + " = :" + ApplicationSchema$APPLICATIONS$.MODULE$.TITLE() + "\n        | WHERE\n        |  " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + " = :" + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n       "));
        this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE_GLOBAL = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + this.STMT_EXISTS_BY_TITLE_IGNORECASE_GLOBAL() + "\n        |AND " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + " <> :" + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n       "));
        this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE_FOLDER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|" + this.STMT_EXISTS_BY_TITLE_IGNORECASE_FOLDER() + "\n        |AND " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + " <> :" + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n       "));
        this.STMT_DELETE_APPLICATIONS_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|DELETE FROM " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + "\n        | WHERE " + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + " = :" + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + "\n       "));
    }
}

