/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Gate", versioned=false, description="Click to learn more about Gate task")
public class GateTask
extends Task {
    private static final Logger logger = LoggerFactory.getLogger(GateTask.class);
    @Property(asContainment=true, required=false)
    private List<GateCondition> conditions = new ArrayList<GateCondition>();
    @Property(asContainment=true, required=false)
    private List<Dependency> dependencies = new ArrayList<Dependency>();

    @PublicApiMember
    public List<GateCondition> getConditions() {
        return this.conditions;
    }

    @PublicApiMember
    public void addCondition(GateCondition condition) {
        this.conditions.add(condition);
    }

    @PublicApiMember
    public GateCondition getCondition(String id) {
        return this.conditions.stream().filter(gc -> id.equals(gc.getId())).findFirst().orElse(null);
    }

    @PublicApiMember
    public boolean hasConditions() {
        return !this.conditions.isEmpty();
    }

    @PublicApiMember
    public void setConditions(List<GateCondition> conditions) {
        this.conditions = conditions;
    }

    @PublicApiMember
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @PublicApiMember
    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = new ArrayList<Dependency>(dependencies);
    }

    @PublicApiMember
    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    @PublicApiMember
    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
        dependency.setGateTask(this);
    }

    @Override
    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        Changes changes = super.execute(targetId, operation);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        changes.addPostAction(new ExecuteTaskAction(this));
        if (this.isCompletable()) {
            changes.addAll(this.markAsDone(this.getId(), TaskStatus.COMPLETED));
        } else if (this.hasAbortedDependencies()) {
            String titles = this.getAbortedDependencyTitles();
            changes.addAll(this.fail(this.getId(), FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(titles)));
        }
        return changes;
    }

    @Override
    public Changes markAsDone(String targetId, TaskStatus targetStatus) {
        if (targetStatus == TaskStatus.COMPLETED_IN_ADVANCE) {
            Preconditions.checkState((boolean)this.isOpenInAdvance(), (String)"All conditions and dependencies on gate '%s' must be fulfilled before completing it.", (Object)this.getTitle());
        } else if (targetStatus == TaskStatus.COMPLETED && this.getStatus() == TaskStatus.COMPLETED_IN_ADVANCE) {
            Preconditions.checkState((boolean)this.isOpenWithStatus(TaskStatus.COMPLETED_IN_ADVANCE), (String)"All conditions and dependencies on gate '%s' must be fulfilled before completing it.", (Object)this.getTitle());
        } else {
            Preconditions.checkArgument((targetStatus != TaskStatus.COMPLETED || this.isOpen() ? 1 : 0) != 0, (String)"All conditions and dependencies on gate '%s' must be fulfilled before completing it.", (Object)this.getTitle());
        }
        return super.markAsDone(targetId, targetStatus);
    }

    @PublicApiMember
    public boolean isOpen() {
        return this.isOpenWithStatus(TaskStatus.IN_PROGRESS);
    }

    private boolean isOpenInAdvance() {
        return this.isOpenWithStatus(TaskStatus.PLANNED);
    }

    private boolean isOpenWithStatus(TaskStatus requiredStatus) {
        if (this.getStatus() != requiredStatus) {
            logger.trace("isOpenWithStatus for {} returns false because status {} is not equal to required {}", new Object[]{this.getId(), this.getStatus(), requiredStatus});
            return false;
        }
        for (GateCondition condition : this.conditions) {
            if (condition.isChecked()) continue;
            logger.trace("isOpenWithStatus for {} returns false because condition {} is not checked", (Object)this.getId(), (Object)condition.getTitle());
            return false;
        }
        for (Dependency dependency : this.dependencies) {
            if (dependency.isDone()) continue;
            logger.trace("isOpenWithStatus for {} returns false because dependency {} is not done", (Object)this.getId(), (Object)dependency.getId());
            return false;
        }
        return true;
    }

    public boolean isCompletable() {
        return (this.hasConditions() || this.hasDependencies()) && this.isOpen();
    }

    @Override
    public Set<String> freezeVariablesInCustomFields(Map<String, ValueWithInterpolation> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet<String> unresolvedVariables = new HashSet<String>();
        for (GateCondition condition : this.conditions) {
            String oldTitle = condition.getTitle();
            String newTitle = VariableHelper.replaceAllWithInterpolation(oldTitle, variables, unresolvedVariables, freezeEvenIfUnresolved);
            if (newTitle.equals(oldTitle)) continue;
            condition.setTitle(newTitle);
            changes.update((ConfigurationItem)condition);
        }
        this.dependencies.stream().filter(d -> !Strings.isNullOrEmpty((String)d.getTargetId())).forEach(d -> {
            String resolvedTargetId;
            String targetId = d.getTargetId();
            if (!targetId.equals(resolvedTargetId = VariableHelper.replaceAllWithInterpolation(targetId, variables, unresolvedVariables, freezeEvenIfUnresolved))) {
                logger.trace("setting targetId (but not target) to {} for GateTask {}", (Object)resolvedTargetId, (Object)this.getId());
                d.setTargetId(resolvedTargetId);
                changes.update((ConfigurationItem)d);
            }
        });
        return unresolvedVariables;
    }

    public boolean hasAbortedDependencies() {
        for (Dependency dependency : this.dependencies) {
            if (!dependency.isAborted()) continue;
            return true;
        }
        return false;
    }

    public String getAbortedDependencyTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        for (Dependency dependency : this.dependencies) {
            if (!dependency.isAborted()) continue;
            titles.add(Strings.nullToEmpty((String)dependency.getTargetTitle()));
        }
        return Joiner.on((String)"', '").join(titles);
    }

    public void updateCondition(GateCondition gateCondition) {
        Optional<GateCondition> maybeGateCondition = this.conditions.stream().filter(condition -> condition.getId().equals(gateCondition.getId())).findFirst();
        if (maybeGateCondition.isPresent()) {
            int index = this.conditions.indexOf((Object)maybeGateCondition.get());
            this.conditions.set(index, gateCondition);
        }
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.addAll(this.getConditions().stream().map(condition -> new PropertyUsagePoint((ConfigurationItem)condition, "title")).collect(Collectors.toList()));
        usagePoints.addAll(this.getDependencies().stream().map(dependency -> new PropertyUsagePoint((ConfigurationItem)dependency, "targetId")).collect(Collectors.toList()));
        return usagePoints;
    }
}

