/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.insert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.AbstractMutationStatement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryPart;

public class InsertSelectStatement
extends AbstractMutationStatement
implements InsertStatement {
    public static final String DEFAULT_ALIAS = "to_insert_";
    private List<ColumnReference> targetColumnReferences;
    private QueryPart sourceSelectStatement;
    private List<Values> valuesList = new ArrayList<Values>();

    public InsertSelectStatement(NamedTableReference targetTable) {
        super(targetTable);
    }

    public InsertSelectStatement(NamedTableReference targetTable, List<ColumnReference> returningColumns) {
        super(new LinkedHashMap<String, CteStatement>(), targetTable, returningColumns);
    }

    public InsertSelectStatement(CteContainer cteContainer, NamedTableReference targetTable, List<ColumnReference> returningColumns) {
        this(cteContainer.getCteStatements(), targetTable, returningColumns);
    }

    public InsertSelectStatement(Map<String, CteStatement> cteStatements, NamedTableReference targetTable, List<ColumnReference> returningColumns) {
        super(cteStatements, targetTable, returningColumns);
    }

    @Override
    public List<ColumnReference> getTargetColumns() {
        return this.targetColumnReferences == null ? Collections.emptyList() : this.targetColumnReferences;
    }

    @Override
    public void forEachTargetColumn(BiConsumer<Integer, ColumnReference> consumer) {
        if (this.targetColumnReferences == null) {
            return;
        }
        for (int i = 0; i < this.targetColumnReferences.size(); ++i) {
            consumer.accept(i, this.targetColumnReferences.get(i));
        }
    }

    public void addTargetColumnReferences(ColumnReference ... references) {
        if (this.targetColumnReferences == null) {
            this.targetColumnReferences = new ArrayList<ColumnReference>();
        }
        Collections.addAll(this.targetColumnReferences, references);
    }

    public void addTargetColumnReferences(List<ColumnReference> references) {
        if (this.targetColumnReferences == null) {
            this.targetColumnReferences = new ArrayList<ColumnReference>();
        }
        this.targetColumnReferences.addAll(references);
    }

    public QueryPart getSourceSelectStatement() {
        return this.sourceSelectStatement;
    }

    public void setSourceSelectStatement(QueryPart sourceSelectStatement) {
        this.sourceSelectStatement = sourceSelectStatement;
    }

    public List<Values> getValuesList() {
        return this.valuesList;
    }

    public void setValuesList(List<Values> valuesList) {
        this.valuesList = valuesList;
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitInsertStatement(this);
    }
}

