/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.query.internal;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.query.NoOffset$;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.Offset$;
import org.apache.pekko.persistence.query.Sequence;
import org.apache.pekko.persistence.query.TimeBasedUUID;
import org.apache.pekko.persistence.query.TimestampOffset;
import org.apache.pekko.persistence.query.TimestampOffset$;
import org.apache.pekko.persistence.query.internal.protobuf.QueryMessages;
import org.apache.pekko.persistence.query.typed.EventEnvelope;
import org.apache.pekko.remote.serialization.WrappedPayloadSupport$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.Serializers$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md!\u0002\u000f\u001e\u0005\rJ\u0003\u0002C\u001a\u0001\u0005\u000b\u0007I\u0011A\u001b\t\u0011q\u0002!\u0011!Q\u0001\nYBQ!\u0010\u0001\u0005\u0002yBqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\t[\u0001A)\u0019!C\u0005\u0017\"9q\n\u0001b\u0001\n\u001b\u0001\u0006B\u0002+\u0001A\u00035\u0011\u000bC\u0004V\u0001\t\u0007IQ\u0002,\t\ri\u0003\u0001\u0015!\u0004X\u0011\u001dY\u0006A1A\u0005\u000eqCa\u0001\u0019\u0001!\u0002\u001bi\u0006bB1\u0001\u0005\u0004%iA\u0019\u0005\u0007M\u0002\u0001\u000bQB2\t\u000f\u001d\u0004!\u0019!C\u0007Q\"1A\u000e\u0001Q\u0001\u000e%Dq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004v\u0001\u0001\u0006Ia\u001c\u0005\bm\u0002\u0011\r\u0011\"\u0003o\u0011\u00199\b\u0001)A\u0005_\")\u0001\u0010\u0001C!s\"9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000bBq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002`\u0001!I!!\u0019\u0003\u001fE+XM]=TKJL\u0017\r\\5{KJT!AH\u0010\u0002\u0011%tG/\u001a:oC2T!\u0001I\u0011\u0002\u000bE,XM]=\u000b\u0005\t\u001a\u0013a\u00039feNL7\u000f^3oG\u0016T!\u0001J\u0013\u0002\u000bA,7n[8\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\n\u0004\u0001)\u0002\u0004CA\u0016/\u001b\u0005a#BA\u0017$\u00035\u0019XM]5bY&T\u0018\r^5p]&\u0011q\u0006\f\u0002\u001d'\u0016\u0014\u0018.\u00197ju\u0016\u0014x+\u001b;i'R\u0014\u0018N\\4NC:Lg-Z:u!\tY\u0013'\u0003\u00023Y\tq!)Y:f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AB:zgR,Wn\u0001\u0001\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR!!O\u0012\u0002\u000b\u0005\u001cGo\u001c:\n\u0005mB$aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\n\u0005C\u0001!\u0001\u001b\u0005i\u0002\"B\u001a\u0004\u0001\u00041\u0014a\u00017pOV\tA\t\u0005\u0002F\u00116\taI\u0003\u0002HG\u0005)QM^3oi&\u0011\u0011J\u0012\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0016\u00031\u0003\"aK'\n\u00059c#!D*fe&\fG.\u001b>bi&|g.A\u000bFm\u0016tG/\u00128wK2|\u0007/Z'b]&4Wm\u001d;\u0016\u0003E{\u0011AU\u0011\u0002'\u0006\t\u0011-\u0001\fFm\u0016tG/\u00128wK2|\u0007/Z'b]&4Wm\u001d;!\u0003Y\u0019V-];f]\u000e,wJ\u001a4tKRl\u0015M\\5gKN$X#A,\u0010\u0003a\u000b\u0013!W\u0001\u0004'\u0016\u000b\u0016aF*fcV,gnY3PM\u001a\u001cX\r^'b]&4Wm\u001d;!\u0003m!\u0016.\\3CCN,G-V+J\t>3gm]3u\u001b\u0006t\u0017NZ3tiV\tQlD\u0001_C\u0005y\u0016a\u0001+C+\u0006aB+[7f\u0005\u0006\u001cX\rZ+V\u0013\u0012{eMZ:fi6\u000bg.\u001b4fgR\u0004\u0013a\u0006+j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;NC:Lg-Z:u+\u0005\u0019w\"\u00013\"\u0003\u0015\f1\u0001V*P\u0003a!\u0016.\\3ti\u0006l\u0007o\u00144gg\u0016$X*\u00198jM\u0016\u001cH\u000fI\u0001\u0011\u001d>|eMZ:fi6\u000bg.\u001b4fgR,\u0012![\b\u0002U\u0006\n1.\u0001\u0002O\u001f\u0006\tbj\\(gMN,G/T1oS\u001a,7\u000f\u001e\u0011\u0002#5\fg.\u001b4fgR\u001cV\r]1sCR|'/F\u0001p!\t\u00018/D\u0001r\u0015\u0005\u0011\u0018!B:dC2\f\u0017B\u0001;r\u0005\u0011\u0019\u0005.\u0019:\u0002%5\fg.\u001b4fgR\u001cV\r]1sCR|'\u000fI\u0001\u0019i&lWm\u001d;b[B|eMZ:fiN+\u0007/\u0019:bi>\u0014\u0018!\u0007;j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;TKB\f'/\u0019;pe\u0002\n\u0001\"\\1oS\u001a,7\u000f\u001e\u000b\u0004u\u0006-\u0001cA>\u0002\u00069\u0019A0!\u0001\u0011\u0005u\fX\"\u0001@\u000b\u0005}$\u0014A\u0002\u001fs_>$h(C\u0002\u0002\u0004E\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002c\"9\u0011QB\u000bA\u0002\u0005=\u0011!A8\u0011\u0007A\f\t\"C\u0002\u0002\u0014E\u0014a!\u00118z%\u00164\u0017\u0001\u0003;p\u0005&t\u0017M]=\u0015\t\u0005e\u0011Q\u0005\t\u0006a\u0006m\u0011qD\u0005\u0004\u0003;\t(!B!se\u0006L\bc\u00019\u0002\"%\u0019\u00111E9\u0003\t\tKH/\u001a\u0005\b\u0003\u001b1\u0002\u0019AA\b\u0003)1'o\\7CS:\f'/\u001f\u000b\u0007\u0003\u001f\tY#a\f\t\u000f\u00055r\u00031\u0001\u0002\u001a\u0005)!-\u001f;fg\")\u0001p\u0006a\u0001u\u0006IbM]8n'R|'/Y4f%\u0016\u0004(/Z:f]R\fG/[8o)\u0019\t)$!\u0010\u0002BA!\u0011qGA\u001d\u001b\u0005y\u0012bAA\u001e?\t1qJ\u001a4tKRDa!a\u0010\u0019\u0001\u0004Q\u0018!C8gMN,Go\u0015;s\u0011\u0015A\b\u00041\u0001{\u0003]!xn\u0015;pe\u0006<WMU3qe\u0016\u001cXM\u001c;bi&|g\u000e\u0006\u0003\u0002H\u00055\u0003#\u00029\u0002JiT\u0018bAA&c\n1A+\u001e9mKJBq!a\u0014\u001a\u0001\u0004\t)$\u0001\u0004pM\u001a\u001cX\r^\u0001)i&lWm\u001d;b[B|eMZ:fi\u001a\u0013x.\\*u_J\fw-\u001a*faJ,7/\u001a8uCRLwN\u001c\u000b\u0005\u0003+\nY\u0006\u0005\u0003\u00028\u0005]\u0013bAA-?\tyA+[7fgR\fW\u000e](gMN,G\u000f\u0003\u0004\u0002^i\u0001\rA_\u0001\u0004gR\u0014\u0018A\n;j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;U_N#xN]1hKJ+\u0007O]3tK:$\u0018\r^5p]R\u0019!0a\u0019\t\u000f\u0005=3\u00041\u0001\u0002V!\u001a\u0001!a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\nYGA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public final class QuerySerializer
extends SerializerWithStringManifest
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final char manifestSeparator;
    private final char timestampOffsetSeparator;
    private int identifier;
    private volatile boolean bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Serialization serialization$lzycompute() {
        QuerySerializer querySerializer = this;
        synchronized (querySerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if (!this.bitmap$0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    private final String EventEnvelopeManifest() {
        return "a";
    }

    private final String SequenceOffsetManifest() {
        return "SEQ";
    }

    private final String TimeBasedUUIDOffsetManifest() {
        return "TBU";
    }

    private final String TimestampOffsetManifest() {
        return "TSO";
    }

    private final String NoOffsetManifest() {
        return "NO";
    }

    private char manifestSeparator() {
        return this.manifestSeparator;
    }

    private char timestampOffsetSeparator() {
        return this.timestampOffsetSeparator;
    }

    public String manifest(Object o) {
        Object object = o;
        if (object instanceof EventEnvelope) {
            return "a";
        }
        if (object instanceof Offset) {
            Offset offset = (Offset)object;
            return (String)this.toStorageRepresentation(offset)._2();
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Can't serialize object of type ").append(o.getClass()).append(" in [").append(this.getClass().getName()).append("]").toString());
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof EventEnvelope) {
            EventEnvelope eventEnvelope = (EventEnvelope)object;
            QueryMessages.EventEnvelope.Builder builder = QueryMessages.EventEnvelope.newBuilder();
            Tuple2<String, String> tuple2 = this.toStorageRepresentation(eventEnvelope.offset());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String offset = (String)tuple2._1();
            String offsetManifest = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)offset, (Object)offsetManifest);
            String offset2 = (String)tuple22._1();
            String offsetManifest2 = (String)tuple22._2();
            builder.setPersistenceId(eventEnvelope.persistenceId()).setEntityType(eventEnvelope.entityType()).setSlice(eventEnvelope.slice()).setSequenceNr(eventEnvelope.sequenceNr()).setTimestamp(eventEnvelope.timestamp()).setOffset(offset2).setOffsetManifest(offsetManifest2);
            eventEnvelope.eventOption().foreach((Function1 & Serializable)event -> builder.setEvent(WrappedPayloadSupport$.MODULE$.payloadBuilder(event, this.serialization(), this.log())));
            eventEnvelope.eventMetadata().foreach((Function1 & Serializable)meta -> builder.setMetadata(WrappedPayloadSupport$.MODULE$.payloadBuilder(meta, this.serialization(), this.log())));
            return builder.build().toByteArray();
        }
        if (object instanceof Offset) {
            Offset offset = (Offset)object;
            return ((String)this.toStorageRepresentation(offset)._1()).getBytes(StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Cannot serialize object of type [").append(o.getClass().getName()).append("]").toString());
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        String string = manifest;
        switch (string == null ? 0 : string.hashCode()) {
            case 97: {
                if (!"a".equals(string)) break;
                QueryMessages.EventEnvelope env = QueryMessages.EventEnvelope.parseFrom(bytes);
                Offset offset = this.fromStorageRepresentation(env.getOffset(), env.getOffsetManifest());
                None$ eventOption = env.hasEvent() ? Option$.MODULE$.apply(WrappedPayloadSupport$.MODULE$.deserializePayload(env.getEvent(), this.serialization())) : None$.MODULE$;
                None$ metaOption = env.hasMetadata() ? Option$.MODULE$.apply(WrappedPayloadSupport$.MODULE$.deserializePayload(env.getMetadata(), this.serialization())) : None$.MODULE$;
                return new EventEnvelope(offset, env.getPersistenceId(), env.getSequenceNr(), eventOption, env.getTimestamp(), (Option<Object>)metaOption, env.getEntityType(), env.getSlice());
            }
        }
        return this.fromStorageRepresentation(new String(bytes, StandardCharsets.UTF_8), manifest);
    }

    private Offset fromStorageRepresentation(String offsetStr, String manifest) {
        Object object;
        String string = manifest;
        switch (string == null ? 0 : string.hashCode()) {
            case 2497: {
                if (!"NO".equals(string)) break;
                return NoOffset$.MODULE$;
            }
            case 81983: {
                if (!"SEQ".equals(string)) break;
                return Offset$.MODULE$.sequence(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(offsetStr)));
            }
            case 82855: {
                if (!"TBU".equals(string)) break;
                return Offset$.MODULE$.timeBasedUUID(UUID.fromString(offsetStr));
            }
            case 83376: {
                if (!"TSO".equals(string)) break;
                return this.timestampOffsetFromStorageRepresentation(offsetStr);
            }
        }
        String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(manifest), this.manifestSeparator());
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
            String serializerIdStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String serializerManifest = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            int serializerId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(serializerIdStr));
            byte[] bytes = Base64.getDecoder().decode(offsetStr);
            Object object2 = this.serialization().deserialize(bytes, serializerId, serializerManifest).get();
            if (object2 instanceof Offset) {
                Offset offset = (Offset)object2;
                return offset;
            }
            throw new NotSerializableException(new StringBuilder(104).append("Unimplemented deserialization of offset with serializerId [").append(serializerId).append("] and manifest [").append(manifest).append("] ").append("in [").append(this.getClass().getName()).append("]. [").append(object2.getClass().getName()).append("] is not an Offset.").toString());
        }
        throw new NotSerializableException(new StringBuilder(93).append("Unimplemented deserialization of offset with manifest [").append(manifest).append("] ").append("in [").append(this.getClass().getName()).append("]. [").append(manifest).append("] doesn't contain two parts.").toString());
    }

    private Tuple2<String, String> toStorageRepresentation(Offset offset) {
        Offset offset2 = offset;
        if (offset2 instanceof TimestampOffset) {
            TimestampOffset timestampOffset = (TimestampOffset)offset2;
            return new Tuple2((Object)this.timestampOffsetToStorageRepresentation(timestampOffset), (Object)"TSO");
        }
        if (offset2 instanceof Sequence) {
            Sequence sequence = (Sequence)offset2;
            return new Tuple2((Object)Long.toString(sequence.value()), (Object)"SEQ");
        }
        if (offset2 instanceof TimeBasedUUID) {
            TimeBasedUUID timeBasedUUID = (TimeBasedUUID)offset2;
            return new Tuple2((Object)timeBasedUUID.value().toString(), (Object)"TBU");
        }
        if (NoOffset$.MODULE$.equals(offset2)) {
            return new Tuple2((Object)"", (Object)"NO");
        }
        Offset obj = offset;
        Serializer serializer = this.serialization().findSerializerFor((Object)obj);
        int serializerId = serializer.identifier();
        String serializerManifest = Serializers$.MODULE$.manifestFor(serializer, (Object)obj);
        byte[] bytes = serializer.toBinary((Object)obj);
        String offsetStr = Base64.getEncoder().encodeToString(bytes);
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(serializerManifest), this.manifestSeparator())) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Serializer manifest [").append(serializerManifest).append("] for ").append("offset [").append(offset.getClass().getName()).append("] must not contain [").append(this.manifestSeparator()).append("] character.").toString());
        }
        return new Tuple2((Object)offsetStr, (Object)new StringBuilder(0).append(serializerId).append(this.manifestSeparator()).append(serializerManifest).toString());
    }

    private TimestampOffset timestampOffsetFromStorageRepresentation(String str) {
        TimestampOffset timestampOffset;
        try {
            Object object;
            Object object2;
            Object object3;
            String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(str), this.timestampOffsetSeparator());
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object3 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 4) == 0) {
                String timestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 0);
                String readTimestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 1);
                String pid = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 2);
                String seqNr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 3);
                timestampOffset = new TimestampOffset(Instant.parse(timestamp), Instant.parse(readTimestamp), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pid), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seqNr))))}))));
            } else if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1) == 0) {
                String timestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                timestampOffset = TimestampOffset$.MODULE$.apply(Instant.parse(timestamp), (Map<String, Object>)Predef$.MODULE$.Map().empty());
            } else if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String timestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String readTimestamp = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                timestampOffset = new TimestampOffset(Instant.parse(timestamp), Instant.parse(readTimestamp), (Map<String, Object>)Predef$.MODULE$.Map().empty());
            } else {
                Map seen = Predef$.MODULE$.wrapRefArray((Object[])stringArray).toList().drop(2).grouped(2).map((Function1 & Serializable)x0$1 -> {
                    List list = x0$1;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        String pid = (String)colon2.head();
                        List list2 = colon2.next$access$1();
                        if (list2 instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list2;
                            String seqNr = (String)colon3.head();
                            List list3 = colon3.next$access$1();
                            if (Nil$.MODULE$.equals(list3)) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pid), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seqNr))));
                            }
                        }
                    }
                    throw new IllegalArgumentException(new StringBuilder(46).append("Invalid representation of Map(pid -> seqNr) [").append(Predef$.MODULE$.wrapRefArray((Object[])stringArray).toList().drop(1).mkString(",")).append("]").toString());
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                timestampOffset = new TimestampOffset(Instant.parse(stringArray[0]), Instant.parse(stringArray[1]), (Map<String, Object>)seen);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(48).append("Unexpected serialized TimestampOffset format [").append(str).append("].").toString(), e);
            }
            throw throwable;
        }
        return timestampOffset;
    }

    private String timestampOffsetToStorageRepresentation(TimestampOffset offset) {
        Object object;
        StringBuilder str = new StringBuilder();
        str.append(offset.timestamp()).append(this.timestampOffsetSeparator()).append(offset.readTimestamp());
        if (offset.seen().size() == 1) {
            String pid = (String)((Tuple2)offset.seen().head())._1();
            this.checkSeparator$1(pid, offset);
            long seqNr = ((Tuple2)offset.seen().head())._2$mcJ$sp();
            object = str.append(this.timestampOffsetSeparator()).append(pid).append(this.timestampOffsetSeparator()).append(seqNr);
        } else {
            if (offset.seen().nonEmpty()) {
                ((List)offset.seen().toList().sortBy((Function1 & Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String pid = (String)tuple2._1();
                        long seqNr = tuple2._2$mcJ$sp();
                        this.checkSeparator$1(pid, offset);
                        return str.append(this.timestampOffsetSeparator()).append(pid).append(this.timestampOffsetSeparator()).append(seqNr);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            object = BoxedUnit.UNIT;
        }
        return str.toString();
    }

    private final void checkSeparator$1(String pid, TimestampOffset offset$1) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(pid), this.timestampOffsetSeparator())) {
            throw new IllegalArgumentException(new StringBuilder(59).append("persistenceId [").append(pid).append("] in offset [").append(offset$1).append("] ").append("must not contain [").append(this.timestampOffsetSeparator()).append("] character").toString());
        }
    }

    public QuerySerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, QuerySerializer.class, LogSource$.MODULE$.fromAnyClass());
        this.manifestSeparator = (char)58;
        this.timestampOffsetSeparator = (char)59;
        Statics.releaseFence();
    }
}

