/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.jms.client.Subscription;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class Subscriptions {
    private final Map<String, Subscription> nonDurableSubscriptions = new ConcurrentHashMap<String, Subscription>();
    private final Map<String, Subscription> durableSubscriptions = new ConcurrentHashMap<String, Subscription>();

    Subscriptions() {
    }

    Subscription register(String name, String queue, boolean durable, boolean shared, String selector, boolean noLocal) {
        Map<String, Subscription> subscriptions = durable ? this.durableSubscriptions : this.nonDurableSubscriptions;
        return subscriptions.computeIfAbsent(name, n -> new Subscription(this, name, queue, durable, shared, selector, noLocal));
    }

    Subscription get(boolean durable, String name) {
        return durable ? this.durableSubscriptions.get(name) : this.nonDurableSubscriptions.get(name);
    }

    Subscription remove(boolean durable, String name) {
        return durable ? this.durableSubscriptions.remove(name) : this.nonDurableSubscriptions.remove(name);
    }
}

